/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.IMerlinDispProps;
import merlin.geom.IMerlinGeomSrc;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class QueuePath
extends GeomComposite<QueuePathNode>
implements IQueueElement,
IEgressObj,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<QueuePath> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(QueuePath.class, null, GeomComposite.PROP_TYPES, Filters.reject(GeomComposite.STORED_VISIBILITY));
    static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    public static final DisplayProp<Boolean> FOLLOW_PATH = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"QueuePath.FOLLOW_PATH", false, Intl.intl("Force Follow Path"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(QueuePath::isForceFollowPath, Stream.empty()).attrSetter(QueuePath::setForceFollowPath, null).attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();
    public static final DisplayProp<IDistributedVal<UnitDouble>> CUSTOM_SPACING = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("QueuePath.CUSTOM_SPACING", IDistributedVal.class, new ConstantCurve(new UnitDouble(1.0, SI.METER)), Intl.intl("Occupant Spacing"), "").attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(QueuePath::getCustomSpacing, Stream.empty()).attrSetter(QueuePath::setCustomSpacingAmt, null).attrComparisonEditor(PropComparisons.factory().distributedValue(0)).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrGetter(QueuePath::getTags, Stream.empty()).attrSetter(QueuePath::setTags, null).attrFinish();
    public static final DisplayProp<ObjsFilter<OccProfile>> RESTRICTED_PROFILES = QueueObject.defineRestrictedProfiles(PROP_TYPES).attrGetter(QueuePath::getRestrictedProfiles, Stream.empty()).attrSetter(QueuePath::setRestrictedProfiles, (obj, val) -> {
        obj.d_restrictedProfiles = val;
    }).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = GeomComposite.defineVisibilityLocally(PROP_TYPES, false);
    private boolean d_forceFollowPath = false;
    private IDistributedVal<UnitDouble> d_customSpacingAmt = new ConstantCurve(new UnitDouble(1.0, SI.METER));
    @SkipDep
    private Object d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
    private transient IGeom d_lastKnownGeom;
    private transient IGeom d_restorePointGeom;
    private transient int d_numNodes;
    private Set<Tag> d_tags = Collections.emptySet();
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(QueuePathNode.class);

    public QueuePath(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.d_customSpacingAmt == null) {
            this.d_customSpacingAmt = new ConstantCurve(new UnitDouble(1.0, SI.METER));
        }
        if (this.d_restrictedProfiles == null) {
            this.d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
        }
        if (this.d_tags == null) {
            this.d_tags = new LinkedIdentityHashSet<Tag>();
        }
        this.d_numNodes = this.getNodes().size();
        this.updateGeom();
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueuePath qp = (QueuePath)obj;
        return super.cyclicEquals(obj, comparedSet) && theUtil.surrogateListsEqual(this.getMembers(), qp.getMembers(), comparedSet);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public boolean isForceFollowPath() {
        return this.d_forceFollowPath;
    }

    public void setForceFollowPath(boolean isForced) {
        if (this.d_forceFollowPath == isForced) {
            return;
        }
        this.d_forceFollowPath = isForced;
        this.changedEvt(FOLLOW_PATH);
    }

    public IDistributedVal<UnitDouble> getCustomSpacing() {
        return this.d_customSpacingAmt;
    }

    public void setCustomSpacingAmt(IDistributedVal<UnitDouble> val) {
        if (Objects.equals(this.d_customSpacingAmt, val)) {
            return;
        }
        this.d_customSpacingAmt = val;
        this.changedEvt(CUSTOM_SPACING);
    }

    public ObjsFilter<OccProfile> getRestrictedProfiles() {
        return (ObjsFilter)this.d_restrictedProfiles;
    }

    @Deprecated
    public Set<OccProfile> getLegacyRestrictedProfiles() {
        return (Set)this.d_restrictedProfiles;
    }

    public List<String> getRestrictedProfiles_Strings() {
        return QueueObject.getRestrictedProfiles_Strings((MerlinData)this.getDomain(), this.getRestrictedProfiles());
    }

    public void setRestrictedProfiles(ObjsFilter<OccProfile> profs) {
        if (Objects.equals(this.d_restrictedProfiles, profs)) {
            return;
        }
        this.d_restrictedProfiles = profs;
        this.changedEvt(QueueObject.RESTRICTED_PROFILES);
    }

    public Set<Tag> getTags() {
        return this.d_tags;
    }

    public void setTags(Set<Tag> tags) {
        if (Objects.equals(this.d_tags, tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    @Override
    public QueuePath getRestoreObj() {
        QueuePath restorePoint = (QueuePath)super.getRestoreObj();
        restorePoint.d_restorePointGeom = restorePoint.d_lastKnownGeom;
        return restorePoint;
    }

    @Override
    public QueuePath clone() {
        return (QueuePath)super.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueuePath)) {
            return;
        }
        QueuePath qp = (QueuePath)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        if (qp.d_restorePointGeom != null) {
            this.setGeom(qp.d_restorePointGeom);
        }
        this.d_restorePointGeom = null;
        this.resumeUpdates();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        this.pauseUpdates();
        if (geom instanceof PolyLine) {
            PolyLine pLine = (PolyLine)geom;
            if (pLine.verts.length == this.getNodes().size()) {
                int ix = 0;
                for (QueuePathNode node : this.getNodes()) {
                    node.setLocation(pLine.verts[ix++]);
                }
            }
        } else if (geom instanceof Point && this.getNodes().size() == 1) {
            Point p = (Point)geom;
            this.getNodes().iterator().next().setLocation(p.loc);
        }
        this.resumeUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeomNode getGeom() {
        if (this.d_numNodes == this.getMembers(QueuePathNode.class).size()) {
            QueuePath queuePath = this;
            synchronized (queuePath) {
                this.updateGeom();
            }
        }
        return GeomNodeUtil.newNode(this.d_lastKnownGeom);
    }

    private void updateGeom() {
        if (this.getMembers(QueuePathNode.class).size() >= 2) {
            Point3d[] points = new Point3d[this.getMembers(QueuePathNode.class).size()];
            int ix = 0;
            for (QueuePathNode node : this.getMembers(QueuePathNode.class)) {
                points[ix++] = node.getLocation();
            }
            this.d_lastKnownGeom = new PolyLine(points);
        } else if (this.getMembers(QueuePathNode.class).size() == 1) {
            QueuePathNode node = this.getMembers(QueuePathNode.class).iterator().next();
            this.d_lastKnownGeom = new Point(node.getLocation());
        } else {
            this.d_lastKnownGeom = EmptyGeom.INSTANCE;
        }
    }

    @Override
    public void add(IMerlinObj obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends IMerlinObj> objs) {
        super.addAll(theUtil.filter(objs, QueuePathNode.class));
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.getMembers(IEgressObj.class);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        for (IMerlinObj comp : this.getMembers()) {
            if (!((QueuePathNode)comp).hasOpenSpots(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
    }

    @Override
    public void connectTo(IEgressObj conn) {
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean updateTopo() {
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return ((QueuePathNode)this.getMembers().iterator().next()).astarProject(obj, p);
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return ((QueuePathNode)this.getMembers().iterator().next()).astarGetSharedPt(adj);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps globalProps = (IMerlinDispProps)dprops;
        ArrayList<QueuePathNode> nodes = new ArrayList<QueuePathNode>(this.getMembers(QueuePathNode.class));
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        if (nodes.size() < 2) {
            return DisplayGeom.EMPTY;
        }
        PropsBuilder propBuilder = new PropsBuilder();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            geoms.addAll(this.getGeomsForSegment(propBuilder, globalProps, (QueuePathNode)nodes.get(i), (QueuePathNode)nodes.get(i + 1)));
        }
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(GeomUtil.group(geoms)), propBuilder.finalizeProps());
    }

    private Collection<IGeom> getGeomsForSegment(PropsBuilder drawProps, IMerlinDispProps globalProps, QueuePathNode node1, QueuePathNode node2) {
        Point3d p2;
        Point3d p1 = node1.getLocation();
        if (p1.equals(p2 = node2.getLocation())) {
            return Collections.emptyList();
        }
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        double arrowSize = 0.25;
        Vector3d dir = Util3D.vectorN(p1, p2);
        Vector3d planeNormal = node2.getFaceNormal();
        Vector3d perpDir = Util3D.cross(dir, planeNormal);
        Point3d t1 = new Point3d(p2);
        Vector3d scaledPerpDir = Util3D.scale(perpDir, arrowSize);
        Point3d temp = Util3D.sub(p2, (Tuple3d)Util3D.scale(dir, arrowSize));
        Point3d t2 = Util3D.add(temp, (Tuple3d)scaledPerpDir);
        Point3d t3 = Util3D.sub(temp, (Tuple3d)scaledPerpDir);
        TransformInfo ti = TransformUtil.translate(0.0, 0.0, 0.003).getInfo();
        Color c = Color.BLACK;
        float opacity = 1.0f;
        if (this.getDomain() != null) {
            QueueObject parent = (QueueObject)((MerlinData)this.getDomain()).hierarchy.getParent(this);
            c = parent.getColor();
            opacity = parent.getOpacity();
        }
        IPrimProps fprops = globalProps.getFaceProps(this, IMerlinDispProps.EgressType.QUEUE_PATH, null, c, opacity);
        IPrimProps deprops = globalProps.getEdgeProps(this, IMerlinDispProps.EgressType.QUEUE_PATH, c, opacity);
        Triangle t = new Triangle(t1, t2, t3).transform(ti, 0);
        geoms.add(t);
        drawProps.add(fprops);
        LineSeg line = new LineSeg(p1, p2).transform(ti, 0);
        geoms.add(line);
        drawProps.add(deprops);
        return geoms;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    public Collection<QueuePathNode> getNodes() {
        return this.getMembers(QueuePathNode.class);
    }

    @Override
    protected void doModify() {
        this.d_numNodes = this.getNodes().size();
    }

    public static Collection<IMerlinGeomSrc> pruneQueueTransforms(MerlinData md, Collection<? extends IMerlinGeomSrc> unprunedCollection) {
        Collection forSureKeep = unprunedCollection.stream().filter(obj -> !(obj instanceof QueuePathNode)).collect(Collectors.toList());
        Collection nodes = unprunedCollection.stream().filter(obj -> obj instanceof QueuePathNode).map(obj -> (QueuePathNode)obj).collect(Collectors.toList());
        ArrayList<QueuePathNode> nodesToKeep = new ArrayList<QueuePathNode>();
        for (QueuePathNode node : nodes) {
            if (forSureKeep.contains(md.hierarchy.getParent(node))) continue;
            nodesToKeep.add(node);
        }
        forSureKeep.addAll(nodesToKeep);
        return forSureKeep;
    }
}

