/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import common.data.WaitMode;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.AssistedEvacTeam;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.AWaitAction;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class WaitForAssistance
extends AWaitAction
implements IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<WaitForAssistance> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(WaitForAssistance.class, null, AWaitAction.PROP_TYPES, Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<AssistedEvacTeam>> TEAMS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("WaitForAssistance.TEAMS", Set.class, DisplayProps.emptySet(AssistedEvacTeam.class), Intl.intl("Assisting Teams"), Intl.intl("The teams that will assist the occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(teams -> MerlinUtil.formatNamedSet(teams, Intl.intl("[any]")))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, AssistedEvacTeam.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getEvacTeams(md, null))).attrFinish();
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsReadOnly(NamedMerlinObj.NAME).attrGetter(WaitForAssistance::getName, TEAMS).attrFinish();

    public WaitForAssistance(Set<AssistedEvacTeam> teams) {
        this.set(TEAMS, teams);
        this.set(MODE, WaitMode.WAIT_IN_PLACE_COLLISIONS);
    }

    public Predicate<AssistedEvacTeam> getTeamFilter() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        return teams.isEmpty() ? Predicates.alwaysTrue() : Filters.accept(teams);
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        if (teams.size() == 1) {
            return String.format(Intl.intl("Wait for assistance <%s>"), teams.iterator().next().getName());
        }
        if (teams.isEmpty()) {
            return Intl.intl("Wait for assistance <any team>");
        }
        return Intl.intl("Wait for assistance");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

