/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class GotoRooms
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 2349523402345098738L;
    public static final PropertyDefs<GotoRooms> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoRooms.class, PropertyDefsFramework.none(), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<IEgressOccupiable>> PROP_ROOMS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoRooms.ROOMS", Set.class, DisplayProps.emptySet(IEgressOccupiable.class), Intl.intl("Rooms"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(rooms -> MerlinUtil.formatNamedSet(rooms, Intl.intl("[none]")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoRooms::getRooms, Stream.empty()).attrSetter(GotoRooms::setRooms, null).attrDependency(prop -> Dependencies.newDependency(prop, DLink.WEAK, IEgressOccupiable.class, (md, src, set) -> set.stream(), (md, src) -> src.getFilter(), (md, src, set, old, repl) -> Dependencies.replaceSetValue(set, old, repl))).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getRooms(md, null))).attrFinish();
    public static final TypedProp<Predicate<? super IEgressOccupiable>> PROP_FILTER = TypedProps.build("GotoRooms.FILTER", theUtil.makeGeneric(Predicate.class), Predicates.alwaysTrue()).attrStoreAsReadOnly(PROP_TYPES).attrGetter(GotoRooms::getFilter, Stream.empty()).attrSurrogateEquals(PropertyDefsFramework::defaultSurrogateEquals).attrFinish();
    public static final DisplayProp<String> NAME = GotoRooms.buildCustomNameProp(PROP_TYPES).attrGetter(GotoRooms::formatName, Stream.of(STORED_NAME, PROP_FILTER, PROP_ROOMS)).attrFinish();
    private Set<IEgressOccupiable> d_rooms;
    private Predicate<? super IEgressOccupiable> d_filter;

    public GotoRooms(Predicate<? super IEgressOccupiable> filter, Set<IEgressOccupiable> rooms) {
        super(null);
        this.d_rooms = rooms;
        this.d_filter = filter;
    }

    public static boolean getAnyAllowed(Predicate<? super IEgressOccupiable> filter) {
        return !Predicates.alwaysTrue(filter);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_filter == null) {
            this.d_filter = Predicates.alwaysTrue();
        }
    }

    public boolean getAnyAllowed() {
        return GotoRooms.getAnyAllowed(this.d_filter);
    }

    @Override
    public boolean mustBeLast() {
        return this.d_filter instanceof IFilter && ((IFilter)this.d_filter).isTerminal();
    }

    @Override
    public boolean isTerminal() {
        return this.mustBeLast();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public Set<IEgressOccupiable> getRooms() {
        return Collections.unmodifiableSet(this.d_rooms);
    }

    public void setRooms(Set<IEgressOccupiable> rooms) {
        if (!theUtil.setsEqual(this.d_rooms, rooms)) {
            this.d_rooms = rooms;
            this.changedEvt(PROP_ROOMS);
        }
    }

    public Predicate<? super IEgressOccupiable> getFilter() {
        return this.d_filter;
    }

    private String formatName() {
        String name = super.getStoredName();
        if (name != null) {
            return name;
        }
        if (this.d_filter instanceof IFilter) {
            String filterName = ((IFilter)this.d_filter).getName();
            if (this.d_rooms.size() == 1) {
                return String.format(Intl.intl("Goto %1$s <%2$s>"), filterName, this.d_rooms.iterator().next().getName());
            }
            return String.format(Intl.intl("Goto %s Rooms"), filterName);
        }
        if (this.d_rooms.size() == 1) {
            return String.format(Intl.intl("Goto %s"), this.d_rooms.iterator().next().getName());
        }
        return String.format(Intl.intl("Goto Rooms"), new Object[0]);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        MerlinData md;
        Collection<IEgressOccupiable> destRooms = this.d_rooms;
        if (destRooms.isEmpty() && this.getAnyAllowed() && (md = (MerlinData)this.getDomain()) != null) {
            destRooms = md.floors.flatten(IEgressOccupiable.class, this.d_filter);
        }
        return new Destination(this, this.d_rooms, destRooms);
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (IEgressOccupiable room : this.getRooms()) {
            hash = 31 * hash + theUtil.hashCode(room);
        }
        return 31 * hash + theUtil.hashCode(this.get(PROP_FILTER));
    }

    public static interface IFilter
    extends Predicate<IEgressOccupiable> {
        public String getName();

        public boolean isTerminal();
    }

    public static class Destination
    implements IDestination {
        private final IMerlinObj d_sourceObj;
        private final Set<IEgressOccupiable> d_rooms;
        private final Collection<IEgressOccupiable> d_destRooms;

        public Destination(IMerlinObj sourceObj, Set<IEgressOccupiable> inputRooms, Collection<IEgressOccupiable> finalRooms) {
            this.d_sourceObj = sourceObj;
            this.d_rooms = inputRooms;
            this.d_destRooms = finalRooms;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getRooms().equals(this.d_rooms);
        }

        @Override
        public int hashCode() {
            return 0xFAAFE324 ^ this.d_rooms.hashCode();
        }

        protected Set<IEgressOccupiable> getRooms() {
            return this.d_rooms;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            Collection<IEgressOccupiable> rooms = this.d_destRooms;
            if (this.d_rooms != this.d_destRooms) {
                if (MerlinUtil.isConnected(source, rooms)) {
                    return null;
                }
                return this.allRoomsUnreachable(source, this.d_destRooms);
            }
            ArrayList<IEgressOccupiable> unreachable = new ArrayList<IEgressOccupiable>(this.d_rooms.size());
            for (IEgressOccupiable room : this.d_rooms) {
                if (MerlinUtil.isConnected(source, room)) continue;
                unreachable.add(room);
            }
            if (unreachable.size() == this.d_rooms.size()) {
                return this.allRoomsUnreachable(source, this.d_rooms);
            }
            if (!unreachable.isEmpty()) {
                return this.someRoomsUnreachable(source, unreachable);
            }
            return null;
        }

        private IUnreachable allRoomsUnreachable(IEgressComp csource, Collection<? extends IEgressOccupiable> rooms) {
            return source -> {
                String name = MerlinUtil.getName(source);
                String cname = MerlinUtil.getName(csource);
                String thisname = MerlinUtil.getName(this.d_sourceObj);
                return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("Error in \"%1$s\": \"%2$s\" is not connected to any rooms in \"%3$s\"."), name, cname, thisname), String.format(Intl.intl("Connect \"%1$s\" to at least one room in \"%2$s\"."), cname, thisname), this.collect(source, csource, rooms));
            };
        }

        private IUnreachable someRoomsUnreachable(IEgressComp csource, Collection<? extends IEgressOccupiable> rooms) {
            return source -> {
                String name = MerlinUtil.getName(source);
                String cname = MerlinUtil.getName(csource);
                String thisname = MerlinUtil.getName(this.d_sourceObj);
                return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Error in \"%1$s\": \"%2$s\" is not connected to %3$d rooms of \"%4$s\"."), name, cname, rooms.size(), thisname), String.format(Intl.intl("Connect \"%1$s\" with the rooms specified in \"%2$s\"."), cname, thisname), this.collect(source, csource, rooms));
            };
        }

        private List<IMerlinObj> collect(IMerlinObj source, IEgressComp csrc, Collection<? extends IEgressOccupiable> rooms) {
            ArrayList<IMerlinObj> objs = new ArrayList<IMerlinObj>(1 + rooms.size());
            objs.add(source);
            if (csrc != source) {
                objs.add(csrc);
            }
            if (this.d_sourceObj != source) {
                objs.add(this.d_sourceObj);
            }
            objs.addAll(rooms);
            return objs;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return this.d_destRooms;
        }
    }
}

