/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class GotoQueue
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    @Deprecated
    public static final IPropertySet.Prop<QueueObject> PROP_QUEUES = new IPropertySet.Prop<Object>("GotoQueue.QUEUES", null);
    @Deprecated
    public static final IPropertySet.Prop<Set<QueueObject>> PROP_QUEUE_OBJECTS = new IPropertySet.Prop("GotoQueue.QUEUE_OBJECTS", Collections.emptySet());
    @Deprecated
    public static final IPropertySet.Prop<Set<QueueObjectComp>> PROP_QUEUE_COMPS = new IPropertySet.Prop("GotoQueue.QUEUE_COMPS", Collections.emptySet());
    public static final PropertyDefs<GotoQueue> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoQueue.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<IGotoQueueDestination>> PROP_QUEUE_DESTINATIONS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoQueue.QUEUE_DESTINATION", Set.class, DisplayProps.emptySet(IGotoQueueDestination.class), Intl.intl("Queue"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(queues -> MerlinUtil.formatNamedSet(queues, Intl.intl("[none]")))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependency(prop, DLink.WEAK, IGotoQueueDestination.class, (md, src, set) -> set.stream(), (md, q) -> src -> src != md.queues, (md, src, set, old, repl) -> Dependencies.replaceSetValue(set, old, repl))).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getQueueDestinations(md, Intl.intl("[none]")))).attrFinish();
    public static final DisplayProp<String> NAME = GotoQueue.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        IGotoQueueDestination dest;
        String name = obj.getStoredName();
        if (name != null) {
            return name;
        }
        Set<IGotoQueueDestination> dests = obj.getDestinations();
        if (dests.size() == 1 && (dest = dests.iterator().next()) != null) {
            return String.format(Intl.intl("Goto %s"), dest.getName());
        }
        return Intl.intl("Goto Queues");
    }, Stream.of(STORED_NAME, PROP_QUEUE_DESTINATIONS)).attrFinish();
    private PropertySet d_props = new PropertySet();
    @Deprecated
    private QueueObject d_queue;

    public GotoQueue(IGotoQueueDestination queue) {
        this(Collections.singleton(queue));
    }

    public GotoQueue(Set<IGotoQueueDestination> queues) {
        super(null);
        this.set(PROP_QUEUE_DESTINATIONS, queues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0143)) {
            this.d_props = new PropertySet();
            LinkedIdentityHashSet qObjs = new LinkedIdentityHashSet();
            qObjs.add(this.d_queue);
            this.d_props.set(PROP_QUEUE_OBJECTS, qObjs);
            this.d_props.set(PROP_QUEUE_COMPS, Collections.emptySet());
            this.d_queue = null;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0144)) {
            Set<QueueObject> queues = this.d_props.get(PROP_QUEUE_OBJECTS);
            Set<QueueObjectComp> groups = this.d_props.get(PROP_QUEUE_COMPS);
            this.d_props.remove(PROP_QUEUE_OBJECTS);
            this.d_props.remove(PROP_QUEUE_COMPS);
            LinkedIdentityHashSet destinations = new LinkedIdentityHashSet();
            destinations.addAll(queues);
            destinations.addAll(groups);
            this.set(PROP_QUEUE_DESTINATIONS, destinations.isEmpty() ? Collections.emptySet() : destinations);
        }
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public Set<IGotoQueueDestination> getDestinations() {
        return this.get(PROP_QUEUE_DESTINATIONS);
    }

    public Set<QueueObject> getExplicitQueues() {
        return theUtil.filter(this.getDestinations(), QueueObject.class);
    }

    public Collection<QueueObject> getQueues() {
        return MerlinUtil.flatten(this.getDestinations(), QueueObject.class);
    }

    public Set<QueueObjectComp> getQueueComps() {
        return theUtil.filter(this.getDestinations(), QueueObjectComp.class);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

