/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class GotoOccTarget
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<GotoOccTarget> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoOccTarget.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<OccTarget>> PROP_TARGETS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoOccTarget.LOCATIONS ", Set.class, DisplayProps.emptySet(OccTarget.class), Intl.intl("Occ Targets"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(targets -> MerlinUtil.formatNamedSet(targets, Intl.intl("[any]")))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, OccTarget.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getOccTargets(md, Intl.intl("[any]")))).attrFinish();
    public static final TypedProp<Predicate<? super OccTarget>> PROP_FILTER = TypedProps.build("GotoOccTarget.FILTER", theUtil.makeGeneric(Predicate.class), Predicates.alwaysTrue()).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOccTarget.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the distance<br>to the target. This is secondary to the <b>Priority Preference</b>,<br>but also helps define how the occupant chooses a target.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(DistancePref.values())).attrFinish();
    public static final DisplayProp<PriorityPref> PROP_PRIORITY_PREF = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOccTarget.PRIORITY_PREF", PriorityPref.class, PriorityPref.HIGHER, Intl.intl("Priority Preference"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the<br>target's priority. This interacts with the <b>Distance Preference</b><br>to define how the occupant chooses a target.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(PriorityPref.values())).attrFinish();
    public static final DisplayProp<String> NAME = GotoOccTarget.buildCustomNameProp(PROP_TYPES).attrGetter(GotoOccTarget::formatName, Stream.of(STORED_NAME, PROP_FILTER, PROP_TARGETS)).attrFinish();
    private PropertySet d_props = new PropertySet();

    public GotoOccTarget(Predicate<? super OccTarget> filter, Set<OccTarget> locations) {
        super(null);
        this.set(PROP_FILTER, filter);
        this.set(PROP_TARGETS, locations);
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    private String formatName() {
        String name = super.getStoredName();
        if (name != null) {
            return name;
        }
        Predicate<? super OccTarget> filter = this.get(PROP_FILTER);
        Collection locations = this.get(PROP_TARGETS);
        if (filter instanceof IFilter) {
            String filterName = filter.toString();
            if (this.get(PROP_TARGETS).size() == 1) {
                return String.format(Intl.intl("Goto %1$s <%2$s>"), filterName, ((OccTarget)locations.iterator().next()).getName());
            }
            return String.format(Intl.intl("Goto %s Occ Targets"), filterName);
        }
        if (locations.size() == 1) {
            return String.format(Intl.intl("Goto %s"), ((OccTarget)locations.iterator().next()).getName());
        }
        if (locations.isEmpty()) {
            return Intl.intl("Goto Any Occ Target");
        }
        return String.format(Intl.intl("Goto Occ Targets"), new Object[0]);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        MerlinData md;
        Function<Collection, Set> toRooms = locs -> new LinkedIdentityHashSet<IEgressOccupiable>(theUtil.map(locs, loc -> loc.getRoom()));
        Set d_rooms = toRooms.apply(this.get(PROP_TARGETS));
        Collection destRooms = d_rooms;
        if (destRooms.isEmpty() && (md = (MerlinData)this.getDomain()) != null) {
            destRooms = toRooms.apply(md.occTargets.flatten(OccTarget.class, this.get(PROP_FILTER)));
        }
        return new GotoRooms.Destination(this, d_rooms, destRooms);
    }

    public static interface IFilter
    extends Predicate<OccTarget> {
        public String toString();
    }

    public static enum PriorityPref implements ILabeled
    {
        NONE(Intl.intl("None"), Intl.intl("The occupant does not consider target priority when choosing a target.")),
        LOWER(Intl.intl("Lower"), Intl.intl("The occupant prefers targets with lower priority.")),
        HIGHER(Intl.intl("Higher"), Intl.intl("The occupant prefers targets with higher priority."));

        public final String name;
        public final String desc;

        private PriorityPref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static enum DistancePref implements ILabeled
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A target is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available target is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

