/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.ObjSources;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class GotoOcc
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<GotoOcc> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoOcc.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<Tag>> PROP_GOTO_TAGS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoOcc.TAGS ", Set.class, theUtil.emptySet(Tag.class), Intl.intl("Occupant Tags"), Intl.intl("Defines the tags used to find a destination occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(tags -> StringTagsUtil.format(TagsUtil.tagsAsStrings(tags)))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(TagsUtil::getTagCallback).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getTags(md, null))).attrFinish();
    public static final DisplayProp<TagLogic> PROP_TAG_LOGIC = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.TAG_LOGIC ", TagLogic.class, TagLogic.ALL, Intl.intl("Tag Logic"), Intl.intl("Defines how the tags are combined in order to find a destination occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(logic -> logic.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TagLogic.values())).attrFinish();
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), Intl.intl("Defines the occupant's preference for a destination occupant based on the distance\nto the occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(DistancePref.values())).attrFinish();
    public static final DisplayProp<Tracking> PROP_TRACKING = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.TRACKING", Tracking.class, Tracking.DYNAMIC_ONCE, Intl.intl("Tracking"), Intl.intl("Defines how the source occupant will track the destination occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(Tracking.values())).attrFinish();
    public static final DisplayProp<UnitDouble> PROP_ARRIVAL_RADIUS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.ARRIVAL_RADIUS", new UnitDouble(1.0, SI.METER), Intl.intl("Arrival Radius"), Intl.intl("The distance to the destination occupant at which the source occupant\ndecides they have reached the destination."), 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<TargetNotFound> PROP_NO_OCCUPANTS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.PROP_NO_OCCUPANTS", TargetNotFound.class, TargetNotFound.SKIP, Intl.intl("No available occupants"), Intl.intl("Defines what to do if there are no occupants matching the tag\ncriteria when the action is started.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TargetNotFound.values())).attrFinish();
    public static final DisplayProp<TargetUnreachable> PROP_UNREACHABLE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOcc.PROP_UNREACHABLE", TargetUnreachable.class, TargetUnreachable.SKIP, Intl.intl("Destination unreachable"), Intl.intl("Defines what to do if the current destination occupant becomes unreachable,\nsuch as if all paths to the destination become blocked.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TargetUnreachable.values())).attrFinish();
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsReadOnly(NamedMerlinObj.NAME).attrGetter(obj -> GotoOcc.formatName(obj.get(PROP_TAG_LOGIC), obj.get(PROP_GOTO_TAGS).stream().map(Tag::toString).collect(Collectors.toSet())), Stream.of(PROP_TAG_LOGIC, PROP_GOTO_TAGS)).attrFinish();
    static final CompositeProp TAGS_COMPOSITE = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(PROP_GOTO_TAGS, PROP_TAG_LOGIC).attrMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    private PropertySet d_props = new PropertySet();

    public GotoOcc() {
        super(null);
    }

    @Deprecated
    public Set<String> getLegacyPre170Tags() {
        IPropertySet.Prop LEGACY_TAGS = new IPropertySet.Prop("GotoOcc.TAGS ", Collections.emptySet());
        return this.d_props.get(LEGACY_TAGS);
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public static String formatName(TagLogic logic, Set<String> tagNames) {
        return String.format(Intl.intl("Goto Occ %s"), logic.formatTags.apply(tagNames));
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        return Destination.INSTANCE;
    }

    public static enum TagLogic implements ILabeledEnum,
    ILabeled
    {
        ALL(Intl.intl("All"), Intl.intl("The destination occupant must have all the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" and "), 25)),
        ANY(Intl.intl("Any"), Intl.intl("The destination occupant must have any of the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" or "), 25));

        public final String name;
        public final String desc;
        public final Function<Set<String>, String> formatTags;

        private TagLogic(String name, String desc, Function<Set<String>, String> formatTags) {
            this.name = name;
            this.desc = desc;
            this.formatTags = formatTags;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class Destination
    implements IDestination {
        public static final Destination INSTANCE = new Destination();

        private Destination() {
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }

    public static enum TargetUnreachable implements ILabeledEnum,
    ILabeled
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The source occupant waits until their current destination occupant becomes reachable again.")),
        RESTART(Intl.intl("Restart action"), Intl.intl("The action is restarted so a new destination occupant can be found."));

        public final String name;
        public final String desc;

        private TargetUnreachable(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum TargetNotFound implements ILabeledEnum,
    ILabeled
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The source occupant waits until a destination occupant can be found."));

        public final String name;
        public final String desc;

        private TargetNotFound(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Tracking implements ILabeledEnum,
    ILabeled
    {
        DYNAMIC_ONCE(Intl.intl("Go to occupant"), Intl.intl("The source occupant seeks the destination occupant until they are within the arrival\nradius and have a clear line-of-sight.")),
        DYNAMIC_CONTINUOUS(Intl.intl("Follow occupant"), Intl.intl("The source occupant seeks and follows the destination occupant as long as the\ndestination occupant is still in the simulation and has the desired tags.")),
        INITIAL_LOC(Intl.intl("Go to initial location"), Intl.intl("The source occupant records the location of the destination occupant when the action\nis started and then seeks that point until they are within the arrival radius and\nhave a clear line-of-sight to the point.\nNOTE: The destination occupant may not still be at the point when the source occupant\narrives."));

        public final String name;
        public final String desc;

        private Tracking(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DistancePref implements ILabeledEnum,
    ILabeled
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A destination occupant is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available occupant is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

