/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class GotoExits
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<GotoExits> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoExits.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<EgressDoor>> PROP_EXITS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoExits.EXITS", Set.class, DisplayProps.emptySet(EgressDoor.class), Intl.intl("Exits"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(exits -> MerlinUtil.formatNamedSet(exits, Intl.intl("[any]")))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, EgressDoor.class, EgressDoor::isExit)).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getDoors(md, Intl.intl("[any]")))).attrFinish();
    public static final DisplayProp<String> NAME = GotoExits.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            Set<EgressDoor> exits = obj.get(PROP_EXITS);
            name = exits.size() == 1 ? String.format(Intl.intl("Exit <%s>"), exits.iterator().next().getName()) : (exits.isEmpty() ? Intl.intl("Exit <any>") : String.format(Intl.intl("Exit <door set>"), new Object[0]));
        }
        return name;
    }, Stream.of(STORED_NAME, PROP_EXITS)).attrFinish();
    private PropertySet d_props = new PropertySet();

    public GotoExits() {
        this(Collections.EMPTY_SET);
    }

    public GotoExits(Set<EgressDoor> exits) {
        super(null);
        this.set(PROP_EXITS, exits);
    }

    @Override
    public boolean mustBeLast() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public boolean isGotoAny() {
        return this.get(PROP_EXITS).isEmpty();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        return new ExitDestination(this);
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (EgressDoor door : this.get(PROP_EXITS)) {
            hash = 31 * hash + theUtil.hashCode(door);
        }
        return hash;
    }

    private class ExitDestination
    implements IDestination {
        private final Set<EgressDoor> d_exits;

        private ExitDestination(GotoExits gotoExits) {
            this.d_exits = gotoExits.get(PROP_EXITS);
        }

        @Override
        public int hashCode() {
            return 0xF98AF3EE ^ this.d_exits.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof ExitDestination && ((ExitDestination)obj).getExits().equals(this.d_exits);
        }

        protected Set<EgressDoor> getExits() {
            return this.d_exits;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        private IUnreachable allExitsUnreachable() {
            return new IUnreachable(this){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("\"%s\" cannot reach any exits."), name), String.format(Intl.intl("Move \"%s,\" move the exits, or connect their rooms."), name), source);
                }
            };
        }

        private IUnreachable someExitsUnreachable(final List<? extends IEgressConnector> exits) {
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    IMerlinObj[] objs = new IMerlinObj[1 + exits.size()];
                    for (int m = 0; m < exits.size(); ++m) {
                        objs[m] = (IMerlinObj)exits.get(m);
                    }
                    objs[objs.length - 1] = source;
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("\"%1$s\" cannot reach %2$d of its exits."), name, exits.size()), String.format(Intl.intl("Move \"%1$s,\" move the unreachable exits, or connect their rooms."), name), objs);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return Collections.EMPTY_LIST;
        }
    }
}

