/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.Floor;
import merlin.data.egress.SimError;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.theUtil;

public class GotoElevators
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = -7706651152609813492L;
    public static final PropertyDefs<GotoElevators> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoElevators.class, PropertyDefs.legacy(null), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<Elevator>> PROP_ELEVATORS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("GotoElevators.ELEVATORS", Set.class, DisplayProps.emptySet(Elevator.class), Intl.intl("Elevators"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(elevators -> MerlinUtil.formatNamedSet(elevators, Intl.intl("[any]")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoElevators::getElevators, Stream.empty()).attrSetter(GotoElevators::setElevators, null).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, Elevator.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getElevators(md, Intl.intl("[any]")))).attrFinish();
    public static final DisplayProp<Floor> PROP_FLOOR = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoOccTarget.PROP_FLOOR", Floor.class, null, Intl.intl("Target Floor"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(floor -> floor == null ? Intl.intl("Discharge Floor") : floor.getName())).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoElevators::getTargetDischarge, Stream.empty()).attrSetter(GotoElevators::setTargetDischarge, null).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.WEAK, Floor.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(md -> ObjSources.getFloors(md, Intl.intl("Discharge Floor")))).attrFinish();
    public static final DisplayProp<String> NAME = GotoElevators.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            name = obj.d_elevators.size() == 1 ? String.format(Intl.intl("Goto %s"), obj.d_elevators.iterator().next().getName()) : (obj.d_elevators.isEmpty() ? Intl.intl("Goto Any Elevator") : String.format(Intl.intl("Goto Elevators"), new Object[0]));
        }
        return name;
    }, Stream.of(STORED_NAME, PROP_ELEVATORS)).attrFinish();
    private Collection<Elevator> d_elevators;
    private Floor d_targetDischarge;

    public GotoElevators(Set<Elevator> elevators) {
        this(elevators, null);
    }

    public GotoElevators(Set<Elevator> elevators, Floor targetDischarge) {
        super(null);
        this.d_elevators = elevators;
        this.d_targetDischarge = targetDischarge;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_elevators instanceof List || this.d_elevators instanceof IdentityHashSet) {
            this.d_elevators = new LinkedIdentityHashSet<Elevator>(this.d_elevators);
        }
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public void setElevators(Set<Elevator> elevators) {
        if (!theUtil.setsEqual(this.d_elevators, elevators)) {
            this.d_elevators = elevators;
            this.changedEvt(PROP_ELEVATORS);
        }
    }

    public void setTargetDischarge(Floor floor) {
        if (this.d_targetDischarge != floor) {
            this.d_targetDischarge = floor;
            this.changedEvt(PROP_FLOOR);
        }
    }

    public Set<Elevator> getElevators() {
        return Collections.unmodifiableSet((Set)this.d_elevators);
    }

    public Floor getTargetDischarge() {
        return this.d_targetDischarge;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Elevator elevator : this.getElevators()) {
            hash = 31 * hash + theUtil.hashCode(elevator);
        }
        return hash;
    }

    public class Destination
    implements IDestination {
        private final Set<IEgressConnector> d_connectors;
        private final Set<IEgressConnector> d_dischargeDoors;

        public Destination() {
            Collection<Elevator> elevators = GotoElevators.this.d_elevators.isEmpty() ? ((MerlinData)GotoElevators.this.getDomain()).elevators.getDeepMembers(Elevator.class) : GotoElevators.this.d_elevators;
            LinkedIdentityHashSet<IEgressConnector> connectors = new LinkedIdentityHashSet<IEgressConnector>();
            LinkedIdentityHashSet<IEgressConnector> dischargeDoors = new LinkedIdentityHashSet<IEgressConnector>();
            for (Elevator elevator : elevators) {
                for (ElevatorRoom er : elevator.getDeepMembers(ElevatorRoom.class)) {
                    if (er == elevator.getFloorLevelMap().get(GotoElevators.this.d_targetDischarge)) {
                        dischargeDoors.addAll(er.getDoors());
                        continue;
                    }
                    connectors.addAll(er.getDoors());
                }
            }
            this.d_connectors = connectors;
            this.d_dischargeDoors = dischargeDoors;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getElevators().equals(GotoElevators.this.d_elevators);
        }

        @Override
        public int hashCode() {
            return 0xFAEE8F ^ GotoElevators.this.d_elevators.hashCode();
        }

        protected Set<Elevator> getElevators() {
            return (Set)GotoElevators.this.d_elevators;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            if (MerlinUtil.isConnected(source, this.d_connectors)) {
                return null;
            }
            return new IUnreachable(this){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("\"%s\" cannot reach the next elevator."), name), String.format(Intl.intl("Move \"%s\" or change the next destination."), name), source);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            Collection<Elevator> elevators = GotoElevators.this.d_elevators.isEmpty() ? ((MerlinData)GotoElevators.this.getDomain()).elevators.getDeepMembers(Elevator.class) : GotoElevators.this.d_elevators;
            ArrayList<ElevatorRoom> exitComps = new ArrayList<ElevatorRoom>(elevators.size());
            for (Elevator elevator : elevators) {
                PropValue<Boolean> enabled = elevator.getWithDetails(MerlinData.ENABLED);
                if (enabled.asOption().map(val -> val == false).orElse(false).booleanValue()) continue;
                ElevatorRoom targetExit = elevator.getFloorLevelMap().get(elevator.getDischargeFloor());
                if (GotoElevators.this.d_targetDischarge != null) {
                    targetExit = elevator.getFloorLevelMap().get(GotoElevators.this.d_targetDischarge);
                }
                exitComps.add(targetExit);
            }
            return exitComps;
        }
    }
}

