/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class CreateAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 7824814114567292619L;
    public static final PropertyDefs<CreateAttractor> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(CreateAttractor.class, PropertyDefs.none(), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Boolean> PROP_VISIBILITY = PROP_TYPES.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(CreateAttractor::isVisible, Stream.empty()).attrSetter(CreateAttractor::setVisible, null).attrFinish();
    public static final DisplayProp<Set<Attractor>> PROP_ATTRACTORS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("CreateAttractor.ATTRACTORS", Set.class, theUtil.emptySet(Attractor.class), Intl.intl("Triggers"), Intl.intl("The set of triggers to create.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(attrs -> MerlinUtil.formatNamedSet(attrs, Intl.intl("[none]")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(CreateAttractor::getAttractors, Stream.empty()).attrSetter(CreateAttractor::setAttractors, null).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, Attractor.class, Attractor::isTemplate)).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getAttractorTemplates(md, Intl.intl("[none]")))).attrFinish();
    public static final DisplayProp<LocationMode> PROP_LOCATION = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"CreateAttractor.LOCATION", LocationMode.class, LocationMode.FOLLOW_OCC, Intl.intl("Location"), Intl.intl("The location where triggers will be placed.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(loc -> loc.name)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(CreateAttractor::getLocation, Stream.empty()).attrSetter(CreateAttractor::setLocation, null).attrComparisonEditor(PropComparisons.factory().options(LocationMode.values())).attrFinish();
    public static final DisplayProp<Point3d> PROP_FIXED_LOCATION = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"CreateAttractor.FIXED_LOCATION", Point3d.class, null, Intl.intl("Fixed Location"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(CreateAttractor::getFixedLocation, Stream.empty()).attrSetter(CreateAttractor::setFixedLocation, null).attrFinish();
    public static final TypedProp<Vector3d> PROP_FIXED_LOCATION_NORMAL = TypedProps.build("CreateAttractor.FIXED_LOCATION_NORMAL", Vector3d.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(obj -> obj.d_fixedNormal, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (!Objects.equals(obj.d_fixedNormal, val)) {
            obj.d_fixedNormal = val;
            obj.changedEvt(prop);
        }
    }, null).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<IEgressOccupiable> PROP_FIXED_LOCATION_ROOM = TypedProps.build("CreateAttractor.FIXED_LOCATION_ROOM", IEgressOccupiable.class, null).attrStoreAsTopologyDirect(PROP_TYPES).attrGetter(CreateAttractor::getFixedRoom, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (obj.d_fixedRoom != val) {
            obj.d_fixedRoom = val;
            obj.changedEvt(prop);
        }
    }, null).attrDependency(prop -> Dependencies.newDependencyContainedBy(IEgressOccupiable.class)).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<String> PROP_NAME = CreateAttractor.buildCustomNameProp(PROP_TYPES).attrGetter(CreateAttractor::formatName, Stream.of(NamedMerlinObj.STORED_NAME, PROP_ATTRACTORS, PROP_LOCATION, PROP_FIXED_LOCATION)).attrFinish();
    static final CompositeProp LOCATION_COMPOSITE = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(PROP_LOCATION, PROP_FIXED_LOCATION).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    private Set<Attractor> d_attractors;
    private LocationMode d_location;
    private boolean d_visible;
    private Point3d d_fixedLocation;
    @SkipDep
    private transient IEgressOccupiable d_fixedRoom;
    private Vector3d d_fixedNormal;
    private static final Color BASE_COLOR = Color.ORANGE;

    public CreateAttractor(Set<Attractor> attractors, LocationMode location, Point3d fixedLocation, IEgressOccupiable fixedRoom, Vector3d fixedNormal) {
        super(null);
        this.d_attractors = attractors;
        this.d_location = location;
        this.d_visible = true;
        this.d_fixedLocation = fixedLocation;
        this.d_fixedRoom = fixedRoom;
        this.d_fixedNormal = fixedNormal;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public Set<Attractor> getAttractors() {
        return Collections.unmodifiableSet(this.d_attractors);
    }

    public void setAttractors(Set<Attractor> attractors) {
        if (!theUtil.setsEqual(this.d_attractors, attractors)) {
            this.d_attractors = attractors;
            this.changedEvt(PROP_ATTRACTORS);
        }
    }

    public LocationMode getLocation() {
        return this.d_location;
    }

    public void setLocation(LocationMode location) {
        if (this.d_location != location) {
            this.pauseUpdates();
            this.d_location = location;
            this.changedEvt(PROP_LOCATION, MerlinData.TOPOLOGY);
            this.resumeUpdates();
        }
    }

    public Point3d getFixedLocation() {
        return this.d_fixedLocation;
    }

    public IEgressOccupiable getFixedRoom() {
        return this.d_fixedRoom;
    }

    public void setFixedLocation(Point3d loc) {
        if (this.d_fixedLocation == null || !this.d_fixedLocation.equals(loc)) {
            this.pauseUpdates();
            this.d_fixedLocation = loc;
            this.changedEvt(MerlinData.TOPOLOGY);
            this.changedEvt(PROP_FIXED_LOCATION);
            this.resumeUpdates();
        }
    }

    private void setFixedLocation(IEgressOccupiable room, Vector3d roomNorm, Point3d loc) {
        this.pauseUpdates();
        this.d_fixedLocation = loc;
        this.d_fixedNormal = roomNorm;
        if (room != this.d_fixedRoom) {
            if (this.getDomain() != null) {
                if (this.d_fixedRoom != null) {
                    this.d_fixedRoom.disconnectFrom(this);
                    this.disconnectFrom(this.d_fixedRoom);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_fixedRoom = room;
        }
        this.changedEvt(PROP_FIXED_LOCATION, PROP_FIXED_LOCATION_NORMAL, PROP_FIXED_LOCATION_ROOM, MerlinData.TOPOLOGY);
        this.resumeUpdates();
    }

    private String formatName() {
        String name = super.getStoredName();
        if (name != null) {
            return name;
        }
        if (this.d_attractors.size() == 1) {
            switch (this.d_location.ordinal()) {
                case 0: {
                    return String.format(Intl.intl("Create %s Following Occupant"), this.d_attractors.iterator().next().getName());
                }
                case 1: {
                    return String.format(Intl.intl("Create %s at Current Location"), this.d_attractors.iterator().next().getName());
                }
                case 2: {
                    return String.format(Intl.intl("Create %s at %s"), this.d_attractors.iterator().next().getName(), CreateAttractor.format(this.d_fixedLocation));
                }
            }
            return String.format(Intl.intl("Create %s"), this.d_attractors.iterator().next().getName());
        }
        switch (this.d_location.ordinal()) {
            case 0: {
                return String.format(Intl.intl("Create Triggers Following Occupant"), new Object[0]);
            }
            case 1: {
                return String.format(Intl.intl("Create Triggers at Current Location"), new Object[0]);
            }
            case 2: {
                return String.format(Intl.intl("Create Triggers at %s"), CreateAttractor.format(this.d_fixedLocation));
            }
        }
        return String.format(Intl.intl("Create Triggers"), new Object[0]);
    }

    private static String format(Point3d p) {
        Unit su = Geometry.LENGTH_UNIT;
        Unit du = MerlinApp.getApp().getUnitSystem().getLength();
        return String.format("(%.1f, %.1f, %.1f) %s", UnitDouble.convert(p.x, su, du), UnitDouble.convert(p.y, su, du), UnitDouble.convert(p.z, su, du), du.toString());
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public IGeomNode getGeom() {
        if (this.d_location == LocationMode.FIXED_LOCATION) {
            return GeomNodeUtil.newNode(new CreateAttractorGeometry(this.d_fixedRoom, this.d_fixedNormal == null ? GeomConstants.VEC3D_ZPOS : this.d_fixedNormal, this.d_fixedLocation));
        }
        return GeomNodeUtil.newNode(EmptyGeom.INSTANCE);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof CreateAttractorGeometry) {
            this.pauseUpdates();
            CreateAttractorGeometry wgeom = (CreateAttractorGeometry)geom;
            this.setFixedLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.resumeUpdates();
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, gprops);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_fixedLocation;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_fixedLocation;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_fixedRoom);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_fixedRoom = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room;
        if (this.d_location == LocationMode.FIXED_LOCATION && this.getDomain() != null && (room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.d_fixedLocation.x, this.d_fixedLocation.y, this.d_fixedLocation.z + 1.0E-6), new Point3d(this.d_fixedLocation.x, this.d_fixedLocation.y, this.d_fixedLocation.z - 1.0E-6), 1)) != null) {
            this.d_fixedRoom = room.room;
            this.d_fixedNormal = room.faceNormal;
            this.d_fixedLocation = room.p;
            this.changedEvt(PROP_FIXED_LOCATION_ROOM, PROP_FIXED_LOCATION, PROP_FIXED_LOCATION_NORMAL);
        }
        return true;
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public void connectTo(IEgressObj conn) {
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_fixedRoom) {
            this.d_fixedRoom = null;
            this.d_fixedNormal = GeomConstants.VEC3D_ZPOS;
            this.changedEvt(PROP_FIXED_LOCATION_ROOM, PROP_FIXED_LOCATION_NORMAL);
        }
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_fixedRoom == null ? Collections.emptyList() : Arrays.asList(this.d_fixedRoom);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_fixedRoom == null;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public static enum LocationMode implements ILabeled
    {
        FOLLOW_OCC(Intl.intl("Follow Occupant"), Intl.intl("The created triggers will move with the occupant.")),
        CURRENT_LOCATION(Intl.intl("Current Location"), Intl.intl("The created triggers will be placed at the occupant's current location.")),
        FIXED_LOCATION(Intl.intl("Fixed Location"), Intl.intl("The created triggers will be placed at a predefined location."));

        public final String name;
        public final String desc;

        private LocationMode(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    private static class CreateAttractorGeometry
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = -7258540461757674787L;

        public CreateAttractorGeometry(IEgressOccupiable room, Vector3d normal, Point3d location) {
            super(room, normal, location, 1.0, true, new IGeom[0]);
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double newRadius) {
            if (find == null) {
                return new CreateAttractorGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc);
            }
            return new CreateAttractorGeometry(find.room, find.faceNormal, newLoc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new GeomUtil.LocationHandle(this));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new CreateAttractorGeometry(room, normal, location);
        }
    }
}

