/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.ObjSources;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class ChangeTags
extends NamedMerlinObj
implements IBehaviorAction,
ICyclicSurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<ChangeTags> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(ChangeTags.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Operation> OPERATION = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)855282475, Operation.class, Operation.ADD, Intl.intl("Operation"), Intl.intl("Specifies how the tags should be applied to the occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(op -> op.name)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric(262350898, Set.class, theUtil.emptySet(Tag.class), Intl.intl("New Tags"), Intl.intl("The tags for the operation.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(tags -> StringTagsUtil.format(TagsUtil.tagsAsStrings(tags)))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(TagsUtil::getTagCallback).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getTags(md, null))).attrFinish();
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsReadOnly(NamedMerlinObj.NAME).attrGetter(obj -> ChangeTags.formatName(obj.get(OPERATION), theUtil.map(obj.get(TAGS), NamedMerlinObj::getName)), Stream.of(OPERATION, TAGS)).attrFinish();
    private PropertySet d_props = new PropertySet();

    private static String format(Set<String> tags) {
        return MerlinUtil.formatStrTags(tags, "; ", 25);
    }

    public ChangeTags(Operation op, Set<Tag> tags) {
        this.set(OPERATION, op);
        this.set(TAGS, tags);
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public static String formatName(Operation op, Set<String> tagNames) {
        return op.format.apply(tagNames);
    }

    @Deprecated
    public Set<String> getLegacyTags() {
        IPropertySet.Prop LEGACY_TAGS = new IPropertySet.Prop(262350898, Collections.emptySet());
        return this.d_props.get(LEGACY_TAGS);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public static enum Operation implements ILabeled
    {
        ADD(Intl.intl("Add (+)"), Intl.intl("Adds the specified tags to the occupant."), false, tags -> String.format(Intl.intl("+ %s"), ChangeTags.format(tags))),
        REMOVE(Intl.intl("Remove (-)"), Intl.intl("Removes the specified tags from the occupant."), false, tags -> String.format(Intl.intl("- %s"), ChangeTags.format(tags))),
        SET(Intl.intl("Set"), Intl.intl("Sets the occupant's tags to the specified set."), true, tags -> String.format(Intl.intl("Set Tags: %s"), ChangeTags.format(tags)));

        public final String name;
        public final String description;
        public final Function<Set<String>, String> format;
        public final boolean tagsCanBeEmpty;

        private Operation(String name, String desc, boolean tagsCanBeEmpty, Function<Set<String>, String> format) {
            this.name = name;
            this.description = desc;
            this.format = format;
            this.tagsCanBeEmpty = tagsCanBeEmpty;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

