/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Random;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoExits;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.util.TypeFilter;

public class BehaviorRoot
extends GeomComposite<Behavior> {
    private static final long serialVersionUID = 1L;
    @SkipDep
    public Behavior NO_CHANGE;
    @SkipDep
    public Behavior DEFAULT;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(Behavior.class, BehaviorRoot.class);

    public BehaviorRoot() {
        this(Intl.intl("Behaviors"));
        this.addDefault();
    }

    public BehaviorRoot(String name) {
        super(name);
        this.initNoChangeBehavior();
    }

    public void addDefault() {
        this.DEFAULT = new Behavior(Intl.intl("Goto Any Exit"), new GotoExits());
        this.DEFAULT.setColor(MerlinUtil.newRandomOccColor(new Random(4930185321171587L)));
        this.add(this.DEFAULT);
    }

    private void initNoChangeBehavior() {
        this.NO_CHANGE = new Behavior(Intl.intl("No Change"));
        this.NO_CHANGE.setColor(MerlinUtil.newRandomOccColor(new Random(38529902911L)));
    }

    public void loadFrom(BehaviorRoot root) {
        this.pauseUpdates();
        super.loadFrom(root);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.NO_CHANGE = root.NO_CHANGE;
        if (this.NO_CHANGE == null) {
            this.initNoChangeBehavior();
        }
        this.resumeUpdates();
    }

    @Override
    public void loadFrom(Composite<Behavior> obj) {
        assert (obj instanceof BehaviorRoot);
        this.loadFrom((BehaviorRoot)obj);
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new BehaviorRoot(name);
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Behavior Group");
    }
}

