/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.vecmath.Vector2d;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressConnectorState;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;
import thunderheadeng.util.value.ConstVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public interface IEgressConnector
extends IEgressComp,
Serializable {
    public static final long serialVersionUID = 4477101711640351489L;
    public static final PropertyDefs<IEgressConnector> PROP_TYPES = PropertyDefs.defsRoot(IEgressConnector.class, PropertyDefs.none());
    public static final DisplayProp<IEgressFlowrate> FLOWRATE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IEgressConnector.FLOWRATE", IEgressFlowrate.class, null, Intl.intl("Flow Rate"), "<html>" + Intl.intl("If checked, sets a custom flow rate limit for selected doors.<br>If unchecked, uses the default flow rate limit set in the <b>Simulation Parameters</b>.") + "</html>").attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(IEgressConnector::getFlowrate, Stream.empty()).attrSetter(IEgressConnector::setFlowrate, null).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<IVariant<EgressConnectorState>> RAW_STATE = TypedProps.build((Object)"IEgressConnector.RAW_STATE", theUtil.makeGeneric(IVariant.class)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(IEgressConnector::getRawState, Stream.empty()).attrSetter(IEgressConnector::setRawState, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<IVariant<EgressDoorDir>> STATE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IEgressConnector.STATE", theUtil.makeGeneric(IVariant.class), new ConstVariant<EgressDoorDir>(EgressDoorDir.ALL), Intl.intl("State"), "").attrFormatValue(v -> VariantUtil.describeVariant(v, s -> s.name))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROP_TYPES).attrGetter(IEgressConnector::getState, RAW_STATE).attrSetter(IEgressConnector::setState, null).attrComparisonEditor(PropComparisons.factory().optionsVariant(EgressDoorDir.values())).attrFinish();
    public static final DisplayProp<EgressDoorDir> TRAVEL_DIR = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IEgressConnector.ONEWAY_DIR", EgressDoorDir.class, EgressDoorDir.ALL, Intl.intl("One-Way"), "").attrFormatValue(v -> v.name)).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROP_TYPES).attrGetter(IEgressConnector::getDirection, RAW_STATE).attrSetter(IEgressConnector::setDirection, null).attrComparisonEditor(null).attrFinish();
    public static final DisplayProp<IDistributedVal<UnitDouble>> WAIT_TIME = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("IEgressConnector.WAIT_TIME", IDistributedVal.class, new ConstantCurve(new UnitDouble(0.0, SI.SECOND)), Intl.intl("Wait Time"), "").attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(IEgressConnector::getWaitTime, Stream.empty()).attrSetter(IEgressConnector::setWaitTime, null).attrSurrogateEquals(null).attrComparisonEditor(PropComparisons.factory().distributedValue(1)).attrFinish();

    public IVariant<EgressConnectorState> getRawState();

    public void setRawState(IVariant<EgressConnectorState> var1);

    default public IVariant<EgressDoorDir> getState() {
        return EgressConnectorState.getDoorDirStateVariant(this.get(RAW_STATE));
    }

    default public void setState(IVariant<EgressDoorDir> state) {
        IVariant<EgressConnectorState> newState = EgressConnectorState.getConnectorStateVariant(state, this::adjustForDoor);
        this.set(RAW_STATE, newState);
    }

    default public EgressDoorDir getDirection() {
        return VariantUtil.getInitialValue(this.get(RAW_STATE)).toDoorDir();
    }

    default public void setDirectionVec(Vector2d vec) {
        if (Objects.equals(vec, this.getDirectionVec())) {
            return;
        }
        boolean open = vec == null;
        IVariant<EgressConnectorState> prevState = this.get(RAW_STATE);
        this.set(RAW_STATE, VariantUtil.setInitialValue(prevState, new EgressConnectorState(open, false, vec)));
    }

    default public void setDirection(EgressDoorDir dir) {
        Vector2d vec = this.adjustForDoor(dir);
        this.setDirectionVec(vec);
    }

    default public Vector2d getDirectionVec() {
        return VariantUtil.getInitialValue(this.get(IEgressConnector.RAW_STATE)).openDir;
    }

    public Vector2d adjustForDoor(EgressDoorDir var1);

    public IEgressOccupiable[] getConnectedComps();

    public boolean isExit();

    public UnitDouble getUDWidth();

    public EgressRoom getExtraGeom(IEgressOccupiable var1);

    public IEgressFlowrate getFlowrate();

    public void setFlowrate(IEgressFlowrate var1);

    public Collection<? extends IParametric3D> getSharedEdges(IEgressOccupiable var1);

    public IDistributedVal<UnitDouble> getWaitTime();

    public void setWaitTime(IDistributedVal<UnitDouble> var1);
}

