/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.Occupancy;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.RoomUtil;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class EgressRoom
extends AEgressComp
implements Serializable,
IEgressOccupiable,
ISurrogate,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER;
    public static final int DEFAULT_CLEANUP_OPTIONS = 23;
    public static final Object AREA_ADDED;
    public static final Object AREA_SUBTRACTED;
    public static final Object CLEARED;
    private static final Class<? extends IEgressObj>[] s_topTypes;
    private static final Set<Class<? extends IEgressObj>> s_topTypesSet;
    public static final PropertyDefs<EgressRoom> PROP_TYPES;
    public static final TypedProp<Predicate<SpeedModifier.Type>> PROP_TYPE_FILTER;
    public static final DisplayProp<IMaterial[]> MATERIAL;
    protected static final CompositeProp CAPACITY_PROPS;
    public static final TypedProp<Model> MODEL;
    protected static final TypedProp<AABox> GEOM_BOUNDS;
    protected static final TypedProp<Map<Class<? extends IEgressObj>, Set<IEgressObj>>> PROP_TOPOLOGY;
    public static final Predicate<SpeedModifier.Type> ALLOWED_SPEED_MOD_TYPES;
    private static final Matrix4d s_identity;
    @SkipDep
    private Model d_geometry;
    private SpeedModifier d_speedModifier;
    @SkipDep
    private transient SoftReference<Model> d_displayGeom;
    private Set<String> d_tags;
    private Set<Tag> d_customTags = Collections.emptySet();
    private IOccCount d_capacity = new ConstOccCount(50);
    private boolean d_capacityEnabled = false;
    @SkipDep
    private IMaterial d_material;
    @SkipDep
    private transient Map<Class<? extends IEgressObj>, Set<IEgressObj>> d_topology;
    private static Function<Class<? extends IEgressObj>, Set<IEgressObj>> newSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EgressRoom(String name) {
        this(name, new Model(), 0);
    }

    public EgressRoom(String name, Model geometry) {
        this(name, geometry, 23);
    }

    public EgressRoom(String name, Model geometry, int cleanupOptions) {
        super(name);
        this.d_geometry = geometry;
        this.d_geometry = RoomUtil.cleanup(this.d_geometry, cleanupOptions, Predicates.alwaysTrue());
        this.d_speedModifier = null;
        this.d_topology = new ListMap<Class<? extends IEgressObj>, Set<IEgressObj>>();
        this.d_speedModifier = SpeedModifier.DEFAULT;
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_topology = new ListMap<Class<? extends IEgressObj>, Set<IEgressObj>>();
        if (this.d_customTags == null) {
            this.d_customTags = Collections.emptySet();
        }
    }

    @Override
    public Point3d astarGetTestPoint() {
        for (Face face : this.d_geometry.getFaces()) {
            Point3d p = this.d_geometry.findPointInFace(face);
            if (p == null) continue;
            return p;
        }
        return new Point3d();
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        if (this.isConnected(obj)) {
            return this.astarGetSharedPt(obj);
        }
        Point3d projPt = null;
        double minDistSq = Double.POSITIVE_INFINITY;
        for (Set<IEgressObj> top : this.d_topology.values()) {
            for (IEgressObj adj : top) {
                Point3d sharedPt = this.astarGetSharedPt(adj);
                double distsq = p.distanceSquared(sharedPt);
                if (!(distsq < minDistSq)) continue;
                minDistSq = distsq;
                projPt = sharedPt;
                if (!(distsq <= 1.0E-12)) continue;
                return projPt;
            }
        }
        return projPt == null ? this.astarGetTestPoint() : projPt;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return adj.astarGetSharedPt(this);
    }

    @Override
    public Set<String> getPredefinedOccTags() {
        return this.d_tags;
    }

    @Override
    public void setPredefinedOccTags(Set<String> tags) {
        if (theUtil.setsEqual(tags, this.d_tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(PREDEFINED_OCC_TAGS);
    }

    @Override
    public Set<Tag> getCustomOccTags() {
        return this.d_customTags;
    }

    @Override
    public void setCustomOccTags(Set<Tag> tags) {
        if (theUtil.setsEqual(tags, this.d_customTags)) {
            return;
        }
        this.d_customTags = tags;
        this.changedEvt(CUSTOM_OCC_TAGS);
    }

    public Predicate<SpeedModifier.Type> getPropTypeFilter() {
        return ALLOWED_SPEED_MOD_TYPES;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_topology);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0018)) {
            this.d_topology.clear();
            ((Set)ois.readObject()).forEach(this::addTop);
            ((Set)ois.readObject()).forEach(this::addTop);
            ((Set)ois.readObject()).forEach(this::addTop);
            if (MerlinOIS.isVersion(ois, MerlinIO.Version.VER_0006)) {
                Set actions = (Set)ois.readObject();
                theUtil.filter(actions, IEgressObj.class).forEach(this::addTop);
            }
        } else {
            if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0108)) {
                this.d_topology.clear();
                ((Set)ois.readObject()).forEach(this::addTop);
            } else {
                this.d_topology = (Map)ois.readObject();
            }
            if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0152)) {
                ((MerlinOIS)ois).readPre152BlockageTopology(this);
            }
        }
    }

    private boolean addTop(IEgressObj obj) {
        return this.d_topology.computeIfAbsent(EgressRoom.getTopType(obj), newSet).add(obj);
    }

    private boolean removeTop(IEgressObj obj) {
        Class<? extends IEgressObj> type = EgressRoom.getTopType(obj);
        Set<IEgressObj> set = this.d_topology.get(type);
        if (set != null && set.remove(obj)) {
            if (set.isEmpty()) {
                this.d_topology.remove(type);
            }
            return true;
        }
        return false;
    }

    private void fireTopologyEventFor(IEgressObj obj) {
        boolean geomChanged;
        boolean bl = geomChanged = obj instanceof IEgressConnector || obj instanceof EgressCorridor;
        if (obj instanceof EgressAgent) {
            this.changedEvt(OCC_COUNT);
        } else if (geomChanged) {
            this.changedEvt(geomChanged);
        } else {
            this.changedEvt(MerlinData.CONNECTION);
        }
    }

    private static Class<? extends IEgressObj> getTopType(IEgressObj obj) {
        Class<?> otype = obj.getClass();
        for (Class<? extends IEgressObj> type : s_topTypes) {
            if (!type.isAssignableFrom(otype)) continue;
            return type;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    @Override
    public boolean getOccupantsAllowed() {
        return true;
    }

    private void changedEvt(boolean updateDisplay) {
        if (updateDisplay) {
            this.markDisplayDirty();
            this.changedEvt(AREA, Events.EVT_GENERAL);
        } else {
            this.changedEvt(new Object[0]);
        }
    }

    private void markDisplayDirty() {
        this.d_displayGeom = null;
    }

    @Override
    public EgressRoom clone() {
        return (EgressRoom)super.clone();
    }

    @Override
    public boolean updateTopo() {
        return false;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return true;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return s_topTypes;
    }

    public boolean isConnected(IEgressObj obj) {
        Class<? extends IEgressObj> type = EgressRoom.getTopType(obj);
        if (type == null) {
            return false;
        }
        return this.d_topology.getOrDefault(type, Collections.emptySet()).contains(obj);
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        if (this.d_topology.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.d_topology.size() == 1) {
            return this.d_topology.values().iterator().next();
        }
        return theUtil.flatMap(this.d_topology.values(), top -> top);
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (this.addTop(obj)) {
            this.fireTopologyEventFor(obj);
        }
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (this.removeTop(obj)) {
            this.fireTopologyEventFor(obj);
        }
    }

    @Override
    public void getConnectors(Collection<? super IEgressConnector> connectors) {
    }

    @Override
    public SpeedModifier getSpeedModifier() {
        return this.d_speedModifier;
    }

    @Override
    public void setSpeedModifier(SpeedModifier mod) {
        if (Objects.equals(this.d_speedModifier, mod)) {
            return;
        }
        this.d_speedModifier = mod;
        this.changedEvt(SPEED_MODIFIER);
    }

    @Override
    public Model getModel() {
        return this.d_geometry;
    }

    @Override
    public boolean isModelCached() {
        return true;
    }

    public void setModel(Model geometry) {
        this.d_geometry = geometry;
        try (IDomainObject.EventPause paused = this.openPause();){
            this.markTopoDirty();
            this.changedEvt(true);
            this.changedEvt(MODEL);
        }
    }

    public boolean getModificationsAllowed() {
        return true;
    }

    public boolean add(EgressRoom comp2) {
        Model model1 = this.d_geometry.clone();
        Model model2 = comp2.d_geometry.clone();
        int t1 = Integer.MAX_VALUE;
        int t2 = 0x7FFFFFFE;
        for (Face face : model2.getFaces()) {
            face.addGroup(t2);
        }
        for (Face face : model1.getFaces()) {
            face.addGroup(t1);
        }
        model1.merge(model2);
        ArrayList<Edge> sharedEdges = new ArrayList<Edge>();
        for (Edge edge : model1.getEdges()) {
            if (edge.faces.size() <= 1) continue;
            boolean bl = false;
            boolean m2Found = false;
            for (Face face : edge.faces) {
                if (face.partOfGroup(t1)) {
                    bl = true;
                }
                if (!face.partOfGroup(t2)) continue;
                m2Found = true;
            }
            if (!bl || !m2Found) continue;
            sharedEdges.add(edge);
        }
        if (sharedEdges.isEmpty()) {
            return false;
        }
        int[] nArray = new int[]{0};
        for (Edge edge : sharedEdges) {
            if (!edge.partOfGroup(1) && !edge.partOfGroup(t2)) continue;
            edge.groups = nArray;
        }
        int[] nArray2 = new int[]{t1, t2};
        for (Face face : model1.getFaces()) {
            face.removeGroups(nArray2);
        }
        this.d_geometry = model1;
        this.pauseUpdates();
        this.markTopoDirty();
        this.changedEvt(true);
        this.resumeUpdates();
        return true;
    }

    public boolean sub(EgressRoom comp2) {
        return this.subtract(comp2.getModel(), false);
    }

    public boolean subVolume(Model volume) {
        return this.subtract(volume, true);
    }

    private static boolean delFace(Model model1, Model subModel, Face face, boolean isVolume) {
        if (face.partOfGroup(Integer.MAX_VALUE)) {
            return true;
        }
        if (!isVolume) {
            return false;
        }
        Point3d testP = model1.findPointInFace(face);
        return testP == null || subModel.contains(testP);
    }

    public List<Face> haveCommonFaces(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        return this.haveCommonFaces(model1, model2, isVolume, new ArrayList<Face>());
    }

    private List<Face> haveCommonFaces(Model mergeModel, Model subModel, boolean isVolume, List<Face> delFaces) {
        ArrayList<Face> commonFaces = new ArrayList<Face>();
        for (Face face : mergeModel.getFaces()) {
            if (!EgressRoom.delFace(mergeModel, subModel, face, isVolume)) continue;
            delFaces.add(face);
            if (!face.partOfGroup(0)) continue;
            commonFaces.add(face);
        }
        return commonFaces;
    }

    public boolean subtract(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        ArrayList<Face> delFaces = new ArrayList<Face>();
        if (this.haveCommonFaces(model1, subModel, isVolume, delFaces).isEmpty()) {
            return false;
        }
        for (Face delFace : delFaces) {
            model1.deleteFace(delFace, true, true);
        }
        int[] boundGroup = new int[]{1};
        for (Edge edge : model1.getEdges()) {
            Face face;
            if (edge.faces.size() != 1 || (face = edge.faces.get(0)).isInternalEdge(edge)) continue;
            edge.groups = boundGroup;
        }
        this.pauseUpdates();
        this.d_geometry = model1;
        this.markTopoDirty();
        this.changedEvt(true);
        this.resumeUpdates();
        return true;
    }

    private static LineSeg3D toLineSeg3D(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    public Predicate<Edge> getInUseEdgeFilter() {
        return this.getInUseEdgeFilter(Predicates.alwaysTrue());
    }

    public Predicate<Edge> getInUseEdgeFilter(Predicate<? super IEgressComp> usingComps) {
        final LinkedHashSet inUseEdges = new LinkedHashSet();
        final BiFunction<Point3d, Point3d, LineSeg3D> round = (ep1, ep2) -> new LineSeg3D(Util3D.round(ep1, 9), Util3D.round(ep2, 9));
        Consumer<LineSeg3D> addEdge = e -> inUseEdges.add((LineSeg3D)round.apply(e.p1, e.p2));
        for (EgressDoor egressDoor : theUtil.filter(this.getDoors(), EgressDoor.class, usingComps)) {
            if (egressDoor.getRoom1() == this) {
                addEdge.accept(egressDoor.getEdge1());
            }
            if (egressDoor.getRoom2() != this) continue;
            addEdge.accept(egressDoor.getEdge2());
        }
        for (EgressCorridor egressCorridor : theUtil.filter(this.getCorridors(), EgressCorridor.class, usingComps)) {
            EgressCorridor.DoorInfo d1 = egressCorridor.getDoor1();
            EgressCorridor.DoorInfo d2 = egressCorridor.getDoor2();
            if (d1.getRoom() == this) {
                addEdge.accept(EgressRoom.toLineSeg3D(d1.getEdge()));
            }
            if (d2.getRoom() != this) continue;
            addEdge.accept(EgressRoom.toLineSeg3D(d2.getEdge()));
        }
        if (inUseEdges.isEmpty()) {
            return Predicates.alwaysFalse();
        }
        return new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (!o.curve.isLinear()) {
                    return false;
                }
                return inUseEdges.contains(round.apply(o.v1.loc, o.v2.loc)) || inUseEdges.contains(round.apply(o.curve.get(0.0), o.curve.get(1.0)));
            }
        };
    }

    public Model cleanup(Model model) {
        return this.cleanup(model, Predicates.alwaysTrue());
    }

    public Model cleanup(Model model, Predicate<? super IEgressComp> usingTest) {
        return RoomUtil.cleanup(model, 31, this.getInUseEdgeFilter(usingTest));
    }

    public void cleanupModel() {
        this.cleanupModel(Predicates.alwaysTrue());
    }

    public void cleanupModel(Predicate<? super IEgressComp> usingTest) {
        this.setModel(this.cleanup(this.getModel(), usingTest));
    }

    public static void cleanup(MerlinData md, Collection<? extends EgressRoom> rooms) {
        if (!rooms.isEmpty()) {
            md.updateTopology();
            rooms.forEach(EgressRoom::cleanupModel);
        }
    }

    @Override
    public boolean isWalkable(Point3d p) {
        return this.d_geometry.findFace(p) != null;
    }

    public List<EgressRoom> addBoundary(Collection<? extends ICurve> boundary, double edgeError) {
        this.d_geometry.addEdges(Integer.MAX_VALUE, EgressRoom.toParms(boundary, edgeError));
        ArrayList<Edge> toDelete = new ArrayList<Edge>();
        int[] boundaryid = new int[]{1};
        for (Edge edge : this.d_geometry.getEdges()) {
            boolean newEdge = edge.partOfGroup(Integer.MAX_VALUE);
            if (newEdge && edge.faces.isEmpty()) {
                toDelete.add(edge);
                continue;
            }
            if (!newEdge) continue;
            edge.groups = boundaryid;
        }
        for (Edge delEdge : toDelete) {
            this.d_geometry.deleteEdge(delEdge, true);
        }
        this.markTopoDirty();
        this.changedEvt(true);
        List<EgressRoom> separated = this.separate();
        return separated;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getRoomGeom());
    }

    public EgressModelGeom getRoomGeom() {
        return this.getGeom(true);
    }

    public EgressModelGeom getGeom(boolean includeBlockages) {
        Predicate<Face> fFilter = includeBlockages ? Filters.acceptAll(Face.class) : this.getFaceFilter();
        int options = 1;
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        return new EgressModelGeom(this.d_geometry, this.getInUseEdgeFilter(), fFilter, this.getBoundaryEdgeFilter(), options);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        this.setGeom(geom);
    }

    public void setGeom(IGeom geom) {
        if (!(geom instanceof EgressModelGeom)) {
            return;
        }
        EgressModelGeom mg = (EgressModelGeom)geom;
        this.d_geometry = mg.model;
        this.markTopoDirty();
        this.changedEvt(true);
    }

    private IPrimProps getFaceProps(IMerlinDispProps props) {
        return props.getFaceProps(this, IMerlinDispProps.EgressType.ROOM, this.d_material, this.getColor(), this.getOpacity());
    }

    private IPrimProps getBoundaryProps(IMerlinDispProps props) {
        return props.getEdgeProps(this, IMerlinDispProps.EgressType.BOUNDARY, null, this.getOpacity());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        Model dispModel = null;
        if (this.d_displayGeom != null) {
            dispModel = this.d_displayGeom.get();
        }
        if (dispModel == null) {
            dispModel = this.d_geometry.clone();
            ArrayList<IParametric3D> sharedEdges = new ArrayList<IParametric3D>();
            for (IEgressConnector iEgressConnector : this.getDoors(true)) {
                sharedEdges.addAll(iEgressConnector.getSharedEdges(this));
            }
            for (EgressCorridor egressCorridor : this.getCorridors(true)) {
                sharedEdges.addAll(egressCorridor.getSharedEdges(this));
            }
            if (!sharedEdges.isEmpty()) {
                dispModel.addEdges(Integer.MAX_VALUE, sharedEdges);
                int[] group = new int[]{0};
                for (Edge edge : dispModel.getEdges()) {
                    if (!edge.partOfGroup(Integer.MAX_VALUE)) continue;
                    edge.groups = group;
                }
            }
            this.d_displayGeom = new SoftReference<Model>(dispModel);
        }
        int options = 5;
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        EgressModelGeom geom = new EgressModelGeom(dispModel, Filters.rejectAll(Edge.class), this.getFaceFilter(), this.getBoundaryEdgeFilter(), options);
        int n = geom.getNumPrims(1);
        int numBEdges = geom.getNumPrims(2);
        IPrimProps fprops = this.getFaceProps(props);
        IPrimProps bprops = this.getBoundaryProps(props);
        PropsBuilder propsSrc = new PropsBuilder();
        propsSrc.add(fprops, n);
        propsSrc.add(bprops, numBEdges);
        IPropsSrc finalProps = propsSrc.finalizeProps();
        IGeomNode node = GeomNodeUtil.newNode(geom);
        node = GeomUtil.finalizeTexCoords(node, finalProps);
        return new DisplayGeom(node, finalProps);
    }

    protected Predicate<Face> getFaceFilter() {
        return Filters.acceptAll();
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms, IMerlinDispProps dprops) {
        ArrayList<EgressRoom> areas = new ArrayList<EgressRoom>(1);
        EgressRoom shape1 = this.clone();
        RoomBlockageInfo blockages = EgressRoom.intersectBlockages(shape1.d_geometry, this.getTop(EgressBlockage.class));
        for (IEgressConnector conn : this.getDoors()) {
            EgressRoom extraGeom;
            if (!conn.isEnabled() || (extraGeom = conn.getExtraGeom(this)) == null) continue;
            areas.add(extraGeom);
        }
        for (EgressRoom shape2 : areas) {
            shape1.sub(shape2);
            shape2.sub(this);
            shape1.add(shape2);
        }
        Model cleanedModel = RoomUtil.cleanup(shape1.getModel(), 23, Predicates.alwaysTrue(), true);
        shape1.setModel(cleanedModel);
        blockages = new RoomBlockageInfo(blockages.blkgIdMap, cleanedModel);
        EgressModelGeom roomGeom = shape1.getGeom(true);
        geoms.add(new InfernoGeom(this, InfernoType.OPEN, roomGeom, this.getFaceProps(dprops)));
        geoms.add(new InfernoGeom(this, InfernoType.BOUNDARY, roomGeom, this.getBoundaryProps(dprops)));
        for (Map.Entry<EgressBlockage, Integer> blockage : blockages.blkgIdMap.entrySet()) {
            blockage.getKey().getInfernoGeom(geoms::add, dprops, this, blockages);
        }
    }

    public List<EgressRoom> separate() {
        List<Model> separatedModels = RoomUtil.separate(this.d_geometry);
        if (separatedModels.size() <= 1) {
            return Arrays.asList(this);
        }
        ArrayList<EgressRoom> separatedRooms = new ArrayList<EgressRoom>(separatedModels.size());
        for (Model model : separatedModels) {
            EgressRoom newRoom = this.clone();
            newRoom.d_geometry = model;
            newRoom.setVisible(this.isVisible());
            newRoom.setColor(this.getColor());
            newRoom.setOpacity(this.getOpacity());
            newRoom.setPredefinedOccTags(this.getPredefinedOccTags());
            newRoom.setCustomOccTags(this.getCustomOccTags());
            separatedRooms.add(newRoom);
        }
        int biggestRoomIx = EgressRoom.getBiggestRoom(separatedRooms);
        EgressRoom biggestRoom = (EgressRoom)separatedRooms.get(biggestRoomIx);
        separatedRooms.remove(biggestRoomIx);
        separatedRooms.add(0, biggestRoom);
        return separatedRooms;
    }

    private static int getBiggestRoom(List<EgressRoom> rooms) {
        UnitDouble biggestRoomArea = new UnitDouble(-1.0, SIUS.unit(4));
        int biggestRoom = 0;
        for (int m = 0; m < rooms.size(); ++m) {
            UnitDouble area = rooms.get(m).getArea();
            if (area.compareTo(biggestRoomArea) <= 0) continue;
            biggestRoomArea = area;
            biggestRoom = m;
        }
        return biggestRoom;
    }

    public Set<IEgressConnector> getDoors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getDoors(), d -> !(d instanceof AEgressComp) || ((AEgressComp)((Object)d)).isEnabled());
        }
        return this.getDoors();
    }

    public Set<IEgressConnector> getDoors() {
        return this.getTop(IEgressConnector.class);
    }

    public Set<EgressCorridor> getCorridors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getCorridors(), d -> d.isEnabled());
        }
        return this.getCorridors();
    }

    public Set<EgressCorridor> getCorridors() {
        return this.getTop(EgressCorridor.class);
    }

    @Override
    public Set<EgressAgent> getOccupants() {
        return this.getTop(EgressAgent.class);
    }

    @Override
    public Set<GotoWaypoint> getWaypoints() {
        return this.getTop(GotoWaypoint.class);
    }

    private <T extends IEgressObj> Set<T> getTop(Class<T> type) {
        if (!$assertionsDisabled && !s_topTypesSet.contains(type)) {
            throw new AssertionError();
        }
        return Collections.unmodifiableSet(this.d_topology.getOrDefault(type, Collections.EMPTY_SET));
    }

    @Override
    public <T extends IEgressObj> Collection<? extends T> getConnections(Class<T> type) {
        if (s_topTypesSet.contains(type)) {
            return this.getTop(type);
        }
        return theUtil.flatMap(theUtil.filter(this.d_topology.entrySet(), entry -> type.isAssignableFrom((Class)entry.getKey())), entry -> (Collection)entry.getValue());
    }

    @Override
    public Occupancy getOccupancy() {
        return new Occupancy(this);
    }

    @Override
    public UnitDouble getArea() {
        double area = 0.0;
        for (Face face : this.d_geometry.getFaces()) {
            area += face.getArea();
        }
        UnitDouble areau = new UnitDouble(area, Geometry.AREA_UNIT);
        return areau;
    }

    public double getRoomArea() {
        return this.getArea().getRawValue();
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends ICurve> boundary, double edgeError, int newId) throws Exception {
        return this.subdivide(classifier, EgressRoom.toParms(boundary, edgeError), newId);
    }

    protected static List<IParametric3D> toParms(Collection<? extends ICurve> curves, double edgeError) {
        ArrayList<IParametric3D> parms = new ArrayList<IParametric3D>(curves.size());
        for (ICurve iCurve : curves) {
            Mesh segments = iCurve.getSegments(edgeError);
            for (int m = 0; m < segments.indices.length; m += 2) {
                parms.add(new LineSeg3D(segments.vertices[segments.indices[m]], segments.vertices[segments.indices[m + 1]]));
            }
        }
        return parms;
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends IParametric3D> boundary, int newId) throws Exception {
        int tempEdgeId = Integer.MAX_VALUE;
        Predicate<Edge> boundaryEdgeTest = e -> e.partOfGroup(tempEdgeId);
        Model newGeom = this.d_geometry.clone();
        newGeom.addEdges(tempEdgeId, boundary);
        ArrayList<Edge> newEdges = new ArrayList<Edge>(newGeom.getGroup((int)tempEdgeId, (boolean)false, (boolean)true, (boolean)false).edges);
        LinkedIdentityHashSet closedFaces = new LinkedIdentityHashSet();
        for (Edge edge : newEdges) {
            for (Face f : edge.faces) {
                if (closedFaces.contains(f)) continue;
                Set<Face> touching = GeomUtil.findTouchingFaces(f, boundaryEdgeTest, Predicates.alwaysFalse());
                closedFaces.addAll(touching);
                if (!classifier.test(newGeom, touching)) continue;
                int adjCount = 0;
                for (Face eface : edge.faces) {
                    if (!touching.contains(eface)) continue;
                    ++adjCount;
                }
                if (adjCount > 1) {
                    throw new Exception(String.format(Intl.intl("Boundary does not completely enclose a region in room %s."), this.getName()));
                }
                for (Face touchingFace : touching) {
                    touchingFace.addGroup(newId);
                }
            }
        }
        if (newGeom.getGroup((int)newId, (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) {
            return -1;
        }
        int[] remIds = new int[]{tempEdgeId};
        for (Edge edge : newEdges) {
            edge.removeGroups(remIds);
        }
        this.setGeom(new EgressModelGeom(newGeom));
        return newId;
    }

    public IMaterial getMaterial() {
        return this.d_material;
    }

    public void setMaterial(IMaterial material) {
        if (Objects.equals(this.d_material, material)) {
            return;
        }
        this.d_material = material;
        this.changedEvt(MATERIAL);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IOccCount getCapacity() {
        return this.d_capacity;
    }

    @Override
    public void setCapacity(IOccCount capacity) {
        if (!Objects.equals(this.d_capacity, capacity)) {
            this.d_capacity = capacity;
            this.changedEvt(PROP_CAPACITY);
        }
    }

    @Override
    public boolean getCapacityEnabled() {
        return this.d_capacityEnabled;
    }

    @Override
    public void setCapacityEnabled(boolean capacityEnabled) {
        if (this.d_capacityEnabled != capacityEnabled) {
            this.d_capacityEnabled = capacityEnabled;
            this.changedEvt(PROP_CAPACITY_ENABLED);
        }
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(MerlinData md, Supplier<MerlinDepSnapshot> deps) {
        ArrayList<AMerlinObj> connObjects = new ArrayList<AMerlinObj>();
        connObjects.addAll(this.getOccupants());
        for (IEgressObj iEgressObj : this.getConnections()) {
            if (iEgressObj instanceof IEgressComp) {
                connObjects.add((AEgressComp)iEgressObj);
            }
            if (!(iEgressObj instanceof EgressCorridor) && !(iEgressObj instanceof EgressDoor)) continue;
            connObjects.addAll(((AEgressComp)iEgressObj).getConnObjectsForEnable(md, deps));
        }
        Set<AMerlinObj> allReferences = deps.get().getAncestors(AMerlinObj.class, this);
        IFilteredCollection<OccSourceObj> iFilteredCollection = theUtil.filter(allReferences, OccSourceObj.class);
        connObjects.addAll(iFilteredCollection);
        return connObjects;
    }

    public RoomBlockageInfo intersectBlockages(Collection<? extends EgressBlockage> blockages) {
        if (blockages.isEmpty()) {
            return new RoomBlockageInfo(Collections.emptyMap(), this.d_geometry);
        }
        return EgressRoom.intersectBlockages(this.d_geometry.clone(), blockages);
    }

    private static RoomBlockageInfo intersectBlockages(Model model, Collection<? extends EgressBlockage> blockages) {
        GeomUtil.RoomObjectIsectInfo<EgressBlockage> isects = GeomUtil.isectRoomWithObjects(model, blockages, EgressBlockage::getSearchModel);
        return new RoomBlockageInfo(isects.objIdMap, isects.model);
    }

    private static /* synthetic */ Set lambda$static$11(Class type) {
        return new LinkedIdentityHashSet();
    }

    private static /* synthetic */ void lambda$static$10(TypedProp prop, EgressRoom obj, Map topo) {
        obj.d_topology = topo;
    }

    private static /* synthetic */ void lambda$static$9(TypedProp prop, EgressRoom obj, Map topo) {
        if (obj.d_topology.equals(topo)) {
            return;
        }
        obj.d_topology = topo;
        obj.changedEvt(prop);
    }

    private static /* synthetic */ Map lambda$static$8(EgressRoom obj) {
        return obj.d_topology;
    }

    private static /* synthetic */ Map lambda$static$7(EgressRoom obj) {
        return new ListMap();
    }

    private static /* synthetic */ AABox lambda$static$6(EgressRoom room) {
        return room.d_geometry.getBoundingBox();
    }

    private static /* synthetic */ Model lambda$static$5(EgressRoom obj, Model mod) {
        return mod.clone();
    }

    private static /* synthetic */ void lambda$static$4(EgressRoom obj, Model val) {
        obj.d_geometry = val;
    }

    private static /* synthetic */ DepCallback lambda$static$3(DisplayProp prop) {
        return GeomUtil.newMatDependency();
    }

    private static /* synthetic */ void lambda$static$2(EgressRoom obj, IMaterial[] mats) {
        if (mats.length >= 1) {
            obj.setMaterial(mats[0]);
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class RoomBlockageInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Model model;
        public final Map<EgressBlockage, Integer> blkgIdMap;

        public RoomBlockageInfo(Map<EgressBlockage, Integer> idBlkgMap, Model model) {
            this.blkgIdMap = idBlkgMap;
            this.model = model;
        }

        public int getFaceId(EgressBlockage blkg) {
            return this.blkgIdMap.getOrDefault(blkg, -1);
        }

        public Collection<Face> getFaces(EgressBlockage blkg) {
            Integer id = this.blkgIdMap.get(blkg);
            if (id == null) {
                return Collections.emptyList();
            }
            return this.model.getFaces(id);
        }
    }

    public static interface IFaceClassifier {
        public boolean test(Model var1, Collection<Face> var2);
    }
}

