/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class EgressGeomUtil {
    public static Collection<Pair<IEgressComp, IEgressComp.ConflictType>> computeConflicts(MerlinData md, Predicate<? super IEgressComp> filter, boolean edge, boolean manifold, int numAllowedConns, LineSeg ... edges) {
        ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>> conflicts = new ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>>();
        if (edge) {
            conflicts.addAll(EgressGeomUtil.computeEdgeOverlap(md, filter, edges));
        }
        if (manifold) {
            conflicts.addAll(EgressGeomUtil.computeNonManifoldConnections(md, filter, numAllowedConns, edges));
        }
        return conflicts;
    }

    public static Collection<Pair<IEgressComp, IEgressComp.ConflictType>> computeEdgeOverlap(MerlinData md, final Predicate<? super IEgressComp> filter, LineSeg ... edges) {
        AABox bounds = new AABox();
        final ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>> result = new ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>>();
        for (final LineSeg edge : edges) {
            IResult<IDisplayableGeomSrc> fresult = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (obj instanceof IEgressComp && filter.test((IEgressComp)obj) && EgressGeomUtil.overlaps(edge, (IEgressComp)obj)) {
                        result.add(new Pair<IEgressComp, IEgressComp.ConflictType>((IEgressComp)obj, IEgressComp.ConflictType.EDGE));
                    }
                }
            };
            bounds.reset();
            edge.getBoundingBox(bounds);
            md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), (IResult<? super IDisplayableGeomSrc>)fresult, 1);
        }
        return result;
    }

    public static boolean overlaps(LineSeg edge, IEgressComp comp) {
        Point3d[] boundary = null;
        if (comp instanceof EgressCorridor) {
            EgressCorridor corr = (EgressCorridor)comp;
            boundary = corr.getBoundary();
        } else if (comp instanceof EgressDoor) {
            EgressDoor door = (EgressDoor)comp;
            boundary = door.getDoorGeom().getBoundary();
        }
        if (boundary == null) {
            return false;
        }
        for (int m = 0; m < boundary.length; m += 2) {
            double[] overlap = Inter3D.lineSeglineSegOverlap(edge.p1, edge.p2, boundary[m], boundary[m + 1], 1.0E-9, 1.0E-12);
            if (overlap == null || theUtil.eq(overlap[0], overlap[1], 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Pair<IEgressComp, IEgressComp.ConflictType>> computeNonManifoldConnections(MerlinData md, final Predicate<? super IEgressComp> filter, int numAllowedConns, LineSeg ... edges) {
        AABox bounds = new AABox();
        ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>> result = new ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>>();
        for (final LineSeg edge : edges) {
            final ArrayList adjRooms = new ArrayList();
            IResult<IDisplayableGeomSrc> fresult = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    int count;
                    if (obj instanceof EgressRoom && filter.test((EgressRoom)obj) && (count = EgressGeomUtil.getAdjacentCount((EgressRoom)obj, edge)) > 0) {
                        adjRooms.add(new Pair<EgressRoom, Integer>((EgressRoom)obj, count));
                    }
                }
            };
            bounds.reset();
            edge.getBoundingBox(bounds);
            md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), (IResult<? super IDisplayableGeomSrc>)fresult, 1);
            int numConns = 0;
            for (Pair adj : adjRooms) {
                numConns += ((Integer)adj.v2).intValue();
            }
            if (numConns <= numAllowedConns) continue;
            for (Pair adj : adjRooms) {
                result.add(new Pair<IEgressComp, IEgressComp.ConflictType>((IEgressComp)adj.v1, IEgressComp.ConflictType.NON_MANIFOLD));
            }
        }
        return result;
    }

    public static int getAdjacentCount(EgressRoom room, LineSeg edge) {
        List<Edge> nearEdges = room.getModel().findEdges(edge.getBoundingBox(new AABox()));
        int count = 0;
        for (Edge redge : nearEdges) {
            double[] overlap = Inter3D.lineSeglineSegOverlap(edge.p1, edge.p2, redge.v1.loc, redge.v2.loc, 1.0E-9, 1.0E-12);
            if (overlap == null || theUtil.eq(overlap[0], overlap[1], 1.0E-6)) continue;
            for (Face face : redge.faces) {
                if (face.isInternalEdge(redge)) {
                    count += 2;
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public static ConflictRemovalStatus removeConflict(Collection<Pair<IEgressComp, IEgressComp.ConflictType>> conflicts, IEgressObj obj) {
        Pair<IEgressComp, IEgressComp.ConflictType> next;
        if (!(obj instanceof IEgressComp)) {
            return ConflictRemovalStatus.NONE;
        }
        boolean removed = false;
        boolean recalcNMConflicts = false;
        Iterator<Pair<IEgressComp, IEgressComp.ConflictType>> it = conflicts.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (next.v1 != obj) continue;
            removed = true;
            recalcNMConflicts |= next.v2 == IEgressComp.ConflictType.NON_MANIFOLD;
            it.remove();
        }
        if (recalcNMConflicts) {
            it = conflicts.iterator();
            while (it.hasNext()) {
                next = it.next();
                if (next.v2 != IEgressComp.ConflictType.NON_MANIFOLD) continue;
                it.remove();
            }
            return ConflictRemovalStatus.REMOVED_ALL_NONMANIFOLD;
        }
        return removed ? ConflictRemovalStatus.REMOVED : ConflictRemovalStatus.NONE;
    }

    public static enum ConflictRemovalStatus {
        NONE(false, false),
        REMOVED(true, false),
        REMOVED_ALL_NONMANIFOLD(true, true);

        public final boolean removed;
        public final boolean recompute;

        private ConflictRemovalStatus(boolean removed, boolean recompute) {
            this.removed = removed;
            this.recompute = recompute;
        }
    }
}

