/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.awt.Color;
import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.IMerlinDispProps;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.value.ConstVariant;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public final class EgressDoorDir
extends Enum<EgressDoorDir>
implements ILabeled {
    public static final /* enum */ EgressDoorDir ALL = new EgressDoorDir(null, Intl.intl("Open"));
    public static final /* enum */ EgressDoorDir NONE = new EgressDoorDir(null, Intl.intl("Closed"));
    public static final /* enum */ EgressDoorDir EAST = new EgressDoorDir(new Vector2d(1.0, 0.0), Intl.intl("+X"));
    public static final /* enum */ EgressDoorDir WEST = new EgressDoorDir(new Vector2d(-1.0, 0.0), Intl.intl("-X"));
    public static final /* enum */ EgressDoorDir NORTH = new EgressDoorDir(new Vector2d(0.0, 1.0), Intl.intl("+Y"));
    public static final /* enum */ EgressDoorDir SOUTH = new EgressDoorDir(new Vector2d(0.0, -1.0), Intl.intl("-Y"));
    public final Vector2d vec;
    public final String name;
    private static final /* synthetic */ EgressDoorDir[] $VALUES;

    public static EgressDoorDir[] values() {
        return (EgressDoorDir[])$VALUES.clone();
    }

    public static EgressDoorDir valueOf(String name) {
        return Enum.valueOf(EgressDoorDir.class, name);
    }

    private EgressDoorDir(Vector2d vec, String name) {
        this.vec = vec;
        this.name = name;
    }

    public EgressDoorDir flip() {
        switch (this.ordinal()) {
            case 4: {
                return SOUTH;
            }
            case 5: {
                return NORTH;
            }
            case 2: {
                return WEST;
            }
            case 3: {
                return EAST;
            }
        }
        return ALL;
    }

    public static EgressDoorDir toDir(Vector2d vec) {
        if (vec == null) {
            return ALL;
        }
        vec = new Vector2d(vec);
        vec.normalize();
        if (vec.x >= 0.5) {
            return EAST;
        }
        if (vec.x < -0.5) {
            return WEST;
        }
        if (vec.y >= 0.5) {
            return NORTH;
        }
        return SOUTH;
    }

    public Vector2d adjustForDoor(LineSeg doorSeg) {
        return EgressDoorDir.adjustForDoor(this.vec, doorSeg);
    }

    public static Vector2d adjustForDoor(Vector2d onewayDir, LineSeg doorSeg) {
        if (onewayDir == null) {
            return null;
        }
        Vector3d doorDir = doorSeg.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        Vector3d crossDir = Util3D.cross(GeomConstants.VEC3D_ZPOS, doorDir);
        Vector2d crossDir2d = new Vector2d(crossDir.x, crossDir.y);
        crossDir2d.normalize();
        if (onewayDir.dot(crossDir2d) < 0.0) {
            crossDir2d.negate();
        }
        return crossDir2d;
    }

    public static EgressDoorDir toDir(LineSeg doorSeg, boolean into) {
        ICurve.Orient orient = into ? ICurve.Orient.POSITIVE : ICurve.Orient.NEGATIVE;
        Vector3d doorDir = doorSeg.getTangent(0.0, orient, true);
        Vector3d travelDir = Util3D.cross(GeomConstants.VEC3D_ZPOS, doorDir);
        Vector2d dir = new Vector2d(travelDir.x, travelDir.y);
        return EgressDoorDir.toDir(dir);
    }

    public static IGeom generateDisplayGeom(IEgressObj src, IMerlinDispProps dispProps, Vector2d onewayDir, Point3d[] boundary, IEgressOccupiable adjRoom1, IEgressOccupiable adjRoom2, PropsBuilder props) {
        Face adjFace;
        Point3d p2;
        Point3d p1;
        IEgressOccupiable adjRoom;
        int doorOpts = dispProps.getDoorDrawOptions();
        if (onewayDir == null || (doorOpts & 1) == 0) {
            return EmptyGeom.INSTANCE;
        }
        Vector3d onewayDir3d = new Vector3d(onewayDir.x, onewayDir.y, 0.0);
        boolean dirPositive = Util3D.cross((Vector3d)onewayDir3d, (Vector3d)Util3D.vector((Point3d)boundary[boundary.length - 2], (Point3d)boundary[boundary.length - 1])).z >= 0.0;
        IEgressOccupiable iEgressOccupiable = adjRoom = dirPositive ? adjRoom2 : adjRoom1;
        if (boundary.length == 2) {
            p1 = boundary[0];
            p2 = boundary[1];
        } else if (!dirPositive) {
            p1 = boundary[0];
            p2 = boundary[1];
        } else {
            p1 = boundary[2];
            p2 = boundary[3];
        }
        double arrowSize = Math.min(Util.feetToMeters(2.0), 0.5 * p1.distance(p2));
        Point3d center = Util3D.getMidPoint(p1, p2);
        if (adjRoom != null && (adjFace = adjRoom.getModel().findFace(center)) != null) {
            Plane3d alignPlane = adjFace.plane;
            EgressDoorDir.projectAlongZ(onewayDir3d, alignPlane, onewayDir3d, true);
        }
        Vector3d dir = Util3D.vectorN(p1, p2);
        dir.scale(arrowSize * 0.5);
        Point3d t1 = Util3D.add(center, (Tuple3d)dir);
        Point3d t2 = Util3D.add(center, (Tuple3d)Util3D.scale(onewayDir3d, arrowSize * 0.5));
        Point3d t3 = Util3D.sub(center, (Tuple3d)dir);
        Triangle t = new Triangle(t1, t2, t3);
        t = t.transform(TransformUtil.translate(0.0, 0.0, 0.003).getInfo(), 0);
        props.add(new IPrimProps.Face(Color.BLACK, null, 0));
        PolyLine outline = new PolyLine(t.p1, t.p2, t.p3, t.p1);
        props.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        return GeomUtil.group(t, outline);
    }

    private static Vector3d projectAlongZ(Vector3d result, Plane3d plane, Vector3d dir, boolean reLengthen) {
        if (dir.x == 0.0 && dir.y == 0.0 || plane.x * dir.x + plane.y * dir.y + plane.z * dir.z == 0.0) {
            result.set(dir.x, dir.y, dir.z);
            return result;
        }
        if (plane.z == 0.0) {
            result.set(0.0, 0.0, 1.0);
            return result;
        }
        double dirz = (-plane.x * dir.x - plane.y * dir.y) / plane.z;
        if (reLengthen) {
            double len = dir.length();
            result.set(dir.x, dir.y, dirz);
            result.normalize();
            result.scale(len);
        } else {
            result.set(dir.x, dir.y, dirz);
        }
        return result;
    }

    public static Map<EgressDoorDir, String> getMap(Predicate<EgressDoorDir> filter) {
        LinkedIdentityHashMap<EgressDoorDir, String> map = new LinkedIdentityHashMap<EgressDoorDir, String>();
        for (EgressDoorDir state : EgressDoorDir.values()) {
            if (!filter.test(state)) continue;
            map.put(state, state.name);
        }
        return map;
    }

    private static boolean toBooleanDir(EgressDoorDir dir) {
        return switch (dir.ordinal()) {
            case 0 -> true;
            case 1 -> false;
            default -> throw new IllegalArgumentException();
        };
    }

    public static EgressDoorDir fromBooleanDir(boolean dir) {
        return dir ? ALL : NONE;
    }

    public static IVariant<Boolean> getBooleanEgressDoorDirVariant(IVariant<EgressDoorDir> state) {
        if (state instanceof ConstVariant) {
            ConstVariant constVarState = (ConstVariant)state;
            return new ConstVariant<Boolean>(EgressDoorDir.toBooleanDir((EgressDoorDir)constVarState.value));
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            Boolean initVal = EgressDoorDir.toBooleanDir((EgressDoorDir)discreteVarState.initVal);
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<Boolean>(discreteVarState.entries[i].t, EgressDoorDir.toBooleanDir((EgressDoorDir)discreteVarState.entries[i].val));
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }

    public static IVariant<EgressDoorDir> getEgressDoorDirBooleanVariant(IVariant<Boolean> state) {
        if (state instanceof ConstVariant) {
            ConstVariant constVarState = (ConstVariant)state;
            return new ConstVariant<EgressDoorDir>(EgressDoorDir.fromBooleanDir((Boolean)constVarState.value));
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            EgressDoorDir initVal = EgressDoorDir.fromBooleanDir((Boolean)discreteVarState.initVal);
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<EgressDoorDir>(discreteVarState.entries[i].t, EgressDoorDir.fromBooleanDir((Boolean)discreteVarState.entries[i].val));
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "";
    }

    private static /* synthetic */ EgressDoorDir[] $values() {
        return new EgressDoorDir[]{ALL, NONE, EAST, WEST, NORTH, SOUTH};
    }

    static {
        $VALUES = EgressDoorDir.$values();
    }
}

