/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.Floor;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.property.PropertyDefs;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class ElevatorRoom
extends EgressRoom
implements IElevatorComp {
    static final long serialVersionUID = 723492347132409L;
    public static final PropertyDefs<ElevatorRoom> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(ElevatorRoom.class, null, EgressRoom.PROP_TYPES, Filters.reject(MerlinData.ENABLED, NamedMerlinObj.NAME));
    static final TypedProp<AABox> GEOM_BOUNDS = EgressRoom.GEOM_BOUNDS;
    static final TypedProp<Map<Class<? extends IEgressObj>, Set<IEgressObj>>> PROP_TOPOLOGY = EgressRoom.PROP_TOPOLOGY;
    static final CompositeProp CAPACITY_PROPS = EgressRoom.CAPACITY_PROPS;
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsWrapper(NamedMerlinObj.NAME).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            Floor floor;
            MerlinData md = (MerlinData)obj.getDomain();
            if (md != null && (floor = ElevatorUtil.getFloor((MerlinData)obj.getDomain(), obj)) != null) {
                BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
                return String.format(Intl.intl("Level %s"), Global.format(floor.getWorkingZ().convert(lu)));
            }
            return Intl.intl("<Disconnected Level>");
        }
        return name;
    }, Stream.of(STORED_NAME)).attrSetter(NamedMerlinObj::setStoredName, null).attrFinish();
    static final TypedProp<List<ElevatorDoor>> DOORS = TypedProps.build("ElevatorRoom.DOORS", theUtil.makeGeneric(List.class), new ArrayList()).attrStoreAsMutable(PROP_TYPES).attrCloneValue((room, doors) -> {
        ArrayList<ElevatorDoor> newDoors = new ArrayList<ElevatorDoor>(doors.size());
        for (ElevatorDoor door : doors) {
            ElevatorDoor newDoor = (ElevatorDoor)door.clone();
            newDoors.add(newDoor);
        }
        return newDoors;
    }).attrRestoreValue((room, doors) -> new ArrayList(doors)).attrGetter(obj -> obj.getElevatorDoors(), Stream.empty()).attrSetter((prop, obj, doors) -> {
        try (IDomainObject.EventPause paused = obj.openPause();){
            for (ElevatorDoor oldDoor : obj.getElevatorDoors()) {
                obj.disconnectFrom(oldDoor);
                obj.removeChild(oldDoor);
            }
            for (ElevatorDoor door : doors) {
                obj.connectTo(door);
                obj.addChild(door);
            }
            obj.d_doors = new ArrayList<ElevatorDoor>((Collection<ElevatorDoor>)doors);
            obj.changedEvt(prop);
        }
    }, (prop, obj, doors) -> {
        obj.d_doors = new ArrayList<ElevatorDoor>((Collection<ElevatorDoor>)doors);
    }).attrSurrogateEquals(null).attrFinish();
    @SkipDep
    private List<ElevatorDoor> d_doors;

    public ElevatorRoom(EgressRoom room, Collection<ElevatorDoor> connectedDoors) {
        this(room.getName(), room.getModel(), connectedDoors);
    }

    public ElevatorRoom(String name, Model geometry, Collection<ElevatorDoor> connectedDoors) {
        super(name, geometry);
        this.d_doors = new ArrayList<ElevatorDoor>(connectedDoors);
        for (ElevatorDoor door : connectedDoors) {
            super.connectTo(door);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        super.readTopology(ois);
        if (this.d_doors.isEmpty()) {
            this.d_doors = new ArrayList<ElevatorDoor>(MerlinUtil.filter(this.getDoors(), ElevatorDoor.class));
        }
    }

    public List<ElevatorDoor> getElevatorDoors() {
        return Collections.unmodifiableList(this.d_doors);
    }

    @Override
    public boolean getOccupantsAllowed() {
        return false;
    }

    @Override
    public boolean getModificationsAllowed() {
        return false;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.getElevatorDoors();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        ArrayList<? extends IEgressObj> erTop = new ArrayList<IEgressObj>();
        erTop.addAll(super.getConnections());
        Object parent = this.getParent();
        if (parent instanceof Elevator) {
            Elevator parentElevator = (Elevator)parent;
            for (ElevatorRoom elevatorRoom : parentElevator.getFloorLevelMap().values()) {
                erTop.add(elevatorRoom);
            }
        }
        return erTop;
    }
}

