/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import merlin.data.IMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.property.PropertyDefs;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class ElevatorDoor
extends EgressDoor
implements IElevatorComp {
    static final long serialVersionUID = 234111234908734L;
    public static final PropertyDefs<ElevatorDoor> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(ElevatorDoor.class, null, EgressDoor.PROP_TYPES, Filters.reject(EgressDoor.WIDTH));
    static final TypedProp<EgressDoor.ConnectedComps> CONNECTED_COMPS = EgressDoor.CONNECTED_COMPS;
    static final TypedProp<Collection<Pair<IEgressComp, IEgressComp.ConflictType>>> CONFLICTS = EgressDoor.CONFLICTS;
    static final TypedProp<EgressDoor.AttachedEdges> ATTACHED_EDGES = EgressDoor.ATTACHED_EDGES;
    public static final DisplayProp<UnitDouble> WIDTH = PROP_TYPES.storeAsReadOnly(EgressDoor.WIDTH).attrGetter(EgressDoor::getUDWidth, Stream.of(EgressDoor.BOUNDARY)).attrFinish();
    static final TypedProp<EgressRoom> DISCONNECTED_ROOM = TypedProps.build("EgressRoom.DISCONNECTED_ROOM", EgressRoom.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ElevatorDoor::getDisconnectedRoom, Stream.empty()).attrSetter(ElevatorDoor::setDisconnectedRoom, null).attrSurrogateEquals(null).attrFinish();
    @Deprecated
    private boolean d_enabled;
    @SkipDep
    private EgressRoom d_disconnectedRoom;

    public ElevatorDoor(EgressDoor door) {
        this(door.getName(), door.getRoom1(), door.getRoom2(), door.getEdge1(), door.getEdge2(), door.getBoundary());
    }

    public ElevatorDoor(String name, IEgressOccupiable comp1, IEgressOccupiable comp2, LineSeg3D attachedEdge1, LineSeg3D attachedEdge2, Point3d[] boundary) {
        super(name, comp1, comp2, attachedEdge1, attachedEdge2, boundary);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0177)) {
            this.setEnabled(this.d_enabled);
            this.d_enabled = false;
        }
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        if (!ElevatorRoom.class.isAssignableFrom(type) && !this.isEnabled()) {
            return false;
        }
        return super.hasOpenSpots(type);
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (!(obj instanceof ElevatorRoom) && !this.isEnabled()) {
            return;
        }
        super.connectTo(obj);
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (!(this.getRoom1() instanceof ElevatorRoom) || !(this.getRoom2() instanceof ElevatorRoom)) {
            if (obj instanceof ElevatorRoom) {
                return;
            }
            if (obj instanceof EgressRoom) {
                this.d_disconnectedRoom = (EgressRoom)obj;
            }
        }
        super.disconnectFrom(obj);
    }

    @Override
    public boolean getModificationsAllowed() {
        return false;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public EgressRoom getDisconnectedRoom() {
        return this.d_disconnectedRoom;
    }

    private void setDisconnectedRoom(EgressRoom room) {
        if (Objects.equals(this.d_disconnectedRoom, room)) {
            return;
        }
        this.d_disconnectedRoom = room;
        this.changedEvt(DISCONNECTED_ROOM);
    }
}

