/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.blockages;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.Opacity;
import merlin.data.SimParams;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.material.Material;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import merlin.unitsystem.MerlinUnitType;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.SoftCachedValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import thunderheadeng.util.value.ConstVariant;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public class EgressBlockage
extends NamedMerlinObj
implements Serializable,
IEgressObj,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(EgressBlockage.class.getSimpleName());
    public static final PropertyDefs<EgressBlockage> PROPS = PropertyDefs.defsInheritPropsOnly(EgressBlockage.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
        obj.initCache();
    }), NamedMerlinObj.PROPS);
    public static final DisplayProp<SpeedModifier> SPEED_MODIFIER = PROPS.storeAsPlainOldData(IEgressOccupiable.SPEED_MODIFIER).attrFinish();
    public static final DisplayProp<Boolean> PREVENT_OCC_PLACEMENT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"EgressBlockage.PREVENT_OCC_PLACEMENT", true, Intl.intl("Prevent Occupant Placement"), Intl.intl("Whether the obstacle should prevent new occupants from being created inside of it.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();
    static final TypedProp<DisplayGeom> STORED_CAD_GEOM = TypedProps.build("EgressBlockage.STORED_CAD_GEOM", DisplayGeom.class, DisplayGeom.EMPTY).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<DisplayGeom> CAD_GEOM = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"EgressBlockage.CAD_GEOM", DisplayGeom.class, DisplayGeom.EMPTY, Intl.intl("Imported geometry"), "").attrFormatValue(dg -> Intl.intl("Imported Geometry"))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROPS).attrGetter(obj -> obj.get(STORED_CAD_GEOM), STORED_CAD_GEOM).attrSetter((prop, obj, val) -> {
        DisplayGeom prevVal = obj.get(STORED_CAD_GEOM);
        if (!Objects.equals(prevVal, val)) {
            obj.set(STORED_CAD_GEOM, val);
            boolean searchGeomDirty = obj.isSearchGeomCalculated();
            obj.changedEvt(true, searchGeomDirty, searchGeomDirty, true);
        }
    }, null).attrUndoPropRestoreAll().attrFinish();
    static final TypedProp<Boolean> STORED_LINK_CAD_GEOM_TO_SEARCH = TypedProps.build("EgressBlockage.STORED_LINK_CAD_GEOM_TO_SEARCH", Boolean.class, true).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<Boolean> LINK_CAD_GEOM_TO_SEARCH = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"EgressBlockage.LINK_CAD_GEOM_TO_SEARCH", Boolean.class, true, Intl.intl("Link shape to CAD geometry"), "<html>" + Intl.intl("If checked, the shape of the obstacle is defined by the CAD geometry.<br>If unchecked, the shape of the obstacle must be defined explicitly.")).attrFormatValue(b -> b != false ? Intl.intl("Yes") : Intl.intl("No"))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROPS).attrGetter(obj -> obj.get(STORED_LINK_CAD_GEOM_TO_SEARCH), STORED_LINK_CAD_GEOM_TO_SEARCH).attrSetter((prop, obj, newVal) -> {
        Boolean prevVal = obj.get(STORED_LINK_CAD_GEOM_TO_SEARCH);
        if (!Objects.equals(prevVal, newVal)) {
            if (obj.getDisplayType() == DisplayType.CAD_GEOM) {
                obj.ensureValidSetSearchGeom();
            }
            if (!newVal.booleanValue()) {
                obj.d_linkedSearchGeom.clear();
            }
            obj.set(STORED_LINK_CAD_GEOM_TO_SEARCH, newVal);
            if (obj.getDisplayType() == DisplayType.CAD_GEOM) {
                obj.changedEvt(true, true, true, false);
            }
        }
    }, null).attrUndoPropRestoreAll().attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();
    static final TypedProp<UnitDouble> STORED_CAD_HEAD_HEIGHT = TypedProps.build("EgressBlockage.STORED_CAD_HEAD_HEIGHT", UnitDouble.class, new UnitDouble(6.0, NonSI.FOOT)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<UnitDouble> CAD_HEAD_HEIGHT = ((TeciDisplayProps.Builder)DisplayProps.build((Object)"EgressBlockage.CAD_HEAD_HEIGHT", UnitDouble.class, new UnitDouble(6.0, NonSI.FOOT), "", "").attrFormatValue(h -> Global.format(h, new MerlinUnitType(0).getUnit()))).attrStoreAsWrapper(PROPS).attrGetter(obj -> obj.get(STORED_CAD_HEAD_HEIGHT), STORED_CAD_HEAD_HEIGHT).attrSetter((prop, obj, val) -> {
        UnitDouble prevVal = obj.get(STORED_CAD_HEAD_HEIGHT);
        if (!Objects.equals(prevVal, val)) {
            obj.set(STORED_CAD_HEAD_HEIGHT, val);
            boolean searchGeomDirty = obj.isSearchGeomCalculated();
            obj.changedEvt(true, searchGeomDirty, searchGeomDirty, true);
        }
    }, null).attrUndoPropRestoreAll().attrFinish();
    public static final Predicate<SpeedModifier.Type> ALLOWED_SPEED_MOD_TYPES = Filters.reject(SpeedModifier.Type.CONSTANT);
    public static final TypedProp<Predicate<SpeedModifier.Type>> SPEED_MOD_FILTER = PROPS.storeAsReadOnly(SpeedModifier.PROP_TYPE_FILTER).attrGetter(obj -> ALLOWED_SPEED_MOD_TYPES, Stream.empty()).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROPS);
    public static final DisplayProp<Boolean> VISIBILITY = PROPS.storeAsPlainOldData(MerlinData.VISIBILITY).attrSurrogateEquals(null).attrGetter(EgressBlockage::isVisible, Stream.empty()).attrSetter(EgressBlockage::setVisible, null).attrFinish();
    static final TypedProp<Color> SIMPLE_COLOR = TypedProps.build("EgressBlockage.SIMPLE_COLOR", Color.class, null).attrStoreAsPlainOldData(PROPS).attrFinish();
    static final TypedProp<IOpacity> SIMPLE_OPACITY = TypedProps.build("EgressBlockage.SIMPLE_OPACITY", IOpacity.class, new Opacity(0.5f)).attrStoreAsPlainOldData(PROPS).attrFinish();
    static final TypedProp<IMaterial[]> SIMPLE_MATERIAL = TypedProps.build("EgressBlockage.SIMPLE_MATERIAL", IMaterial[].class, null).attrStoreAsPlainOldData(PROPS).attrDependency(prop -> GeomUtil.newMatDependency(prop)).attrFinish();
    static final TypedProp<Color> CAD_COLOR = GeomUtil.defineColorProp(PROPS, CAD_GEOM, TypedProps.build("EgressBlockage.CAD_COLOR", Color.class, Color.WHITE).attrToProp());
    static final TypedProp<IOpacity> CAD_OPACITY = GeomUtil.defineOpacityProp(PROPS, CAD_GEOM, TypedProps.build("EgressBlockage.CAD_OPACITY", IOpacity.class, new Opacity(1.0f)).attrToProp());
    static final TypedProp<IMaterial[]> CAD_MATERIAL = GeomUtil.defineMaterialProp(PROPS, CAD_GEOM, TypedProps.build("EgressBlockage.CAD_MATERIAL", IMaterial[].class, null).attrToProp());
    static final TypedProp<DisplayType> STORED_DISPLAY_TYPE = TypedProps.build("EgressBlockage.STORED_DISPLAY_TYPE", DisplayType.class, DisplayType.SIMPLE).attrStoreAsPlainOldData(PROPS).attrSetter((prop, obj, newVal) -> {
        if (obj.setToPropertySet(prop, newVal)) {
            obj.changedEvt(MerlinData.SUPPORTED_PROPS_CHANGED);
        }
    }, (prop, obj, newVal) -> obj.setToPropertySet(prop, newVal)).attrFinish();
    public static final DisplayProp<DisplayType> DISPLAY_TYPE = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"EgressBlockage.DISPLAY_TYPE", DisplayType.class, DisplayType.SIMPLE, Intl.intl("Results display"), Intl.intl("Controls the appearance of the obstacle in Results.")).attrFormatValue(type -> type.name)).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROPS).attrGetter(obj -> obj.get(STORED_DISPLAY_TYPE), STORED_DISPLAY_TYPE).attrSetter((prop, blkg, newVal) -> {
        DisplayType oldVal = blkg.get(STORED_DISPLAY_TYPE);
        if (!Objects.equals(oldVal, newVal)) {
            if (newVal != DisplayType.CAD_GEOM) {
                blkg.ensureValidSetSearchGeom();
                blkg.set(CAD_GEOM, (DisplayGeom)EgressBlockage.CAD_GEOM.defVal);
                blkg.d_linkedSearchGeom.clear();
            }
            if (newVal != DisplayType.SIMPLE) {
                blkg.set(SIMPLE_MATERIAL, new IMaterial[]{null});
                blkg.set(SIMPLE_COLOR, (Color)EgressBlockage.SIMPLE_COLOR.defVal);
                blkg.set(SIMPLE_OPACITY, (IOpacity)EgressBlockage.SIMPLE_OPACITY.defVal);
            }
            blkg.set(STORED_DISPLAY_TYPE, newVal);
            if (blkg.getLinkCadGeomToSearch() && (newVal == DisplayType.CAD_GEOM || oldVal == DisplayType.CAD_GEOM)) {
                blkg.changedEvt(true, true, true, false);
            }
        }
    }, null).attrUndoPropRestoreAll().attrComparisonEditor(PropComparisons.factory().options(DisplayType.values())).attrFinish();
    public static final DisplayProp<Color> COLOR = EgressBlockage.defineDisplayProp(MerlinData.COLOR, SIMPLE_COLOR, CAD_COLOR);
    public static final DisplayProp<Color> SEARCH_COLOR = PROPS.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(blkg -> blkg.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<IOpacity> OPACITY = EgressBlockage.defineDisplayProp(MerlinData.OPACITY, SIMPLE_OPACITY, CAD_OPACITY);
    public static final DisplayProp<IMaterial[]> MATERIAL = EgressBlockage.defineDisplayProp(MerlinData.MATERIAL, SIMPLE_MATERIAL, CAD_MATERIAL);
    static final TypedProp<Map<EgressRoom, Pair<IGeom, IGeom>>> ROOM_GEOM = TypedProps.build("EgressBlockage.ROOM_GEOM", theUtil.makeGeneric(Map.class), Map.of()).attrStoreAsTopologyIndirect(PROPS, obj -> new LinkedIdentityHashMap()).attrGetter(obj -> obj.d_roomGeom, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (!obj.d_roomGeom.equals(val)) {
            obj.d_roomGeom = val;
            obj.changedEvt(prop);
        }
    }, (prop, obj, val) -> {
        obj.d_roomGeom = val;
    }).attrSurrogateEquals(null).attrFinish();
    static final TypedProp<IGeomNode> STORED_SET_SEARCH_GEOM = TypedProps.build("EgressBlockage.STORED_SET_SEARCH_GEOM", IGeomNode.class, GeomNodeUtil.EMPTY_NODE).attrStoreAsPlainOldData(PROPS).attrGetter(obj -> obj.d_setSearchGeom, Stream.empty()).attrSetter((prop, obj, geom) -> {
        if (geom == obj.d_setSearchGeom || geom.getNumPrims(6) != 0) {
            return;
        }
        obj.d_setSearchGeom = geom;
        obj.changedEvt(prop);
        obj.changedEvt(true, true, true, false);
    }, (prop, obj, geom) -> {
        obj.d_setSearchGeom = geom;
    }).attrSurrogateEquals(null).attrFinish();
    public static final CompositeProp COMP_DISPLAY_PROP = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(DISPLAY_TYPE, CAD_GEOM, LINK_CAD_GEOM_TO_SEARCH, COLOR, MATERIAL, OPACITY).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROPS).attrFinish();
    private static final Set<TypedProp<?>> SHARED_PROPS = Sets.fromArrayLHS(NAME, TAGS, VISIBILITY, DISPLAY_TYPE, SPEED_MODIFIER, PREVENT_OCC_PLACEMENT, SPEED_MOD_FILTER, CAD_GEOM, LINK_CAD_GEOM_TO_SEARCH, CAD_HEAD_HEIGHT);
    public static final Set<TypedProp<?>> SIMPLE_GEOM_PROPS = Sets.appendLHS(SHARED_PROPS, COLOR, MATERIAL, OPACITY);
    public static final Set<TypedProp<?>> NO_GEOM_PROPS = new LinkedHashSet(SHARED_PROPS);
    public static final Set<TypedProp<?>> CAD_GEOM_PROPS = Stream.concat(SHARED_PROPS.stream(), GeomUtil.CAD_GEOM_PROPS.stream()).collect(Collectors.toSet());
    static final TypedProp<Cache> CACHE = TypedProps.build("EgressBlockage.CACHE", Cache.class, null).attrStoreAsMutable(PROPS).attrCloneAndRestoreValue((obj, val) -> val.clone()).attrGetter(obj -> new Cache(obj.d_linkedSearchGeom, obj.d_cachedGeom, obj.d_searchModel), Stream.empty()).attrSetter(EgressBlockage::setCache, EgressBlockage::setCache).attrFinish();
    public static final SpeedModifier DEFAULT_SPEED_MOD = new SpeedModifier(SpeedModifier.Type.FACTOR, new ConstVariant<UnitDouble>(new UnitDouble(0.0, Unit.ONE)));
    private PropertySet d_props;
    private IGeomNode d_setSearchGeom = GeomNodeUtil.EMPTY_NODE;
    private CachedValue<IGeomNode> d_linkedSearchGeom;
    @SkipDep
    private transient Map<EgressRoom, Pair<IGeom, IGeom>> d_roomGeom = new LinkedIdentityHashMap<EgressRoom, Pair<IGeom, IGeom>>();
    private CachedValue<BlockageGeom> d_cachedGeom;
    private SoftCachedValue<Model> d_searchModel;
    private boolean d_visible = true;
    private static final IDOF LINKED_SEARCH_GEOM_IDOF = new IDOF(){

        @Override
        public boolean accept(TransformInfo ti) {
            Predicate<ScaleXform> stest;
            Predicate<RotateXform> rtest;
            Predicate<MirrorXform> mtest;
            if (ti.isIdentity()) {
                return true;
            }
            Predicate<TranslateXform> ttest = Predicates.alwaysTrue();
            return thunderheadeng.geometry.objs.GeomUtil.testTransforms(ti.xform, ttest, mtest = mir -> theUtil.eq0(mir.plane.z, 1.0E-9), rtest = r -> thunderheadeng.geometry.objs.GeomUtil.isZRotation(r, 1.0E-9), stest = s -> !theUtil.eq0(s.x, 1.0E-6) && !theUtil.eq0(s.y, 1.0E-6) && theUtil.eq(s.z, 1.0, 1.0E-9), o -> o.isIdentity()) || thunderheadeng.geometry.objs.GeomUtil.testTransforms(ti.getMatrix(), ttest, rtest, stest);
        }

        @Override
        public void describeRules(Set<String> rules) {
        }

        public String toString() {
            return "EgressBlock.LINKED_SEARCH_GEOM_IDOF";
        }
    };

    private static final <T> DisplayProp<T> defineDisplayProp(DisplayProp<T> resultProp, TypedProp<T> simple, TypedProp<T> cad) {
        return PROPS.storeAsWrapper(resultProp).attrGetter((prop, obj) -> obj.getDisplayType() == DisplayType.CAD_GEOM ? obj.get(cad) : obj.get(simple), Stream.of(DISPLAY_TYPE, simple, cad)).attrSetter((prop, obj, val) -> {
            TypedProp dispProp = obj.getDisplayType() == DisplayType.CAD_GEOM ? cad : simple;
            obj.set(dispProp, val);
        }, null).attrFinish();
    }

    private boolean getLinkCadGeomToSearch() {
        return this.get(LINK_CAD_GEOM_TO_SEARCH);
    }

    private void setCache(Cache val) {
        this.d_linkedSearchGeom = val.linkedSearchGeom;
        this.d_cachedGeom = val.cachedGeom;
        this.d_searchModel = val.searchModel;
        this.changedEvt(CACHE);
    }

    public EgressBlockage(String name) {
        super(name);
        this.initCache();
        this.d_props = new PropertySet();
        this.set(SPEED_MODIFIER, DEFAULT_SPEED_MOD);
        this.set(SIMPLE_MATERIAL, new IMaterial[]{null});
    }

    private void initCache() {
        this.d_linkedSearchGeom = new CachedValue();
        this.d_cachedGeom = new CachedValue();
        this.d_searchModel = new SoftCachedValue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initCache();
        this.d_roomGeom = new LinkedIdentityHashMap<EgressRoom, Pair<IGeom, IGeom>>();
        this.d_setSearchGeom = GeomNodeUtil.EMPTY_NODE;
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0177)) {
            this.migratePre177Property(MerlinData.COLOR, SIMPLE_COLOR);
            this.migratePre177Property(MerlinData.OPACITY, SIMPLE_OPACITY);
            this.migratePre177Property(MerlinData.MATERIAL, SIMPLE_MATERIAL);
            this.migratePre177Property(CAD_HEAD_HEIGHT, STORED_CAD_HEAD_HEIGHT);
            this.migratePre177Property(CAD_GEOM, STORED_CAD_GEOM);
            this.migratePre177Property(LINK_CAD_GEOM_TO_SEARCH, STORED_LINK_CAD_GEOM_TO_SEARCH);
            this.migratePre177Property(DISPLAY_TYPE, STORED_DISPLAY_TYPE);
        }
    }

    private <T> void migratePre177Property(TypedProp<T> prevKey, TypedProp<T> newKey) {
        assert (!prevKey.key.equals(newKey.key));
        if (this.d_props.isDefined(prevKey)) {
            this.d_props.setIfNotDefault(newKey, this.d_props.get(prevKey));
            this.d_props.remove(prevKey);
        }
    }

    public static SpeedModifier convertLegacyFactor(double speedFactor, IVariant<Boolean> state) {
        ArrayList speedFactors = new ArrayList();
        for (DiscreteVariant.Entry<Boolean> bEntry : VariantUtil.getDiscreteValues(state, true)) {
            boolean blocking = (Boolean)bEntry.val;
            speedFactors.add(new DiscreteVariant.Entry<UnitDouble>(bEntry.t, new UnitDouble(blocking ? speedFactor : 1.0, Unit.ONE)));
        }
        return speedFactors.isEmpty() ? DEFAULT_SPEED_MOD : new SpeedModifier(SpeedModifier.Type.FACTOR, VariantUtil.newVariant(speedFactors));
    }

    @Override
    public EgressBlockage clone() {
        return (EgressBlockage)super.clone();
    }

    public DisplayType getDisplayType() {
        return this.get(DISPLAY_TYPE);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(VISIBILITY);
    }

    public void setSpeedModifier(SpeedModifier smod) {
        this.set(SPEED_MODIFIER, smod);
    }

    public SpeedModifier getSpeedModifier() {
        return this.get(SPEED_MODIFIER);
    }

    public boolean getPreventOccPlacement() {
        return this.get(PREVENT_OCC_PLACEMENT);
    }

    public Material getSimpleDisplayMaterial() {
        if (this.getDisplayType() == DisplayType.SIMPLE) {
            IMaterial[] mats = this.get(SIMPLE_MATERIAL);
            return (Material)mats[0];
        }
        return null;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        return switch (this.get(DISPLAY_TYPE).ordinal()) {
            case 2 -> CAD_GEOM_PROPS;
            case 0 -> NO_GEOM_PROPS;
            case 1 -> SIMPLE_GEOM_PROPS;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield Set.of();
            }
        };
    }

    private void ensureValidSetSearchGeom() {
        if (this.d_setSearchGeom == GeomNodeUtil.EMPTY_NODE && this.getDisplayType() == DisplayType.CAD_GEOM) {
            this.set(STORED_SET_SEARCH_GEOM, this.getLinkedSearchGeom());
        }
    }

    private static int getNumFaces(IGeomNode node) {
        return node.getNumPrims(1);
    }

    private static int getNumEdges(IGeomNode node) {
        return node.getNumPrims(2);
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        boolean isWireframe = dispProps.isWireframe(this);
        if (dispProps instanceof IMerlinDispProps) {
            BlockageGeom bgeom = this.getDisplayBaseGeom((IMerlinDispProps)dispProps, true, validateProgress);
            return new DisplayGeom((IGeomNode)bgeom, IPickable.DEF_PROPS);
        }
        return new DisplayGeom(this.getGeom().getPickable(validateProgress, isWireframe), IPickable.DEF_PROPS);
    }

    private BlockageGeom getDisplayBaseGeom(IMerlinDispProps mprops, boolean pickable, Runnable validateProgress) {
        BlockageGeom bgeom = this.getGeom();
        if (this.isSearchGeomCalculated() && !mprops.getBlockageOptions().contains((Object)IMerlinDispProps.BlockageOptions.SHOW_CAD_SEARCH)) {
            bgeom = new BlockageGeom(bgeom.room, GeomNodeUtil.EMPTY_NODE, bgeom.cad, false);
        }
        if (pickable) {
            boolean wireframe = mprops.isWireframe(this);
            bgeom = new BlockageGeom(bgeom.room.getPickable(validateProgress, wireframe), bgeom.search.getPickable(validateProgress, wireframe), bgeom.cad.getPickable(validateProgress, wireframe), bgeom.searchGeomManipulatable);
        }
        return bgeom;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps mprops = (IMerlinDispProps)props;
        DisplayType dtype = this.getDisplayType();
        BlockageGeom bgeom = this.getDisplayBaseGeom(mprops, false, () -> {});
        PropsBuilder dprops = new PropsBuilder();
        int numFaces = EgressBlockage.getNumFaces(bgeom.room);
        int numEdges = EgressBlockage.getNumEdges(bgeom.room);
        dprops.add(this.getRoomFaceProps(mprops), numFaces);
        dprops.add(mprops.getEdgeProps(this, IMerlinDispProps.EgressType.BLOCKAGE, null, 1.0f), numEdges);
        int numSearchFaces = EgressBlockage.getNumFaces(bgeom.search);
        if (numSearchFaces != 0) {
            float searchOpacity = 0.3f;
            Color searchColor = null;
            if (dtype == DisplayType.SIMPLE) {
                searchColor = this.get(SIMPLE_COLOR);
            }
            dprops.add(mprops.getFaceProps(this, IMerlinDispProps.EgressType.BLOCKAGE_SEARCH, null, searchColor, 0.3f), numSearchFaces);
        }
        if (dtype == DisplayType.CAD_GEOM) {
            DisplayGeom dg = this.get(CAD_GEOM);
            dprops.add(dg.props, dg.node.getNumPrims(7));
        }
        IPropsSrc finalProps = dprops.finalizeProps();
        IGeomNode geom = GeomUtil.finalizeTexCoords((IGeomNode)bgeom, finalProps);
        return new DisplayGeom(geom, finalProps);
    }

    public IPrimProps getRoomFaceProps(IMerlinDispProps mprops) {
        Material mat = null;
        Color color = null;
        float opacity = 1.0f;
        if (this.getDisplayType() == DisplayType.SIMPLE) {
            mat = (Material)this.get(SIMPLE_MATERIAL)[0];
            color = this.get(SIMPLE_COLOR);
            opacity = this.get(SIMPLE_OPACITY).getValue();
        }
        return mprops.getFaceProps(this, IMerlinDispProps.EgressType.BLOCKAGE, mat, color, opacity);
    }

    public boolean isSearchGeomSettable() {
        return !this.isSearchGeomCalculated();
    }

    public boolean isSearchGeomCalculated() {
        return this.getDisplayType() == DisplayType.CAD_GEOM && this.get(LINK_CAD_GEOM_TO_SEARCH) != false;
    }

    private IGeomNode getLinkedSearchGeom() {
        return this.d_linkedSearchGeom.get(() -> {
            if (!this.isSearchGeomCalculated()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Mesh dmesh = new Mesh();
            IGeomNode cad = this.get(EgressBlockage.CAD_GEOM).node.flatten();
            double[] zrange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            HashSet closedPoints = new HashSet();
            Consumer<Point3d> addPoint = p -> {
                zrange[0] = Math.min(zrange[0], p.z);
                zrange[1] = Math.max(zrange[1], p.z);
                Point2d p2d = Util2D.round(new Point2d(p.x, p.y), 3);
                if (closedPoints.add(p2d)) {
                    dmesh.addPoint(p2d.x, p2d.y);
                }
            };
            double faceTol = this.getDomain() != null ? ((MerlinData)this.getDomain()).simParams.get(SimParams.FACE_ERROR) : 1.0E-6;
            double edgeTol = this.getDomain() != null ? ((MerlinData)this.getDomain()).simParams.get(SimParams.EDGE_ERROR) : 1.0E-6;
            List<Triangle> tris = thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(faceTol, cad.getLocalGeom());
            for (Triangle triangle : tris) {
                for (int m = 0; m < 3; ++m) {
                    addPoint.accept(triangle.getPoint(m));
                }
            }
            List<LineSeg> lineSegs = thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(edgeTol, cad.getLocalGeom());
            for (LineSeg ls : lineSegs) {
                addPoint.accept(ls.p1);
                addPoint.accept(ls.p2);
            }
            List list = thunderheadeng.geometry.objs.GeomUtil.explode(cad.getLocalGeom(), Point.class);
            list.stream().forEach(p -> addPoint.accept(p.loc));
            if (closedPoints.isEmpty()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            if (!dmesh.triangulateConvexHull(0)) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            List<Point2d> chull = dmesh.getConvexHull();
            if (chull.size() < 3) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Point3d[] basePoints = new Point3d[chull.size()];
            for (int m = 0; m < chull.size(); ++m) {
                Point2d p2d = chull.get(m);
                basePoints[m] = new Point3d(p2d.x, p2d.y, zrange[1]);
            }
            IPolygon base = PolyUtil.newPoly(basePoints);
            Vector3d extrusion = new Vector3d(0.0, 0.0, zrange[0] - zrange[1] - this.get(CAD_HEAD_HEIGHT).get(Geometry.LENGTH_UNIT));
            ExtrudedPoly epoly = new ExtrudedPoly(base, extrusion);
            return GeomNodeUtil.newNode(epoly);
        });
    }

    public void setSearchGeom(IGeomNode geom) {
        if (!this.isSearchGeomSettable()) {
            return;
        }
        this.set(STORED_SET_SEARCH_GEOM, geom);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (!(geom instanceof BlockageGeom)) {
            assert (false) : "You probably wanted to use setSearchGeom instead";
            return;
        }
        this.pauseUpdates();
        BlockageGeom bgeom = (BlockageGeom)geom;
        DisplayType dt = this.getDisplayType();
        TransformInfo xformInfo = bgeom.getLocalTransform().getInfo();
        if (this.isSearchGeomSettable()) {
            this.setSearchGeom(bgeom.search.transform(xformInfo));
        }
        if (dt == DisplayType.CAD_GEOM) {
            DisplayGeom existingCad = this.get(CAD_GEOM);
            assert (existingCad != null);
            if (existingCad != null) {
                boolean primCountMatch;
                boolean bl = primCountMatch = existingCad.node.getNumPrims(7) == bgeom.cad.getNumPrims(7);
                assert (primCountMatch);
                if (primCountMatch) {
                    this.set(CAD_GEOM, new DisplayGeom(bgeom.cad.quickTransform(xformInfo), existingCad.props));
                    if (this.isSearchGeomCalculated()) {
                        this.d_linkedSearchGeom.set(bgeom.search.transform(xformInfo));
                        boolean regenLinkedSearch = !LINKED_SEARCH_GEOM_IDOF.accept(xformInfo);
                        this.changedEvt(true, true, true, regenLinkedSearch);
                    }
                }
            }
        }
        this.resumeUpdates();
    }

    public boolean changedEvt(boolean geomChanged, boolean regenTopo, boolean regenSearchModel, boolean regenLinkedSearchGeom) {
        regenTopo |= (regenSearchModel |= regenLinkedSearchGeom);
        if (regenLinkedSearchGeom) {
            this.d_linkedSearchGeom.clear();
        }
        if (regenSearchModel) {
            this.d_searchModel.clear();
        }
        if (geomChanged) {
            this.d_cachedGeom.clear();
        }
        if (regenTopo) {
            this.markTopoDirty();
        }
        return super.changedEvt(new Object[0]);
    }

    protected void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public BlockageGeom getGeom() {
        return this.d_cachedGeom.get(() -> {
            DisplayType dt = this.getDisplayType();
            ArrayList<IGeom> faces = new ArrayList<IGeom>();
            ArrayList<IGeom> edges = new ArrayList<IGeom>();
            for (Pair<IGeom, IGeom> entry : this.d_roomGeom.values()) {
                faces.add((IGeom)entry.v1);
                edges.add((IGeom)entry.v2);
            }
            ArrayList<IGeom> allRoomGeoms = new ArrayList<IGeom>(faces.size() + edges.size());
            allRoomGeoms.addAll(faces);
            allRoomGeoms.addAll(edges);
            IGeom roomGeom = thunderheadeng.geometry.objs.GeomUtil.group(allRoomGeoms);
            GeomNodeLeaf roomNode = GeomNodeUtil.newNode(roomGeom);
            IGeomNode searchGeom = this.getSearchGeom();
            IGeomNode cadNode = dt == DisplayType.CAD_GEOM ? this.get(EgressBlockage.CAD_GEOM).node : GeomNodeUtil.EMPTY_NODE;
            return new BlockageGeom(roomNode, searchGeom, cadNode, this.isSearchGeomSettable());
        });
    }

    public IGeomNode getSearchGeom() {
        return this.isSearchGeomSettable() ? this.d_setSearchGeom : this.getLinkedSearchGeom();
    }

    public IGeomNode getSetSearchGeom() {
        return this.d_setSearchGeom;
    }

    public Model getSearchModel() {
        return this.d_searchModel.get(() -> GeomUtil.toNmtModel((MerlinData)this.getDomain(), this.getSearchGeom(), 0));
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{EgressRoom.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_roomGeom.keySet();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return true;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (this.d_roomGeom.remove(conn) != null) {
            this.changedEvt(true, false, false, false);
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        assert (this.d_roomGeom.containsKey(conn));
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_roomGeom);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_roomGeom = (Map)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return true;
        }
        this.d_roomGeom.clear();
        AABox bounds = this.getSearchGeom().getBoundingBox(new AABox());
        Collection<EgressRoom> nearRooms = md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), EgressRoom.class, room -> room.getModificationsAllowed(), 1);
        boolean modelOptions = false;
        for (EgressRoom room2 : nearRooms) {
            EgressRoom.RoomBlockageInfo blkgInfo;
            EgressModelGeom geom = this.getModelGeom(room2, blkgInfo = room2.intersectBlockages(Collections.singletonList(this)), 0);
            if (geom == null) continue;
            ArrayList faces = new ArrayList();
            ArrayList edges = new ArrayList();
            geom.getFaceGeom(faces::add);
            geom.getEdgeGeom(edges::add);
            this.d_roomGeom.put(room2, new Pair<IGeom, IGeom>(thunderheadeng.geometry.objs.GeomUtil.group(faces), thunderheadeng.geometry.objs.GeomUtil.group(edges)));
        }
        this.changedEvt(true, false, false, false);
        return true;
    }

    public void getInfernoGeom(Consumer<InfernoGeom> geoms, IMerlinDispProps dprops, EgressRoom room, EgressRoom.RoomBlockageInfo blkgInfo) {
        EgressModelGeom geom = this.getModelGeom(room, blkgInfo, 1);
        if (geom == null) {
            return;
        }
        geoms.accept(new InfernoGeom(this, InfernoType.REMOVABLE, geom, this.getRoomFaceProps(dprops)));
    }

    protected EgressModelGeom getModelGeom(EgressRoom room, EgressRoom.RoomBlockageInfo blkgInfo, int modelOptions) {
        final int faceId = blkgInfo.getFaceId(this);
        if (faceId == -1) {
            return null;
        }
        Model model = blkgInfo.model;
        Predicate<Face> faceFilter = new Predicate<Face>(){

            @Override
            public boolean test(Face o) {
                return o.partOfGroup(faceId);
            }
        };
        Predicate<Edge> edgeFilter = new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (o.partOfGroup(1)) {
                    return false;
                }
                int fCount = 0;
                for (Face face : o.faces) {
                    if (!face.partOfGroup(faceId)) continue;
                    ++fCount;
                }
                return fCount == 1;
            }
        };
        return new EgressModelGeom(model, room.getInUseEdgeFilter(), faceFilter, edgeFilter, modelOptions);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        double closestDistSq = Double.MAX_VALUE;
        Point3d closestPoint = null;
        for (Pair<IGeom, IGeom> roomGeom : this.d_roomGeom.values()) {
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode((IGeom)roomGeom.v1, IFace.class)) {
                Point3d proj = face.project(p);
                double distSq = proj.distanceSquared(p);
                if (!(distSq < closestDistSq)) continue;
                closestDistSq = distSq;
                closestPoint = proj;
            }
        }
        return closestPoint;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        Pair<IGeom, IGeom> roomGeom = this.d_roomGeom.get(adj);
        assert (roomGeom != null);
        if (roomGeom == null) {
            return new Point3d();
        }
        for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode((IGeom)roomGeom.v1, IFace.class)) {
            if (face instanceof IPolygon) {
                IPolygon poly = (IPolygon)face;
                return poly.getPoint(0, 0);
            }
            thunderheadeng.geometry.objs.Mesh m = face.triangulate(1.0E-6);
            if (m.vertices.length <= 0) continue;
            return m.vertices[0];
        }
        assert (false);
        return new Point3d();
    }

    record Cache(CachedValue<IGeomNode> linkedSearchGeom, CachedValue<BlockageGeom> cachedGeom, SoftCachedValue<Model> searchModel) implements Cloneable
    {
        public Cache clone() {
            return new Cache((CachedValue<IGeomNode>)this.linkedSearchGeom.clone(), (CachedValue<BlockageGeom>)this.cachedGeom.clone(), (SoftCachedValue<Model>)this.searchModel.clone());
        }
    }

    public static enum DisplayType implements ILabeled
    {
        NONE(Intl.intl("None"), Intl.intl("The obstacle will not be displayed in Results.")),
        SIMPLE(Intl.intl("Simple"), Intl.intl("The obstacle will be displayed in Results as a polygon extruded up from the nav mesh.")),
        CAD_GEOM(Intl.intl("Imported"), Intl.intl("The obstacle will display imported CAD geometry in Results."));

        public final String name;
        public final String desc;

        private DisplayType(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class BlockageGeom
    extends AGeomNode {
        private static final long serialVersionUID = 1L;
        public final IGeomNode room;
        public final IGeomNode search;
        public final IGeomNode cad;
        public final boolean searchGeomManipulatable;

        public BlockageGeom() {
            this(GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE, false);
        }

        public BlockageGeom(IGeomNode roomGeom, IGeomNode searchGeom, IGeomNode cadGeom, boolean searchGeomManipulatable) {
            this(TransformUtil.IDENTITY, roomGeom, searchGeom, cadGeom, searchGeomManipulatable);
        }

        public BlockageGeom(ITransform xform, IGeomNode roomGeom, IGeomNode searchGeom, IGeomNode cadGeom, boolean searchGeomManipulatable) {
            super(xform, EmptyGeom.INSTANCE, Elements.newElements());
            this.room = roomGeom;
            this.search = searchGeom;
            this.cad = cadGeom;
            this.searchGeomManipulatable = searchGeomManipulatable;
        }

        @Override
        public IGeomNode newNode(ITransform xform, IGeom geom, IPropertySet elements, Collection<? extends IGeomNode> children) {
            assert (geom.getNumPrims(7) == 0);
            assert (children.size() == 3);
            Iterator<? extends IGeomNode> childIt = children.iterator();
            return new BlockageGeom(xform, childIt.next(), childIt.next(), childIt.next(), this.searchGeomManipulatable);
        }

        @Override
        public Collection<? extends IGeomNode> getChildren() {
            return Arrays.asList(this.room, this.search, this.cad);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            if (!this.searchGeomManipulatable) {
                return;
            }
            IGeomNode.generateLocalHandles(this.search, handle -> {
                if (handle instanceof IGeomNode.Handle) {
                    handles.accept(new SearchGeomHandle((IGeomNode.Handle)handle));
                }
            });
        }

        public class SearchGeomHandle
        implements IHandle {
            public final IGeomNode.Handle base;

            public SearchGeomHandle(IGeomNode.Handle base) {
                this.base = base;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                return ((SearchGeomHandle)obj).base.equals(this.base);
            }

            @Override
            public IGeomNode getGeom() {
                return this.base.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.base.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.base.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.base.begin(handleLoc, constraint);
            }

            @Override
            public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                return this.modifySearch(this.base.modify(constraintInfo, newLoc));
            }

            @Override
            public Object end() {
                return this.modifySearch(this.base.end());
            }

            private BlockageGeom modifySearch(IGeomNode newSearch) {
                return new BlockageGeom(BlockageGeom.this.getLocalTransform(), BlockageGeom.this.room, newSearch, BlockageGeom.this.cad, BlockageGeom.this.searchGeomManipulatable);
            }
        }
    }
}

