/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TypeFilter;

public class VehicleShapeComp
extends Composite<VehicleShape> {
    static final long serialVersionUID = 1L;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(VehicleShape.class, VehicleShapeComp.class);

    public VehicleShapeComp() {
        this(Intl.intl("Vehicle Shapes"));
        this.addDefault();
    }

    public VehicleShapeComp(String name) {
        super(name);
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new VehicleShapeComp(name);
    }

    public void addDefault() {
        VehicleShape defaultWheelchair = new VehicleShape();
        defaultWheelchair.set(VehicleShape.PROP_NAME, Intl.intl("Default Wheelchair"));
        defaultWheelchair.set(VehicleShape.PROP_POINTS, VehicleShape.POINTS_DEFAULT_WHEELCHAIR);
        defaultWheelchair.set(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS, VehicleShape.ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR);
        defaultWheelchair.set(VehicleShape.PROP_ANIM_TAGS, VehicleShape.AnimType.WHEELCHAIR.tags);
        defaultWheelchair.set(VehicleShape.PROP_MODEL, new ResourceAvatar("props/Wheelchair/Wheelchair.bea"));
        defaultWheelchair.set(VehicleShape.PROP_ALLOW_LATERAL, false);
        this.add(defaultWheelchair);
        VehicleShape defaultBed = new VehicleShape();
        defaultBed.set(VehicleShape.PROP_NAME, Intl.intl("Default Bed"));
        defaultBed.set(VehicleShape.PROP_POINTS, VehicleShape.POINTS_DEFAULT_BED_TWO_NURSES);
        defaultBed.set(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS, VehicleShape.ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES);
        defaultBed.set(VehicleShape.PROP_ANIM_TAGS, VehicleShape.AnimType.BED.tags);
        defaultBed.set(VehicleShape.PROP_MODEL, new ResourceAvatar("props/HospitalBed02/HospitalBed02.bea"));
        defaultBed.set(VehicleShape.PROP_OCCAVATAR_OFFSET, new UnitPoint3D(-0.15, 0.0, 0.9, SI.METER));
        defaultBed.set(VehicleShape.PROP_ALLOW_LATERAL, true);
        this.add(defaultBed);
    }

    public void loadFrom(VehicleShapeComp vShapeComp) {
        this.pauseUpdates();
        super.loadFrom(vShapeComp);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.resumeUpdates();
    }

    @Override
    public void loadFrom(Composite<VehicleShape> obj) {
        assert (obj instanceof VehicleShapeComp);
        this.loadFrom((VehicleShapeComp)obj);
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Vehicle Shape Group");
    }
}

