/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.geom.Inter2D;
import merlin.util.Dependencies;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class OccTarget
extends NamedMerlinObj
implements Serializable,
IEgressObj,
IOrientable,
ISurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<OccTarget> PROPS = PropertyDefs.defsInheritPropsOnly(OccTarget.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), NamedMerlinObj.PROPS);
    public static final TypedProp<Point3d> LOCATION = TypedProps.build(128448899, Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROPS).attrFireEvents((prop, obj) -> obj.changedEvt(prop, MerlinData.TOPOLOGY)).attrFinish();
    public static final TypedProp<IEgressOccupiable> ROOM = TypedProps.build("OccTarget.ROOM", IEgressOccupiable.class, null).attrStoreAsTopologyDirect(PROPS).attrGetter(OccTarget::getRoom, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (obj.d_room != val) {
            obj.d_room = val;
            obj.changedEvt(prop);
        }
    }, null).attrSurrogateEquals(null).attrDependency(prop -> Dependencies.newDependencyContainedBy(IEgressOccupiable.class)).attrFinish();
    public static final TypedProp<Vector3d> ROOM_NORMAL = TypedProps.build(92873722, Vector3d.class, new Vector3d(0.0, 0.0, 1.0)).attrStoreAsPlainOldData(PROPS).attrSurrogateEquals(null).attrCloneAndRestoreValue(null).attrFinish();
    public static final TypedProp<UnitDouble> RADIUS = TypedProps.build((Object)199365103, new UnitDouble(0.5, SI.METER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<UnitDouble> ORIENT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)37401378, new UnitDouble(0.0, NonSI.DEGREE_ANGLE), Intl.intl("Orientation"), "<html>" + Intl.intl("The orientation of the occupant when they occupy this target.<br>This is an angle relative to the +X axis."), 7).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrComparisonEditor(PropComparisons.factory().unitdouble(7)).attrFinish();
    public static final DisplayProp<Double> PRIORITY = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)121055651, 0.0, Intl.intl("Priority"), "<html>" + Intl.intl("Defines a priority that can optionally be used by occupants to prioritize some<br>targets over others.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"OccTarget.STORED_VISIBILITY", true).attrMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROPS).attrGetter(obj -> obj.d_visible, Stream.empty()).attrSetter(OccTarget::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROPS.storeAsWrapper(MerlinData.VISIBILITY).attrGetter(OccTarget::isVisible, Stream.of(MerlinData.ENABLED, STORED_VISIBILITY)).attrSetter(OccTarget::setVisible, null).attrFinish();
    public static final DisplayProp<Boolean> ENABLED = PROPS.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(OccTarget::isEnabled, Stream.empty()).attrSetter(OccTarget::setEnabled, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROPS);
    @SkipDep
    private transient IEgressOccupiable d_room;
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;
    private boolean d_enabled = true;

    public OccTarget(String name) {
        super(name);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROPS;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        this.changedEvt(MerlinData.ENABLED, MerlinData.TOPOLOGY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(STORED_VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room != null ? Collections.singleton(this.d_room) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public boolean updateTopo() {
        Point3d loc = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(loc.x, loc.y, loc.z + 1.0E-6), new Point3d(loc.x, loc.y, loc.z - 1.0E-6), 1);
        if (room != null) {
            this.pauseUpdates();
            this.d_room = room.room;
            this.set(ROOM_NORMAL, room.faceNormal);
            loc = room.p;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public void setOrientTarget(Point3d target) {
        this.setOrient(GeomUtil.getOccOrient(this.get(LOCATION), target));
    }

    @Override
    public void setOrient(UnitDouble angle) {
        this.set(ORIENT, angle);
    }

    @Override
    public boolean isValidOrient(UnitDouble angle) {
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.get(LOCATION);
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.get(LOCATION);
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        if (loc.equals(this.d_props.get(LOCATION)) && roomNormal.equals(this.d_props.get(ROOM_NORMAL)) && this.d_room == room) {
            return;
        }
        this.d_props.set(LOCATION, loc);
        this.d_props.set(ROOM_NORMAL, roomNormal);
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(LOCATION, ROOM_NORMAL, ROOM, MerlinData.TOPOLOGY);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getTargetGeom());
    }

    private OccTargetGeometry getTargetGeom() {
        return new OccTargetGeometry(this.d_room, this.get(ROOM_NORMAL), this.get(LOCATION), this.get(RADIUS).getValue(Geometry.LENGTH_UNIT), this.get(ORIENT).getValue(Geometry.ANGLE_UNIT));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof OccTargetGeometry) {
            OccTargetGeometry wgeom = (OccTargetGeometry)geom;
            this.pauseUpdates();
            this.set(RADIUS, new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.set(ORIENT, new UnitDouble(wgeom.orient, Geometry.ANGLE_UNIT));
            this.changedEvt(MerlinData.TOPOLOGY);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.set(LOCATION, p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IGeomNode geom = this.getGeom();
        IMerlinDispProps dprops = (IMerlinDispProps)props;
        PropsBuilder gprops = new PropsBuilder();
        IPrimProps edgeProps = dprops.getEdgeProps(this, IMerlinDispProps.EgressType.OCC_TARGET, null, 1.0f);
        gprops.add(edgeProps);
        gprops.add(dprops.getFaceProps(this, IMerlinDispProps.EgressType.OCC_TARGET, null, null, 1.0f));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        gprops.add(edgeProps);
        return new DisplayGeom(geom, gprops);
    }

    private static LineSeg getOrientGeom(Point3d location, double angle, double length) {
        Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
        Inter.rotateTuple2D(orient, angle, new Point3d(0.0, 0.0, 0.0));
        orient.scale(length);
        orient.add(location);
        Point3d orientPoint = new Point3d(orient);
        return new LineSeg(location, orientPoint);
    }

    public static class OccTargetGeometry
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = -5574029433922814496L;
        public final double orient;

        public OccTargetGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double arriveRadius, double orient) {
            super(room, normal, location, arriveRadius, true, OccTarget.getOrientGeom(location, orient, 1.0));
            this.orient = orient;
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double newRadius) {
            if (find == null) {
                return new OccTargetGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc, newRadius, this.orient);
            }
            return new OccTargetGeometry(find.room, find.faceNormal, newLoc, newRadius, this.orient);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new OrientHandle(this));
            handles.accept(new GeomUtil.LocationHandle(this));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new OccTargetGeometry(room, normal, location, radius, this.orient);
        }
    }

    public static class OrientHandle
    implements IHandle {
        private OccTargetGeometry d_geom;
        private final double handleLength = 1.0;

        public OrientHandle(OccTargetGeometry geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OrientHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(OccTarget.getOrientGeom(this.d_geom.location, this.d_geom.orient, 1.0));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public OccTargetGeometry modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
            Point3d agentLoc = this.d_geom.location;
            Point3d agentOrient = new Point3d(agentLoc);
            agentOrient.add(new Point3d(1.0, 0.0, 0.0));
            double newAngle = Inter2D.getAngle(agentLoc, agentOrient, newLoc);
            this.d_geom = new OccTargetGeometry(this.d_geom.room, this.d_geom.normal, this.d_geom.location, this.d_geom.radius, newAngle);
            return this.d_geom;
        }

        @Override
        public OccTargetGeometry end() {
            return this.d_geom;
        }
    }
}

