/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.egress.agents.OccProfile;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.util.TypeFilter;

public class OccProfileComp
extends Composite<OccProfile> {
    static final long serialVersionUID = 1L;
    @SkipDep
    public OccProfile NO_CHANGE;
    @SkipDep
    public OccProfile DEFAULT;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(OccProfile.class, OccProfileComp.class);

    public OccProfileComp() {
        this(Intl.intl("Profiles"));
        this.addDefault();
        this.initNoChangeProfile();
    }

    public OccProfileComp(String name) {
        super(name);
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new OccProfileComp(name);
    }

    public void addDefault() {
        this.DEFAULT = new OccProfile();
        this.DEFAULT.set(OccProfile.PROP_NAME, Intl.intl("Default"));
        this.add(this.DEFAULT);
    }

    private void initNoChangeProfile() {
        this.NO_CHANGE = new OccProfile();
        this.NO_CHANGE.setName(Intl.intl("No Change"));
        this.NO_CHANGE.set(OccProfile.PROP_NO_CHANGE, true);
    }

    public void loadFrom(OccProfileComp profComp) {
        this.pauseUpdates();
        super.loadFrom(profComp);
        if (this.isEmpty()) {
            this.addDefault();
        }
        this.NO_CHANGE = profComp.NO_CHANGE;
        if (this.NO_CHANGE == null) {
            this.initNoChangeProfile();
        }
        this.resumeUpdates();
    }

    @Override
    public void loadFrom(Composite<OccProfile> obj) {
        assert (obj instanceof OccProfileComp);
        this.loadFrom((OccProfileComp)obj);
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.addDefault();
        this.resumeUpdates();
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Profile Group");
    }
}

