/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class EgressAgentComp
extends GeomComposite<EgressAgent>
implements ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    static final TypedProp<Set<IMerlinObj>> CHILDREN = GeomComposite.CHILDREN;
    static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(EgressAgent.class, EgressAgentComp.class);

    public EgressAgentComp(String name) {
        super(name);
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new EgressAgentComp(name);
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    protected boolean getCachingAllowed(TypedProp<?> prop) {
        if (OccProfile.ALL_PROPS.contains(prop)) {
            return false;
        }
        return super.getCachingAllowed(prop);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Occupant Group");
    }

    public String getGroupPath() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md != null) {
            Object[] objPath = md.hierarchy.getPath(this, md, false);
            return Arrays.stream(objPath).map(obj -> ((IMerlinObj)obj).getName()).collect(Collectors.joining("/"));
        }
        return this.getName();
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (!super.cyclicEquals(comparable, comparedSet)) {
            return false;
        }
        if (comparable instanceof EgressAgentComp) {
            EgressAgentComp other = (EgressAgentComp)comparable;
            return theUtil.surrogateListsEqual(this.getChildren(), other.getChildren(), comparedSet);
        }
        return false;
    }
}

