/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.egress.Floor;
import merlin.data.property.PropertyDefs;
import merlin.geom.Geometry;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class FloorComposite
extends Composite<Floor> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<FloorComposite> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(FloorComposite.class, FloorComposite::invalidateClippingRegions, Composite.PROP_TYPES);
    static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    public static final TypedProp<Floor> ACTIVE_FLOOR = TypedProps.build((Object)"FloorComposite.ACTIVE_FLOOR", Floor.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(FloorComposite::getActive, Stream.empty()).attrSetter(FloorComposite::setActive, null).attrCloneValue((obj, val) -> null).attrRestoreValue((obj, val) -> val).attrFinish();
    @SkipDep
    private Floor d_activeFloor;
    @SkipDep
    private transient Map<Floor, ConvexHull> d_clippingRegions;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(Floor.class);

    public FloorComposite() {
        super(Intl.intl("Floors"));
        this.addDefFloor();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public FloorComposite clone() {
        return (FloorComposite)super.clone();
    }

    private void addDefFloor() {
        Floor floor = new Floor(new UnitDouble(0.0, SI.METER));
        this.pauseUpdates();
        this.add(floor);
        if (this.getMembers().size() == 1) {
            this.setActive(floor);
        }
        this.resumeUpdates();
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    public FloorComposite newGroup(String name) {
        return null;
    }

    @Override
    public void add(IMerlinObj obj) {
        this.pauseUpdates();
        super.add(obj);
        this.invalidateClippingRegions();
        this.resumeUpdates();
    }

    @Override
    public boolean remove(IMerlinObj obj) {
        this.pauseUpdates();
        boolean result = super.remove(obj);
        if (result) {
            if (this.getMembers().isEmpty()) {
                this.addDefFloor();
            } else if (this.d_activeFloor == obj) {
                this.setActive((Floor)this.getMembers().iterator().next());
            }
            this.invalidateClippingRegions();
        }
        this.resumeUpdates();
        return result;
    }

    public Floor getActive() {
        return this.d_activeFloor;
    }

    public void setActive(Floor floor) {
        if (floor == this.d_activeFloor) {
            return;
        }
        this.pauseUpdates();
        if (this.d_activeFloor != null) {
            this.d_activeFloor.changedEvt(ACTIVE_FLOOR);
        }
        this.d_activeFloor = floor;
        if (this.d_activeFloor != null) {
            this.d_activeFloor.changedEvt(ACTIVE_FLOOR);
        }
        this.changedEvt(ACTIVE_FLOOR);
        this.resumeUpdates();
    }

    public Floor getFloor(UnitDouble loc) {
        for (Floor floor : this.getMembers(Floor.class)) {
            if (!floor.getWorkingZ().epsilonEquals(loc, 1.0E-6)) continue;
            return floor;
        }
        return null;
    }

    public Floor[] getSurroundingFloors(UnitDouble loc) {
        return this.getSurroundingFloors(loc, 1.0E-6);
    }

    public Floor[] getSurroundingFloors(UnitDouble loc, final double tol) {
        ArrayList<Floor> floors = new ArrayList<Floor>(this.getMembers(Floor.class));
        assert (!floors.isEmpty());
        int ix = Collections.binarySearch(floors, loc, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Floor floor = (Floor)o1;
                UnitDouble v = (UnitDouble)o2;
                double v1 = floor.getWorkingZ().getValue(Geometry.LENGTH_UNIT);
                double v2 = v.getValue(Geometry.LENGTH_UNIT);
                return theUtil.compare(v1, v2, tol);
            }
        });
        if (ix < 0) {
            ix = -ix - 2;
        }
        if (ix < 0) {
            return new Floor[]{null, (Floor)floors.get(0)};
        }
        if (ix == floors.size() - 1) {
            return new Floor[]{(Floor)floors.get(ix), null};
        }
        return new Floor[]{(Floor)floors.get(ix), (Floor)floors.get(ix + 1)};
    }

    public void loadFrom(FloorComposite nn) {
        this.pauseUpdates();
        ArrayList<Floor> floors = new ArrayList<Floor>(nn.getMembers(Floor.class));
        for (Floor f : floors) {
            f.repairBrokenFloors(nn);
        }
        super.clear();
        this.addAll(nn.getMembers());
        this.setActive(nn.d_activeFloor);
        this.setResultsId(nn.getResultsId());
        this.resumeUpdates();
    }

    @Override
    public void loadFrom(Composite<Floor> obj) {
        assert (obj instanceof FloorComposite);
        this.loadFrom((FloorComposite)obj);
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.addDefFloor();
        this.resumeUpdates();
    }

    private void generateClippingRegions() {
        if (this.d_clippingRegions != null) {
            return;
        }
        this.d_clippingRegions = new IdentityHashMap<Floor, ConvexHull>();
        Collection<Floor> floors = this.getMembers(Floor.class);
        Unit lu = Geometry.LENGTH_UNIT;
        Object[] floorLocs = null;
        for (Floor floor : floors) {
            UnitDouble[] zfilter = floor.getZFilter();
            if (zfilter[0] != Floor.CURR_FLOOR && zfilter[1] != Floor.NEXT_FLOOR) continue;
            Collection<Floor> allFloors = this.getMembers(Floor.class);
            floorLocs = new UnitDouble[allFloors.size()];
            int ix = 0;
            for (Floor floor1 : allFloors) {
                floorLocs[ix++] = floor1.getWorkingZ();
            }
            Arrays.sort(floorLocs);
            break;
        }
        double tol = 1.0E-4;
        for (Floor floor : floors) {
            UnitDouble[] zfilter = floor.getZFilter();
            Object minz = zfilter[0];
            Object maxz = zfilter[1];
            if (minz == Floor.CURR_FLOOR || maxz == Floor.NEXT_FLOOR) {
                assert (floorLocs != null);
                int locix = Arrays.binarySearch(floorLocs, floor.getWorkingZ());
                assert (locix >= 0 && locix < floorLocs.length);
                if (minz == Floor.CURR_FLOOR && locix > 0) {
                    minz = floorLocs[locix];
                }
                if (maxz == Floor.NEXT_FLOOR && locix < floorLocs.length - 1) {
                    maxz = floorLocs[locix + 1];
                }
            }
            ArrayList<Plane3d> planes = new ArrayList<Plane3d>(2);
            if (minz != Floor.CURR_FLOOR) {
                planes.add(new Plane3d(0.0, 0.0, -1.0, ((UnitDouble)minz).getValue(lu) - tol));
            }
            if (maxz != Floor.NEXT_FLOOR) {
                planes.add(new Plane3d(0.0, 0.0, 1.0, -((UnitDouble)maxz).getValue(lu) + tol));
            }
            this.d_clippingRegions.put(floor, new ConvexHull(planes));
        }
    }

    public ConvexHull[] getClippingRegions(Floor ... floors) {
        this.generateClippingRegions();
        ConvexHull[] hulls = new ConvexHull[floors.length];
        for (int m = 0; m < floors.length; ++m) {
            Floor floor = floors[m];
            ConvexHull ch = this.d_clippingRegions.get(floor);
            assert (ch != null);
            hulls[m] = ch;
        }
        return hulls;
    }

    public ConvexHull getClippingRegion(Floor floor) {
        this.generateClippingRegions();
        ConvexHull ch = this.d_clippingRegions.get(floor);
        assert (ch != null);
        return ch;
    }

    protected void invalidateClippingRegions() {
        this.d_clippingRegions = null;
    }
}

