/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.IEgressObj;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class Floor
extends GeomComposite<IMerlinObj>
implements IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    public static final UnitDouble CURR_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final UnitDouble NEXT_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final PropertyDefs<Floor> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(Floor.class, null, GeomComposite.PROP_TYPES, Filters.reject(NamedMerlinObj.NAME, GeomComposite.STORED_VISIBILITY));
    static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    public static final DisplayProp<UnitDouble> WORKING_Z = (DisplayProp)DisplayProps.build((Object)"Floor.WORKING_Z", new UnitDouble(0.0, SI.METER), Intl.intl("Working Z"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Floor::getWorkingZ, Stream.empty()).attrSetter(Floor::setWorkingZ, null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<String> NAME = Floor.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            MerlinData md = (MerlinData)obj.getDomain();
            BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
            name = String.format(Intl.intl("Floor %s"), Global.format(obj.getWorkingZ().convert(lu)));
        }
        return name;
    }, Stream.of(STORED_NAME, WORKING_Z)).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = Floor.defineVisibilityLocally(PROP_TYPES, false);
    public static final DisplayProp<UnitDouble> ZMIN_FILTER = (DisplayProp)DisplayProps.build((Object)"Floor.ZMIN_FILTER", new UnitDouble(Double.NaN, SI.METER), Intl.intl("Z Min Filter"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(floor -> floor.getZFilter()[0], Stream.empty()).attrSetter((floor, value) -> floor.setZFilter((UnitDouble)value, floor.getZFilter()[1]), null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> ZMAX_FILTER = (DisplayProp)DisplayProps.build((Object)"Floor.ZMAX_FILTER", new UnitDouble(Double.NaN, SI.METER), Intl.intl("Z Max Filter"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(floor -> floor.getZFilter()[1], Stream.empty()).attrSetter((floor, value) -> floor.setZFilter(floor.getZFilter()[0], (UnitDouble)value), null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final TypedProp<GeomComposite<IMerlinObj>> WORKING_GROUP = TypedProps.buildGeneric("Floor.WORKING_GROUP", GeomComposite.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyGeneric(prop, DLink.WEAK, GeomComposite.class, null, (md, src, group) -> Stream.of(group), null, (md, src, val, old, repl) -> repl)).attrSetter(Floor::setWorkingGeomGroup, null).attrGetter(Floor::getWorkingGeomGroup, Stream.empty()).attrCloneValue((floor, group) -> null).attrRestoreValue((floor, group) -> group).attrSurrogateEquals(null).attrFinish();
    private UnitDouble d_defWorkingZ;
    private UnitDouble d_zminFilter;
    private UnitDouble d_zmaxFilter;
    @SkipDep
    private GeomComposite<IMerlinObj> d_workingNavGroup;

    public Floor(UnitDouble defWorkingZ) {
        this(null, defWorkingZ);
    }

    public Floor(String name, UnitDouble defWorkingZ) {
        super(name);
        this.d_defWorkingZ = defWorkingZ;
        this.d_workingNavGroup = this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block2: {
            block3: {
                in.defaultReadObject();
                if (!(in instanceof MerlinOIS)) break block2;
                if (!MerlinOIS.isBetween(in, MerlinIO.Version.VER_0009, MerlinIO.Version.VER_0012)) break block3;
                for (IEgressObj obj : this.d_workingNavGroup.getDeepMembers(IEgressObj.class)) {
                    obj.readTopology(in);
                }
                break block2;
            }
            if (!MerlinOIS.isSameOrLater(in, MerlinIO.Version.VER_0012)) break block2;
            for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
                obj.readTopology(in);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.writeTopology(out);
        }
    }

    public String getBaseName() {
        return this.getStoredName();
    }

    public void setWorkingGeomGroup(GeomComposite<IMerlinObj> group) {
        if (group == null) {
            group = this;
        }
        if (this.d_workingNavGroup == group) {
            return;
        }
        this.pauseUpdates();
        if (this.d_workingNavGroup == null) {
            assert (false) : "Working group must not be null";
        } else if (this.d_workingNavGroup != this) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.d_workingNavGroup = group;
        this.changedEvt(WORKING_GROUP);
        if (this.d_workingNavGroup != this) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.resumeUpdates();
    }

    public GeomComposite<IMerlinObj> getWorkingGeomGroup() {
        return this.d_workingNavGroup;
    }

    public UnitDouble getWorkingZ() {
        return this.d_defWorkingZ;
    }

    public void setWorkingZ(UnitDouble workingZ) {
        if (Objects.equals(this.d_defWorkingZ, workingZ)) {
            return;
        }
        this.d_defWorkingZ = workingZ;
        this.invalidateClippingRegion();
        this.changedEvt(WORKING_Z);
    }

    public UnitDouble[] getZFilter() {
        UnitDouble min = this.d_zminFilter == null ? CURR_FLOOR : this.d_zminFilter;
        UnitDouble max = this.d_zmaxFilter == null ? NEXT_FLOOR : this.d_zmaxFilter;
        return new UnitDouble[]{min, max};
    }

    public void setZFilter(UnitDouble zMin, UnitDouble zMax) {
        try (IDomainObject.EventPause paused = this.openPause();){
            UnitDouble max;
            UnitDouble min = zMin == CURR_FLOOR ? null : zMin;
            UnitDouble unitDouble = max = zMax == NEXT_FLOOR ? null : zMax;
            if (!Objects.equals(min, this.d_zminFilter)) {
                this.d_zminFilter = min;
                this.invalidateClippingRegion();
                this.changedEvt(ZMIN_FILTER);
            }
            if (!Objects.equals(max, this.d_zmaxFilter)) {
                this.d_zmaxFilter = max;
                this.invalidateClippingRegion();
                this.changedEvt(ZMAX_FILTER);
            }
        }
    }

    private void invalidateClippingRegion() {
        if (this.getDomain() != null) {
            ((MerlinData)this.getDomain()).floors.invalidateClippingRegions();
        }
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Floor clone() {
        return (Floor)super.clone();
    }

    public void repairBrokenFloors(FloorComposite topFloorNode) {
        ArrayDeque<Floor> brokenFloors = new ArrayDeque<Floor>(this.getDeepMembers(Floor.class));
        for (Floor f : brokenFloors) {
            System.out.println("Moving floor to Floors node: " + f.toString());
            Composite<Floor> parent = Composite.findParent(this, f);
            if (parent != null) {
                parent.remove(f);
                topFloorNode.add(f);
                continue;
            }
            throw new RuntimeException("Unable to repair floor grouping error.");
        }
    }

    @Override
    public String toString() {
        return String.format("Floor[name=\"%s\", z=%s]", this.getName(), this.d_defWorkingZ.toString());
    }
}

