/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.Objects;
import merlin.Intl;
import merlin.data.animation.AAnimationClip;
import merlin.data.property.DisplayProps;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;

public class MoveAnimationClip
extends AAnimationClip {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<UnitDouble> NATURAL_SPEED = DisplayProps.build((Object)-1880550362, UnitDouble.class, new UnitDouble(Double.POSITIVE_INFINITY, SI.METER.divide(SI.SECOND)), Intl.intl("Natural Speed"), Intl.intl("The natural movement speed of this animation.\nWhen the occupant is moving at this speed, the animation will be played back at 1x speed.\nIf the occupant is moving at twice this speed, the animation will be played back at 2x speed, etc.")).attrToProp();
    public static final DisplayProp<UnitDouble> TOP_SPEED = DisplayProps.build((Object)-1112093708, UnitDouble.class, new UnitDouble(0.0, SI.METER.divide(SI.SECOND)), Intl.intl("Top Speed"), Intl.intl("The maximum movement speed at which this animation will be used.")).attrToProp();
    private final UnitDouble d_naturalSpeed;
    private final UnitDouble d_topSpeed;

    public MoveAnimationClip(IPropertySet props) {
        super(props);
        this.d_naturalSpeed = props.get(NATURAL_SPEED);
        this.d_topSpeed = props.get(TOP_SPEED);
    }

    public static PropertySet getDefaults() {
        PropertySet defaults = AAnimationClip.getDefaults();
        defaults.setIfNotDefault(NATURAL_SPEED, new UnitDouble(0.0, SI.METER.divide(SI.SECOND)));
        return defaults;
    }

    @Override
    protected void getValues(PropertySet props) {
        props.setIfNotDefault(NATURAL_SPEED, this.d_naturalSpeed);
        props.setIfNotDefault(TOP_SPEED, this.d_topSpeed);
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MoveAnimationClip clip = (MoveAnimationClip)obj;
        return super.surrogateEquals(clip) && Objects.equals(this.d_naturalSpeed, clip.d_naturalSpeed) && Objects.equals(this.d_topSpeed, clip.d_topSpeed);
    }

    public UnitDouble getNaturalSpeed() {
        return this.d_naturalSpeed;
    }

    public UnitDouble getTopSpeed() {
        return this.d_topSpeed;
    }
}

