/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.AnimRetargetMode;
import merlin.data.animation.AnimType;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationTransform;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.IdlePlayback;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class JsonAnimationParser {
    static final Map<String, AnimType> NAME_TYPE_MAP = Arrays.stream(AnimType.values()).collect(Collectors.toMap(type -> type.jsonName, Function.identity()));
    static final Map<String, AnimDirection> NAME_DIR_MAP = Arrays.stream(AnimDirection.values()).collect(Collectors.toMap(dir -> dir.jsonName, Function.identity()));
    static final Map<String, IdlePlayback> NAME_IDLE_PLAYBACK_MAP = Arrays.stream(IdlePlayback.values()).collect(Collectors.toMap(type -> type.jsonName, Function.identity()));
    static final Map<String, AnimRetargetMode> NAME_RETARGET_MODE_MAP = Arrays.stream(AnimRetargetMode.values()).collect(Collectors.toMap(type -> type.jsonName, Function.identity()));

    public static Animation parseAnimationFile(File file) throws IOException {
        Animation animation;
        String name = FilenameManager.splitFilename(file.getName())[0];
        FileReader reader = new FileReader(file);
        try {
            animation = JsonAnimationParser.parseAnimationFile((JSONObject)new JSONParser().parse(reader), name);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        reader.close();
        return animation;
    }

    public static Animation parseAnimationFile(JSONObject jobj, String name) throws IOException {
        try {
            JSONArray anims = (JSONArray)jobj.get("anims");
            Animation anim = JsonAnimationParser.parseAnimation((JSONObject)anims.get(0), name);
            anim.setExtraFileProps(jobj);
            return anim;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Animation parseAnimation(JSONObject jobj, String name) throws IOException {
        Animation anim = new Animation();
        anim.setName(name);
        String uuidStr = jobj.getOrDefault("uuid", "");
        anim.setUuid(uuidStr.isEmpty() ? UUID.randomUUID() : UUID.fromString(uuidStr));
        anim.setType(JsonAnimationParser.parseAnimType(jobj.getOrDefault("type", AnimType.IDLE.toString()).toString()));
        anim.setTags(JsonAnimationParser.parseTags(jobj.getOrDefault("tags", new JSONArray())));
        switch (anim.getType()) {
            case IDLE: {
                anim.setIdleClip(JsonAnimationParser.parseIdleClip(jobj));
                break;
            }
            case MOVE: {
                anim.setDirections(JsonAnimationParser.parseDirections(jobj.getOrDefault("dir", new JSONArray())));
                anim.setMoveClips(JsonAnimationParser.parseMoveClips(jobj.getOrDefault("clips", new JSONArray())));
                anim.setExtraAnimProps(jobj);
                break;
            }
            case PIVOT: {
                anim.setDirections(JsonAnimationParser.parseDirections(jobj.getOrDefault("dir", new JSONArray())));
                anim.setPivotClips(JsonAnimationParser.parsePivotClips(jobj.getOrDefault("clips", new JSONArray())));
                anim.setExtraAnimProps(jobj);
            }
        }
        return anim;
    }

    private static AnimType parseAnimType(String typeKey) {
        return NAME_TYPE_MAP.get(typeKey);
    }

    private static Set<String> parseTags(JSONArray tags) {
        return new HashSet<String>(JsonUtil.getList(tags, obj -> (String)obj));
    }

    private static Set<AnimDirection> parseDirections(JSONArray direction) {
        HashSet<AnimDirection> directions = new HashSet<AnimDirection>();
        for (Object dir : direction) {
            directions.add(NAME_DIR_MAP.get((String)dir));
        }
        return directions;
    }

    private static IdleAnimationClip parseIdleClip(JSONObject jobj) {
        PropertySet values = IdleAnimationClip.getDefaults();
        JsonAnimationParser.parseBaseClip(values, jobj);
        values.set(IdleAnimationClip.IDLE_PLAYBACK, JsonAnimationParser.parseIdlePlayback(jobj.getOrDefault("idlePlayback", IdlePlayback.RANDOMIZE.jsonName).toString()));
        values.set(IdleAnimationClip.EXTRA_PROPS, jobj);
        return new IdleAnimationClip(values);
    }

    private static IdlePlayback parseIdlePlayback(String typeKey) {
        return NAME_IDLE_PLAYBACK_MAP.get(typeKey);
    }

    private static List<MoveAnimationClip> parseMoveClips(JSONArray clips) {
        return JsonUtil.getList(clips, clip -> JsonAnimationParser.parseMoveClip((JSONObject)clip));
    }

    private static MoveAnimationClip parseMoveClip(JSONObject jobj) {
        PropertySet values = MoveAnimationClip.getDefaults();
        JsonAnimationParser.parseBaseClip(values, jobj);
        values.set(MoveAnimationClip.NATURAL_SPEED, new UnitDouble(JsonUtil.getNum(jobj, "naturalSpeed", 1.0).doubleValue(), SI.METER.divide(SI.SECOND)));
        values.set(MoveAnimationClip.TOP_SPEED, new UnitDouble(JsonUtil.getNum(jobj, "maxSpeed", Double.POSITIVE_INFINITY).doubleValue(), SI.METER.divide(SI.SECOND)));
        values.set(MoveAnimationClip.EXTRA_PROPS, jobj);
        return new MoveAnimationClip(values);
    }

    private static List<PivotAnimationClip> parsePivotClips(JSONArray clips) {
        return JsonUtil.getList(clips, clip -> JsonAnimationParser.parsePivotClip((JSONObject)clip));
    }

    private static PivotAnimationClip parsePivotClip(JSONObject jobj) {
        PropertySet values = PivotAnimationClip.getDefaults();
        JsonAnimationParser.parseBaseClip(values, jobj);
        values.set(PivotAnimationClip.NATURAL_SPEED, new UnitDouble(JsonUtil.getNum(jobj, "naturalSpeed", 1.0).doubleValue(), SI.RADIAN.divide(SI.SECOND)));
        values.set(PivotAnimationClip.TOP_SPEED, new UnitDouble(JsonUtil.getNum(jobj, "maxSpeed", Double.POSITIVE_INFINITY).doubleValue(), SI.RADIAN.divide(SI.SECOND)));
        values.set(PivotAnimationClip.EXTRA_PROPS, jobj);
        return new PivotAnimationClip(values);
    }

    private static void parseBaseClip(PropertySet clip, JSONObject jobj) {
        String uuidStr = jobj.getOrDefault("uuid", "");
        clip.set(AAnimationClip.ID, uuidStr.isEmpty() ? UUID.randomUUID() : UUID.fromString(uuidStr));
        clip.set(AAnimationClip.FILE, jobj.getOrDefault("path", ""));
        clip.set(AAnimationClip.FRAME_OFFSET, new UnitDouble(JsonUtil.getNum(jobj, "frameOffset", 0.0).doubleValue(), Unit.ONE));
        clip.set(AAnimationClip.TRANSFORM, JsonAnimationParser.parseCombinedTransform(jobj.getOrDefault("transform", new JSONArray())));
        clip.set(AAnimationClip.RETARGET_MODE, JsonAnimationParser.parseRetargetMode(jobj.getOrDefault("retargetTo", AnimRetargetMode.NONE.jsonName).toString()));
        clip.set(AAnimationClip.RETARGET_SOURCE, jobj.getOrDefault("retargetSource", ""));
    }

    private static AnimRetargetMode parseRetargetMode(String key) {
        return NAME_RETARGET_MODE_MAP.get(key);
    }

    private static AnimationTransform parseCombinedTransform(JSONArray transforms) {
        double combinedScale = 1.0;
        Quat4d combinedRotation = new Quat4d(0.0, 0.0, 0.0, 1.0);
        Vector3d combinedTranslation = new Vector3d();
        for (Object obj : transforms) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject jobj = (JSONObject)obj;
            if (jobj.containsKey("scale")) {
                double scale = JsonUtil.getDouble(jobj, "scale");
                combinedScale *= scale;
            }
            if (jobj.containsKey("rotate")) {
                Vector4d rotation = JsonUtil.getVector4d(jobj, "rotate", false);
                double angle = Math.toRadians(rotation.w);
                double c = Math.cos(angle / 2.0);
                double s = Math.sin(angle / 2.0);
                Quat4d rotationQuat = new Quat4d(rotation.x * s, rotation.y * s, rotation.z * s, c);
                combinedRotation.mul(rotationQuat);
            }
            if (!jobj.containsKey("translate")) continue;
            Vector3d translate = JsonUtil.getVector3d(jobj, "translate", false);
            combinedTranslation.add(translate);
        }
        double norm = Math.sqrt(combinedRotation.x * combinedRotation.x + combinedRotation.y * combinedRotation.y + combinedRotation.z * combinedRotation.z);
        double angle = 2.0 * Math.atan2(norm, combinedRotation.w);
        Vector3d axis = new Vector3d();
        if (!theUtil.eq0(angle, 1.0E-6)) {
            double s = Math.sin(angle / 2.0);
            axis = new Vector3d(combinedRotation.x / s, combinedRotation.y / s, combinedRotation.z / s);
        }
        if (Util3D.isVecZero(axis)) {
            axis = new Vector3d(0.0, 0.0, 1.0);
        }
        return new AnimationTransform(new UnitDouble(combinedScale, Unit.ONE), new UnitDouble(angle, SI.RADIAN), axis, new UnitPoint3D(combinedTranslation, (Unit)SI.METER));
    }
}

