/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import merlin.Intl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class AnimationTransform
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UnitDouble d_scale;
    private final UnitDouble d_rotation;
    private final Vector3d d_rotAxis;
    private final UnitPoint3D d_translation;

    public AnimationTransform() {
        this.d_scale = new UnitDouble(1.0, Unit.ONE);
        this.d_rotation = new UnitDouble(0.0, SI.RADIAN);
        this.d_rotAxis = new Vector3d(0.0, 0.0, 1.0);
        this.d_translation = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    }

    public AnimationTransform(UnitDouble scale, UnitDouble rotation, Vector3d rotAxis, UnitPoint3D translation) {
        this.d_scale = scale;
        this.d_rotation = rotation;
        this.d_rotAxis = rotAxis;
        this.d_translation = translation;
    }

    public AnimationTransform(AnimationTransform xform) {
        this.d_translation = xform.d_translation;
        this.d_rotation = xform.d_rotation;
        this.d_rotAxis = xform.d_rotAxis;
        this.d_scale = xform.d_scale;
    }

    public UnitDouble getScale() {
        return this.d_scale;
    }

    public UnitDouble getRotation() {
        return this.d_rotation;
    }

    public Vector3d getRotationAxis() {
        return this.d_rotAxis;
    }

    public UnitPoint3D getTranslation() {
        return this.d_translation;
    }

    public boolean equals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        AnimationTransform xform = (AnimationTransform)comparable;
        return this.d_scale.equals(xform.d_scale) && this.d_rotation.equals(xform.d_rotation) && this.d_rotAxis.equals(xform.d_rotAxis) && this.d_translation.equals(xform.d_translation);
    }

    public String toString() {
        return Intl.intl("Animation Transform");
    }
}

