/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.actions.InfernoGeomBuilder;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.geom.Geometry;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class SimParams
extends AMerlinObj {
    static final long serialVersionUID = 8116442157363966490L;
    public static final PropertyDefs<SimParams> PROP_TYPES = PropertyDefs.defsRoot(SimParams.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }));
    public static final DisplayProp<Boolean> RUNTIME_MAX_FLAG = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.RUNTIME_MAX_FLAG", true, Intl.intl("Enable Time Limit"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> RUNTIME_MAX = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.RUNTIME_MAX", new UnitDouble(3600.0, SI.SECOND), Intl.intl("Time Limit"), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> SHOW_RUNTIME_VIS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.SHOW_RUNTIME_VIS", false, Intl.intl("Show Runtime Visualization"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<NavMeshRefinement> NAVMESH_REFINEMENT = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.NAVMESH_REFINEMENT", NavMeshRefinement.class, NavMeshRefinement.NONE, Intl.intl("Navigation Mesh Refinement"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.desc)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> MAX_EDGE_LENGTH = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MAX_EDGE_LENGTH", new UnitDouble(2.5, SI.METER), Intl.intl("Max Edge Length"), "", 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> MIN_ANGLE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MIN_ANGLE", new UnitDouble(0.0, NonSI.DEGREE_ANGLE), Intl.intl("Min Angle"), "", 7).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> MAX_TRIANGLE_AREA = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MAX_TRIANGLE_AREA", new UnitDouble(2.0, SI.METER.pow(2)), Intl.intl("Maximum Triangle Area"), "", 4).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_SIM = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_SIM", new UnitDouble(0.025, SI.SECOND), Intl.intl("Time Step Size"), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_VIS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_VIS", new UnitDouble(0.25, SI.SECOND), Intl.intl("3D Output Freq."), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_STATUS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_STATUS", new UnitDouble(0.5, SI.SECOND), Intl.intl("Runtime Output Freq."), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_CSV = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_CSV", new UnitDouble(1.0, SI.SECOND), Intl.intl("Data Output Freq."), Intl.intl("Controls how frequently (in sim time) output files are updated during the simulation."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_SNAPSHOT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_SNAPSHOT", new UnitDouble(120.0, SI.SECOND), Intl.intl("Snapshot Interval"), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DT_STEER_UPDATE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DT_STEER_UPDATE", new UnitDouble(0.1, SI.SECOND), Intl.intl("Steering update interval"), "", 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> HANDLE_COLLISIONS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.HANDLE_COLLISIONS", true, Intl.intl("Collision Handling"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> FORCE_SEPARATION = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.FORCE_SEPARATION", false, Intl.intl("Enable Forced Separation"), Intl.intl("Agents will always attempt to maintain personal distance (from profile) spacing.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> REACTIVE_STEERING = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.REACTIVE_STEERING", true, Intl.intl("Behavior Mode"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Steering") : Intl.intl("SFPE"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> USE_PROFILE_FUNDAMENTAL = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.USE_PROFILE_FUNDAMENTAL", false, Intl.intl("Speed-Density Profile"), Intl.intl("Controls density/speed relationship")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> USE_ADVANCED_PROFILE_SPEEDS = TypedProps.build("SimParams.USE_ADVANCED_PROFILE_SPEEDS", Boolean.class, false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Double> MIN_SFPE_VELOCITY_FRACTION = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MIN_SFPE_VELOCITY_FRACTION", 0.15, Intl.intl("Minimum Speed Fraction"), "<html>" + Intl.intl("Sets the minimum speed of occupants as a fraction of their maximum<br>speed for a given egress component.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    @Deprecated
    public static final TypedProp<Boolean> INERTIA = TypedProps.build("SimParams.INERTIA", Boolean.class, true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> USE_DOOR_QUEUES = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.USE_DOOR_QUEUES", false, Intl.intl("Limit Door Flow Rate"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> SPECIFIC_FLOW_STEERING = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.SPECIFIC_FLOW_STEERING", new UnitDouble(1.32, Unit.ONE.alternate("pers").divide(SI.SECOND).divide(SI.METER)), Intl.intl("Specific Flow"), "", 12).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DENSITY_MAX = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DENSITY_MAX", new UnitDouble(1.88, SIUS.unit(3)), Intl.intl("Max Room Density"), Intl.intl("Controls the maximum number of occupants that may occupy a room at a time, ignoring initial loads."), 3).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DOOR_BOUNDARY_LAYER = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DOOR_BOUNDARY_LAYER", new UnitDouble(150.0, SI.MILLI(SI.METER)), Intl.intl("Boundary Layer"), "", 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Double> MIN_FLOWRATE_FACTOR = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MIN_FLOWRATE_FACTOR", 0.1, Intl.intl("Minimum flowrate factor"), "<html>" + Intl.intl("Controls the minimum flowrate occupants will observe at doors.<br>Lower values will allow occupants to recognize low-flow doors<br>but may cause excessive queue-switching.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> DOOR_FLOW_DENSITY_FLAG = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DOOR_FLOW_DENSITY_FLAG", true, Intl.intl("Flow Rates at High Density"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Use a Calculated Specific Flow") : Intl.intl("Always Use Max Specific Flow"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    @Deprecated
    public static final TypedProp<Double> ELEVATOR_SIZE_FACTOR = TypedProps.build("SimParams.ELEVATOR_SIZE_FACTOR", Double.class, 0.6).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> MAX_TRIM_ERROR = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MAX_TRIM_ERROR", new UnitDouble(1.0, NonSI.INCH), Intl.intl("Max Agent Radius Trim Error"), "", 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> LOW_SPEED_THRESHOLD = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.LOW_SPEED_THRESHOLD", new UnitDouble(0.25, SI.METER.divide(SI.SECOND)), Intl.intl("Congestion Velocity"), "<html>" + Intl.intl("A velocity threshold for determining whether an occupant is experiencing congestion.<br>If their average velocity is less than this value, they are experiencing congestion."), 5).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> LOW_SPEED_AVERAGING_TIME = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.LOW_SPEED_AVERAGING_TIME", new UnitDouble(10.0, SI.SECOND), Intl.intl("Congestion Averaging Time"), "<html>" + Intl.intl("The trailing time period over which to average an occupant's velocity to determine<br>congestion."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> OCC_CSV_FILE_MERGE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.OCC_CSV_FILE_MERGE", true, Intl.intl("Detailed Occupant Data"), "<html>" + Intl.intl("If \"Output Detailed Data\" is turned on per-occupant, this<br>determines how to generate the resulting output files.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Merge into one file") : Intl.intl("Create one file per occupant"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> WRITE_JSON_FILES = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.WRITE_JSON_FILES", false, Intl.intl("Write JSON Output Files"), Intl.intl("Writes output files to an additional JSON format. Useful for accessing simulation data programmatically")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> WRITE_OCCUPANT_PARAMS_FILE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.WRITE_OCCUPANT_PARAMS_FILE", true, Intl.intl("Write Occupant Parameter File"), Intl.intl("Writes an output file containing resolved occupant profile parameters for each occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> WRITE_SOCIAL_DISTANCE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.WRITE_SOCIAL_DISTANCE", false, Intl.intl("Enable Interpersonal Distance Reporting"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> SOCIAL_DISTANCE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.SOCIAL_DISTANCE", new UnitDouble(2.0, SI.METER), Intl.intl("Reference Distance"), Intl.intl("Used to measure accumulated contact over time."), 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> MEASUREMENT_REGION_SEEK_SPEED = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.MEASUREMENT_REGION_SEEK_SPEED", true, Intl.intl("Include Seek Speed in Measurement Region Files"), Intl.intl("In measurement region output files, includes a column that indicates the occupant speed relative to seek direction.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Double> EDGE_ERROR = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.EDGE_ERROR", 0.1, Intl.intl("Curve error"), Intl.intl("Sets the amount of error when converting curved CAD lines to straight lines when generating model elements.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Double> FACE_ERROR = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.FACE_ERROR", 0.1, Intl.intl("Face error"), Intl.intl("Sets the amount of error when converting curved CAD faces to polygons when generating model elements.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> SMV_DATA_ENABLE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.SMV_DATA_ENABLE", false, Intl.intl("Enable FDS Integration"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    @Deprecated
    public static final TypedProp<Boolean> SMV_SMOKE_SLOW_ENABLE = TypedProps.build("SimParams.SMV_SMOKE_SLOW_ENABLE", Boolean.class, false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> SMV_DATA_FILE_NAME = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.SMV_DATA_FILE_NAME", String.class, null, Intl.intl("Smokeview File"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> HYPOXIA_LIMIT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.HYPOXIA_LIMIT", new UnitDouble(19.5, NonSI.PERCENT), Intl.intl("Hypoxia FED Threshold"), Intl.intl("The oxygen concentration at hypoxia contributes to FED."), 10).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS", false, Intl.intl("Enable visualized sideways movement of vehicles"), "<html>" + Intl.intl("Enables the visualization of vehicles moving sideways without changing the simulation.<br>NOTE: Sideways movement must still be enabled per vehicle shape.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> ATTRACTOR_DEFAULT_IDLE_TIME = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.ATTRACTOR_DEFAULT_IDLE_TIME", new UnitDouble(15.0, NonSI.MINUTE), Intl.intl("Default Trigger Idle Time"), "<html>" + Intl.intl("Used to determine when an occupant should use a trigger if they<br>do not know how long they will be waiting."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> OCC_TARGET_CONFLICT_RESOLVE_TIME = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME", new UnitDouble(5.0, SI.SECOND), Intl.intl("Occupant Target Resolve Time"), "<html>" + Intl.intl("The maximum amount of time an occupant can spend trying to reserve<br>an <b>Occupant Target</b> when there are conflicting requests for the<br>targets. This is used with the <b>Goto Occupant Target</b> behavior<br>action.<p>Lower values may increase the time to complete a simulation<br>but will allow occupants to reserve their targets in shorter simulation<br>time."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DYNAMIC_TARGET_SEARCH_DT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SimParams.DYNAMIC_TARGET_SEARCH_DT", new UnitDouble(0.25, SI.SECOND), Intl.intl("Goto Occupant Search Interval"), "<html>" + Intl.intl("For a <b>Goto Occupant</b> behavior action, if a destination occupant is not<br>found, this parameter defines the amount of simulation time until another<br>search is performed.<p>Lower values may increase the time to complete a simulation if there are<br>many potential destination occupants, but will allow occupants to respond<br>more quickly to changes in the model."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    static final CompositeProp BEHAVIOR_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(REACTIVE_STEERING, DOOR_FLOW_DENSITY_FLAG, DT_STEER_UPDATE, HANDLE_COLLISIONS, FORCE_SEPARATION, USE_DOOR_QUEUES, DOOR_BOUNDARY_LAYER, SPECIFIC_FLOW_STEERING, MIN_FLOWRATE_FACTOR, DENSITY_MAX, USE_PROFILE_FUNDAMENTAL, MIN_SFPE_VELOCITY_FRACTION).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    static final CompositeProp SOCIAL_DISTANCE_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(WRITE_SOCIAL_DISTANCE, SOCIAL_DISTANCE).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    static final CompositeProp NAVMESH_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(NAVMESH_REFINEMENT, MAX_TRIANGLE_AREA, MAX_EDGE_LENGTH, MIN_ANGLE).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    static final CompositeProp SMV_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(SMV_DATA_ENABLE, SMV_DATA_FILE_NAME, HYPOXIA_LIMIT).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    private PropertySet d_props = new PropertySet();

    public SimParams() {
        if (Application.getApp() != null && !MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_WRITE_SNAPSHOTS_BY_DEFAULT)) {
            this.set(DT_SNAPSHOT, new UnitDouble(0.0, SI.SECOND));
        }
    }

    public void reset() {
        this.restoreFrom(new SimParams());
    }

    public Face.RefinementOptions getFaceRefinementOptions() {
        switch (this.get(NAVMESH_REFINEMENT).ordinal()) {
            case 1: {
                return new Face.RefinementOptions(this.get(MIN_ANGLE).getRawValue());
            }
            case 2: {
                return new Face.RefinementOptions(this.get(MAX_TRIANGLE_AREA).get(Geometry.AREA_UNIT), 0);
            }
        }
        return Face.NO_REFINEMENT;
    }

    public InfernoGeomBuilder.Param getMeshBuilderParams() {
        Face.RefinementOptions refOptions = this.getFaceRefinementOptions();
        return new InfernoGeomBuilder.Param(switch (this.get(NAVMESH_REFINEMENT).ordinal()) {
            case 1 -> this.get(MAX_EDGE_LENGTH);
            case 2 -> {
                double area = this.get(MAX_TRIANGLE_AREA).get(Geometry.AREA_UNIT);
                double len = Math.sqrt(area) * 2.0 / 3.0 * Math.pow(3.0, 0.75);
                yield new UnitDouble(len, Geometry.LENGTH_UNIT);
            }
            default -> new UnitDouble(Double.MAX_VALUE, SI.METER);
        }, refOptions);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public String getName() {
        return Intl.intl("Simulation Parameters");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public static enum NavMeshRefinement {
        NONE(Intl.intl("None"), Intl.intl("None")),
        EDGE_LENGTH(Intl.intl("Edge Length"), Intl.intl("Constrain edge length")),
        TRIANGLE_AREA(Intl.intl("Triangle Area"), Intl.intl("Constrain triangle area"));

        public final String name;
        public final String desc;

        private NavMeshRefinement(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

