/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.SimParams;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.property.DisplayProps;
import merlin.data.property.Function1dProp;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.stat.AutoCurve;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.MerlinUDF;
import merlin.gui.ObjSources;
import merlin.gui.value.Function1dEditorFactory;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtSolidUtil;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class OccSourceObj
extends NamedMerlinObj
implements Cloneable,
IMerlinGeomSrc,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<OccSourceObj> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(OccSourceObj.class, PropertyDefs.serializedOnly(obj -> obj.d_values, obj -> {
        obj.d_values = new PropertySet();
    }), NamedMerlinObj.PROPS);
    public static final Unit FLOWRATE_UNIT = Unit.ONE.alternate("pers").divide(SI.SECOND);
    public static final Function1dProp PROP_FLOW_RATE = OccSourceObj.newFlowrateProp("OccSource.Flowrate", Intl.intl("Flow Rate"), Intl.intl("Modifies flow rate as a function of time."), new ConstFunction1d(new UnitDouble(1.0, FLOWRATE_UNIT)));
    public static final DisplayProp<IUrn<OccProfile>> PROP_PROFILE_DIST = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccSource.PROFILE_DIST", theUtil.makeGeneric(IUrn.class), new Urn<OccProfile>(new OccProfile[0]), Intl.intl("Profile"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(profiles -> profiles.format2(OccProfile::getName))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInUrn(prop, DLink.WEAK, OccProfile.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().objUrn(md -> ObjSources.getProfiles(md, null, false))).attrFinish();
    public static final DisplayProp<IUrn<Behavior>> PROP_BEHAVIOR_DIST = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccSource.BEHAVIOR_DIST", theUtil.makeGeneric(IUrn.class), new Urn<Behavior>(new Behavior[0]), Intl.intl("Behavior"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(behaviors -> behaviors.format2(NamedMerlinObj::getName))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInUrn(prop, DLink.WEAK, Behavior.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().objUrn(md -> ObjSources.getBehaviors(md, null, false))).attrFinish();
    public static final DisplayProp<IUrn<OccGroupTypeObj>> PROP_GROUP_TEMPLATE_DIST = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccSource.GROUP_TEMPLATE_DIST", theUtil.makeGeneric(IUrn.class), new Urn<OccGroupTypeObj>(new OccGroupTypeObj[0]), Intl.intl("Movement Group Template"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(groups -> groups.format2(NamedMerlinObj::getName))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInUrn(prop, DLink.WEAK, OccGroupTypeObj.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().objUrn(md -> ObjSources.getGroupTypes(md, null, true))).attrFinish();
    public static final ProfileProps.UnaryProp<IUrn<Boolean>> PROP_ENFORCE_FLOWRATE = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccSource.ENFORCE_FLOWRATE", OccProfile.urnType(Boolean.class), new Urn<Boolean>(false), Intl.intl("Enforce Flow Rate"), Intl.intl("If enabled, occupants will be created even if there is not enough free space.")).attrFormatValue(DisplayProps.formatUrnYesNo())).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final ProfileProps.UnaryProp<List<Point3d>> PROP_SPAWN_LOCS = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccSource.SPAWN_LOCS", theUtil.makeGeneric(List.class), Collections.emptyList(), Intl.intl("Occupant Locations"), Intl.intl("The locations of occupants generated by the source.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValueWithToString()).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final ProfileProps.UnaryProp<IUrn<Boolean>> PROP_EMIT_AT_MAX_VEL = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccSource.EMIT_AT_MAX_VEL", OccProfile.urnType(Boolean.class), new Urn<Boolean>(true), Intl.intl("Emit at Max. Velocity"), "<html>" + Intl.intl("Whether occupants should be travelling at their maximum speed in the direction<br>of their initial orientation when added to the simulation.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(DisplayProps.formatUrnYesNo())).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final ProfileProps.UnaryProp<IEgressComp> PROP_COMPONENT = ((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccSource.COMPONENT", IEgressComp.class, null, Intl.intl("Component"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrUndoPropRestoreAll().attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, IEgressComp.class, OccSourceObj.occsAllowedFilter())).attrSetter((prop, obj, val) -> {
        assert (val == null || val instanceof IEgressOccupiable || val instanceof EgressDoor);
        obj.setToPropertySet(prop, val);
    }, null).attrFireEvents((prop, obj) -> obj.changedEvt(prop, MerlinData.SELECTION_CHANGED)).attrFinish();
    public static final DisplayProp<Boolean> PROP_ENABLED = PROP_TYPES.storeAsPlainOldData(MerlinData.ENABLED).attrUndoPropRestoreAll().attrFireEvents((prop, obj) -> obj.changedEvt(prop, EventChannel.EVT_GENERAL)).attrFinish();
    public static final DisplayProp<Set<Tag>> PROP_TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrFinish();
    static final TypedProp<Boolean> PROP_STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"OccSourceObj.PROP_STORED_VISIBILITY", true).attrAddMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> PROP_VISIBILITY = PROP_TYPES.storeAsWrapper(MerlinData.VISIBILITY).attrSetter((obj, val) -> obj.set(PROP_STORED_VISIBILITY, val), null).attrGetter(obj -> obj.get(PROP_STORED_VISIBILITY) != false && obj.get(PROP_ENABLED) != false, Stream.of(PROP_STORED_VISIBILITY, PROP_ENABLED)).attrUndoPropRestore(false, PROP_STORED_VISIBILITY).attrFinish();
    static final TypedProp<OccSourceType> PROP_TYPE = TypedProps.build("OccSourceObj.PROP_TYPE", OccSourceType.class, OccSourceType.REGION).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    static final TypedProp<AABox> PROP_GEOM = TypedProps.build("OccSourceObj.PROP_GEOM", AABox.class, new AABox()).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Long> PROP_SEED = PROP_TYPES.storeAsPlainOldData(MerlinData.SEED).attrFinish();
    public static final EgressAgent.AgentProfProp<UnitDouble, ICurve, ProfileProps.DistProp<UnitDouble, ICurve>> PROP_INIT_ORIENT = PROP_TYPES.storeAsPlainOldData(EgressAgent.asAgentProfProp(OccProfile.PROP_INIT_ORIENT)).attrGetter((prop, obj) -> obj.getProfValue((EgressAgent.AgentProfProp)prop), Stream.empty()).attrSetter((aprop, obj, aval) -> obj.setProfValue((EgressAgent.AgentProfProp)aprop, (EgressAgent.AgentValue)aval), null).attrFinish();
    private PropertySet d_values;
    @Deprecated
    private boolean d_visible = true;
    @Deprecated
    private boolean d_enabled = true;
    @Deprecated
    private OccSourceType type;
    @Deprecated
    private AABox d_box;
    @Deprecated
    private Map<Object, Object> d_data;

    private <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> void setProfValue(EgressAgent.AgentProfProp<OccT, ProfT, PropT> aprop, EgressAgent.AgentValue<ProfT> aval) {
        boolean modified;
        if (!aval.isLocal()) {
            if (this.d_values.isDefined(aprop.baseProp.asProp())) {
                this.d_values.remove(aprop.baseProp.asProp());
                this.changedEvt(aprop);
            }
            return;
        }
        boolean bl = modified = !this.d_values.isDefined(aprop.baseProp.asProp()) || !Objects.equals(this.d_values.get(aprop.baseProp.asProp()), aval.value());
        if (modified) {
            this.d_values.set(aprop.baseProp.asProp(), aval.value());
            this.changedEvt(aprop);
        }
    }

    private <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> EgressAgent.AgentValue<ProfT> getProfValue(EgressAgent.AgentProfProp<OccT, ProfT, PropT> aprop) {
        boolean local = this.d_values.isDefined(aprop.baseProp.asProp());
        Object val = local ? this.d_values.get(aprop.baseProp.asProp()) : aprop.baseProp.asProp().defVal;
        return new EgressAgent.AgentValue<Object>(local, val);
    }

    public static final Predicate<IEgressComp> occsAllowedFilter() {
        return r -> {
            IEgressOccupiable room;
            return r instanceof EgressDoor || r instanceof IEgressOccupiable && (room = (IEgressOccupiable)r).getOccupantsAllowed() && !(room instanceof ElevatorRoom);
        };
    }

    public OccSourceObj(String name, AABox box) {
        super(name);
        this.init();
        this.set(PROP_GEOM, new AABox(box));
        this.set(PROP_TYPE, OccSourceType.REGION);
    }

    public OccSourceObj(String name, IEgressComp component) {
        super(name);
        this.init();
        this.set(PROP_TYPE, OccSourceType.EGRESS_COMPONENT);
        this.set(PROP_COMPONENT, component);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        this.type = OccSourceType.REGION;
        in.defaultReadObject();
        if (this.d_data != null) {
            this.d_values = new PropertySet(this.d_data);
            this.d_data = null;
            this.set(PROP_TYPE, this.type);
            this.type = null;
            this.set(PROP_GEOM, this.d_box);
            this.d_box = null;
            this.set(PROP_STORED_VISIBILITY, this.d_visible);
            this.d_visible = false;
            this.set(PROP_ENABLED, this.d_enabled);
            this.d_enabled = false;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0154)) {
            this.set(PROP_EMIT_AT_MAX_VEL, new Urn<Boolean>(false));
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0155)) {
            this.set(PROP_SEED, MerlinOIS.nextPre155OccSourceSeed(in));
        }
    }

    public boolean isGrouped(MerlinData md) {
        return this.get(PROP_GROUP_TEMPLATE_DIST).stream().anyMatch(gt -> gt != md.occGroupTypes.NO_GROUP_TYPE);
    }

    public void init() {
        this.d_values = new PropertySet();
        this.set(PROP_SEED, MerlinUtil.newSeed());
        this.set(PROP_INIT_ORIENT, new EgressAgent.AgentValue<AutoCurve>(true, new AutoCurve(SI.RADIAN)));
    }

    public long getSeed() {
        return this.get(PROP_SEED);
    }

    @Override
    public OccSourceObj clone() {
        return (OccSourceObj)super.clone();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public <OccT, ProfT> boolean isOccProfilePropOverridden(IProfileProp<OccT, ProfT> prop) {
        return OccSourceObj.isOccProfilePropSupported(prop) && ((EgressAgent.AgentValue)this.get(EgressAgent.asAgentProfProp(prop))).isLocal();
    }

    public <OccT, ProfT> ProfT getProfileValue(IProfileProp<OccT, ProfT> prop) {
        assert (this.isOccProfilePropOverridden(prop));
        return (ProfT)((EgressAgent.AgentValue)this.get(EgressAgent.asAgentProfProp(prop))).value();
    }

    public static <OccT, ProfT> boolean isOccProfilePropSupported(IProfileProp<OccT, ProfT> prop) {
        return PROP_TYPES.contains(EgressAgent.asAgentProfProp(prop));
    }

    public boolean isEnabled() {
        return this.get(PROP_ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.set(PROP_ENABLED, enabled);
    }

    @Override
    public final void setVisible(boolean visible) {
        this.set(PROP_VISIBILITY, visible);
    }

    @Override
    public final boolean isVisible() {
        return this.get(PROP_VISIBILITY);
    }

    public ModelRep getModel() {
        IEgressComp iEgressComp;
        if (this.getComponent() == null) {
            NmtSolidUtil.BoxResult result = NmtSolidUtil.fromBox(this.getBounds());
            if (result == null) {
                return null;
            }
            return new ModelRep(result.rep(), result.solid());
        }
        if (this.getComponent() != null && (iEgressComp = this.getComponent()) instanceof EgressRoom) {
            EgressRoom room = (EgressRoom)iEgressComp;
            return new ModelRep(room.getModel(), false);
        }
        iEgressComp = this.getComponent();
        if (iEgressComp instanceof EgressDoor) {
            EgressDoor door = (EgressDoor)iEgressComp;
            return new ModelRep(door.getDoorGeom().asModel(), false);
        }
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        switch (this.get(PROP_TYPE).ordinal()) {
            case 0: {
                PropsBuilder gprops = new PropsBuilder();
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                Color translucentGreen = new Color(0, 255, 0, 120);
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                gprops.add(new IPrimProps.Face(translucentGreen, null, 0));
                AABoxGeom geom = this.getRegionAreaGeom();
                Point3d min = geom.min;
                Point3d max = geom.max;
                Point3d p1 = geom.min;
                Point3d p2 = new Point3d(max.x, min.y, min.z);
                Point3d p3 = new Point3d(max.x, max.y, min.z);
                Point3d p4 = new Point3d(min.x, max.y, min.z);
                Point3d p5 = new Point3d(min.x, min.y, max.z);
                Point3d p6 = new Point3d(max.x, min.y, max.z);
                Point3d p7 = geom.max;
                Point3d p8 = new Point3d(min.x, max.y, max.z);
                ArrayList<LineSeg> lss = new ArrayList<LineSeg>();
                lss.add(new LineSeg(p1, p2));
                lss.add(new LineSeg(p2, p3));
                lss.add(new LineSeg(p3, p4));
                lss.add(new LineSeg(p4, p1));
                lss.add(new LineSeg(p1, p5));
                lss.add(new LineSeg(p2, p6));
                lss.add(new LineSeg(p3, p7));
                lss.add(new LineSeg(p4, p8));
                lss.add(new LineSeg(p5, p6));
                lss.add(new LineSeg(p6, p7));
                lss.add(new LineSeg(p7, p8));
                lss.add(new LineSeg(p8, p5));
                ArrayList<IManipulatable> geoms = new ArrayList<IManipulatable>();
                geoms.addAll(lss);
                geoms.add(geom);
                IGeom result = GeomUtil.group(geoms);
                return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(result), gprops);
            }
            case 1: {
                return DisplayGeom.EMPTY;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof AABoxGeom)) {
            return;
        }
        Point3d min = ((AABoxGeom)geom).min;
        Point3d max = ((AABoxGeom)geom).max;
        this.set(PROP_GEOM, new AABox(min, max));
    }

    @Override
    public IGeomNode getGeom() {
        switch (this.get(PROP_TYPE).ordinal()) {
            case 0: {
                return GeomNodeUtil.newNode(this.getRegionAreaGeom());
            }
            case 1: {
                if (Objects.equals(this.get(PROP_COMPONENT), null)) {
                    return DisplayGeom.EMPTY.node;
                }
                return this.getComponent().getGeom();
            }
        }
        assert (false);
        return null;
    }

    private AABoxGeom getRegionAreaGeom() {
        return new AABoxGeom(this.get(PROP_GEOM));
    }

    private static Function1dProp newFlowrateProp(String name, String desc, String longDesc, IFunction1d defVal) {
        Function<Component, IFunction1d> f = comp -> OccSourceObj.newStepFunctionDialog(comp);
        Function1dProp.PredefFunction[] predefs = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("Step Function"), Intl.intl("Step Function"), f)};
        int persPerSecType = UnitSystem.getType(Unit.ONE.alternate("pers").divide(SI.SECOND));
        Function1dProp prop = new Function1dProp((Object)name, "", defVal, desc, longDesc, desc, new Function1dProp.Integration(Intl.intl("Total Occupants:"), md -> md.simParams.get(SimParams.RUNTIME_MAX)), new Function1dProp.Var(Intl.intl("Time"), Intl.intl("Duration"), 1, UnitDoubleVR.above(SIUS.newud(0.0, 1), true)), new Function1dProp.Var(Intl.intl("Flow Rate"), persPerSecType, UnitDoubleVR.above(SIUS.newud(0.0, persPerSecType), true)), new UnitDouble[]{SIUS.newud(0.0, 1), SIUS.newud(0.0, 9), null, null}, Function1dEditorFactory.OCC_FLOWRATE_TYPES, Set.of(MerlinData.SCENARIO_MARKER), predefs);
        return PROP_TYPES.storeAsPlainOldData(prop).attrFinish();
    }

    @Deprecated
    public <T> T removeLegacyValue(TypedProp<T> prop) {
        T result = this.d_values.get(prop);
        this.d_values.remove(prop);
        return result;
    }

    public UnitDouble getMaxWidth() {
        UnitDouble maxWidth = null;
        IUrn<OccProfile> propUrn = this.get(PROP_PROFILE_DIST);
        Iterator<OccProfile> iterator = propUrn.getWeights().keySet().iterator();
        while (iterator.hasNext()) {
            OccProfile o;
            OccProfile prof = o = iterator.next();
            OccProfile.OccShape shape = (OccProfile.OccShape)prof.get(OccProfile.PROP_SHAPE);
            UnitDouble shapeWidth = shape.getWidth();
            if (maxWidth != null && shapeWidth.compareTo(maxWidth) <= 0) continue;
            maxWidth = shapeWidth;
        }
        return maxWidth;
    }

    private static IFunction1d newStepFunctionDialog(Component comp) {
        if (comp == null) {
            return null;
        }
        Window parent = SwingUtilities.getWindowAncestor(comp);
        FlowrateStepFunctionDialog dlg = new FlowrateStepFunctionDialog(parent, Intl.intl("Create Step Function"), 9);
        IFunction1d function = null;
        if (dlg.doModal() == 1) {
            dlg.validateData(true, false);
            function = dlg.createStepFunction();
        }
        return function;
    }

    public IEgressComp getComponent() {
        return this.get(PROP_COMPONENT);
    }

    public OccSourceType getType() {
        return this.get(PROP_TYPE);
    }

    public Set<OccProfile> getAllProfiles() {
        return this.get(PROP_PROFILE_DIST).getUnique(LinkedHashSet.class);
    }

    public Set<Behavior> getAllBehaviors() {
        return this.get(PROP_BEHAVIOR_DIST).getUnique(LinkedHashSet.class);
    }

    public Set<OccGroupTypeObj> getAllGroupTemplates() {
        return this.get(PROP_GROUP_TEMPLATE_DIST).getUnique(LinkedHashSet.class);
    }

    public static enum OccSourceType {
        REGION,
        EGRESS_COMPONENT;

    }

    public record ModelRep(Model rep, boolean isSolid) {
    }

    private static class FlowrateStepFunctionDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private MerlinUDF flowrateField;
        private MerlinUDF delayField;
        private MerlinUDF onField;
        private MerlinUDF offField;
        private guiIntField countField;

        public FlowrateStepFunctionDialog(Window parent, String name, int options) {
            super(parent, name, options);
            guiPanel panel = new guiPanel();
            GridBagHelper gb = new GridBagHelper(panel);
            this.flowrateField = new MerlinUDF(1.0, DoubleVR.above(0.0, true), FLOWRATE_UNIT);
            this.onField = new MerlinUDF(10.0, DoubleVR.above(0.0, false), SI.SECOND);
            this.delayField = new MerlinUDF(0.0, DoubleVR.above(0.0, true), SI.SECOND);
            this.offField = new MerlinUDF(20.0, DoubleVR.above(0.0, true), SI.SECOND);
            this.countField = new guiIntField(10, IntVR.above(0, false));
            gb.addRow(Intl.intl("Flow Rate:"), this.flowrateField);
            gb.addRow(Intl.intl("Initial Delay:"), this.delayField);
            gb.addRow(Intl.intl("On Duration:"), this.onField);
            gb.addRow(Intl.intl("Off Duration:"), this.offField);
            gb.addRow(Intl.intl("Number of Cycles:"), this.countField);
            gb.finalizeRows();
            this.setDialogComponent(panel);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        public IFunction1d createStepFunction() {
            double initialDelay = ((UnitDouble)this.delayField.getValue()).get(SI.SECOND);
            double onDuration = ((UnitDouble)this.onField.getValue()).get(SI.SECOND);
            double offDuration = ((UnitDouble)this.offField.getValue()).get(SI.SECOND);
            double periodLength = onDuration + offDuration;
            int numberOfPeriods = (Integer)this.countField.getValue();
            UnitDouble flowrate = (UnitDouble)this.flowrateField.getValue();
            ArrayList<RandomizedImpulseFunction1d.Interval> intervals = new ArrayList<RandomizedImpulseFunction1d.Interval>();
            TriFunction<Double, UnitDouble, Double, Double> hcycle = (t, fr, duration) -> {
                intervals.add(new RandomizedImpulseFunction1d.Interval(new UnitDouble((double)t, SI.SECOND), new UnitDouble((double)duration, SI.SECOND), (UnitDouble)fr));
                return t + duration;
            };
            BiFunction<Double, Double, Double> on = (t, duration) -> (Double)hcycle.apply((Double)t, flowrate, (Double)duration);
            BiFunction<Double, Double, Double> off = (t, duration) -> t + duration;
            double t2 = 0.0;
            if (initialDelay > 0.0) {
                t2 = off.apply(0.0, initialDelay);
            }
            if (theUtil.eq(onDuration, periodLength, 0.0)) {
                t2 = on.apply(t2, (double)numberOfPeriods * onDuration);
            } else {
                for (int perNum = 0; perNum < numberOfPeriods - 1; ++perNum) {
                    t2 = initialDelay + (double)perNum * periodLength;
                    t2 = on.apply(t2, onDuration);
                    t2 = off.apply(t2, offDuration);
                }
                t2 = initialDelay + (double)(numberOfPeriods - 1) * periodLength;
                t2 = on.apply(t2, onDuration);
            }
            intervals.trimToSize();
            return new RandomizedImpulseFunction1d(RandomizedImpulseFunction1d.Distribution.UNIFORM, intervals);
        }
    }

    public static class OccSourceComp
    extends Composite<OccSourceObj> {
        static final long serialVersionUID = 1834487306479339241L;

        public OccSourceComp() {
            this(Intl.intl("Occupant Sources"));
        }

        public OccSourceComp(String name) {
            super(name);
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccSourceComp(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Occupant Source Group");
        }
    }
}

