/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class OccGroupObj
extends GeomComposite<Proxy<EgressAgent>>
implements Serializable,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<OccGroupObj> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(OccGroupObj.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), GeomComposite.PROP_TYPES);
    protected static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    protected static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    public static final DisplayProp<String> PROP_DESC = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.DESC", "", Intl.intl("Description"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> PROP_REQUIRES_GROUP_LEADER = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.REQUIRES_GROUP_LEADER", false, Intl.intl("Follow Leader"), Intl.intl("Whether the group should follow a leader.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();
    public static final DisplayProp<EgressAgent> PROP_GROUP_LEADER = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.GROUP_LEADER", EgressAgent.class, null, Intl.intl("Leader"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v != null ? v.getName() : Intl.intl("[none]"))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyGeneric(prop, DLink.WEAK, Proxy.class, null, (md, src, agent) -> md.proxies.getProxies((IMerlinObj)agent).stream().filter(proxy -> proxy.getParent() == src).map(p -> p), (md, src) -> proxy -> proxy.getParent() == src, (md, src, val, old, repl) -> repl != null ? (EgressAgent)repl.getObj() : null)).attrComparisonEditor(PropComparisons.factory().singleObj(md -> ObjSources.getEgressAgents(md, Intl.intl("[none]")))).attrFinish();
    public static final DisplayProp<UnitDouble> PROP_MAX_DISTANCE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.MAX_DISTANCE", new UnitDouble(2.0, SI.METER), Intl.intl("Maximum Distance"), "<html>" + Intl.intl("Maximum distance from any group member to the closest other group member.<br>Enforcing social distancing in the group will cause this value to be <br>expanded by the maximum social distance of the group members."), 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> PROP_SLOWDOWN_TIME = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.SLOWDOWN_TIME", new UnitDouble(3.0, SI.SECOND), Intl.intl("Slowdown Time"), Intl.intl("Time interval during which the group will keep slowing down after it is disconnected."), 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(1)).attrFinish();
    public static final DisplayProp<Boolean> PROP_SOCIAL_DIST_IN_GROUP = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.SOCIAL_DIST_IN_GROUP", false, Intl.intl("Enforce social distancing between group members"), "<html>" + Intl.intl("Whether an occupant in the group should try to separate with other<br>group members if the <b>Social Distance</b> property is enabled<br>in the occupant's profile. Enabling this option expands the group's<br><b>Maximum Distance</b> to include the maximum social distance of<br>the group members.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();
    public static final DisplayProp<Color> PROP_COLOR = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.COLOR", Color.class, Color.BLUE, Intl.intl("Movement Group Color"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(group -> group.get(PROP_COLOR), PROP_COLOR).attrFinish();
    public static final DisplayProp<Color> PROP_TEMPLATE_COLOR = (DisplayProp)DisplayProps.build((Object)"OccGroupObj.TEMPLATE_COLOR", Color.class, Color.BLUE, Intl.intl("Color"), "").attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(null).attrFinish();
    static final CompositeProp LEADER_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(PROP_REQUIRES_GROUP_LEADER, PROP_GROUP_LEADER).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    public static final DisplayProp<Set<Tag>> PROP_TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    private PropertySet d_props = new PropertySet();
    private static final Predicate<IMerlinObj> s_filter = new APredicate<IMerlinObj>(){
        private static final long serialVersionUID = 7382663705197223905L;

        @Override
        public boolean test(IMerlinObj t) {
            if (!(t instanceof Proxy)) {
                return false;
            }
            Proxy p = (Proxy)t;
            Object obj = p.getObj();
            return obj instanceof EgressAgent;
        }
    };

    public OccGroupObj() {
        super("OccGroupObj");
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        Object PROP_NAME = TypedProps.build((Object)"OccGroupObj.NAME", "").attrToProp();
        if (this.d_props.isDefined(PROP_NAME)) {
            this.setName((String)this.d_props.get(PROP_NAME));
            this.d_props.remove(PROP_NAME);
        }
    }

    public void setRandomColor() {
        this.set(PROP_COLOR, MerlinUtil.newRandomOccColor());
    }

    public void setColor(Color color) {
        if (color != null) {
            this.set(PROP_COLOR, color);
        } else {
            this.setRandomColor();
        }
    }

    public void setTemplateColor(Color color) {
        this.set(PROP_TEMPLATE_COLOR, color);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    public static OccGroupObj newGroup(String name, Collection<EgressAgent> agents, Color templateColor, Color color) {
        OccGroupObj newGroup = new OccGroupObj();
        newGroup.setName(name);
        for (EgressAgent a : agents) {
            newGroup.add(new Proxy<EgressAgent>(a));
        }
        newGroup.setColor(color);
        newGroup.setTemplateColor(templateColor);
        return newGroup;
    }

    public void loadTemplate(OccGroupTypeObj groupTemplate, List<EgressAgent> members) {
        this.set(PROP_MAX_DISTANCE, groupTemplate.get(PROP_MAX_DISTANCE));
        this.set(PROP_SLOWDOWN_TIME, groupTemplate.get(PROP_SLOWDOWN_TIME));
        this.set(PROP_SOCIAL_DIST_IN_GROUP, groupTemplate.get(PROP_SOCIAL_DIST_IN_GROUP));
        boolean requiresLeader = groupTemplate.get(PROP_REQUIRES_GROUP_LEADER);
        this.set(PROP_REQUIRES_GROUP_LEADER, requiresLeader);
        if (requiresLeader) {
            OccProfile leaderProfile = groupTemplate.get(OccGroupTypeObj.PROP_LEADER_PROFILE);
            if (leaderProfile == null) {
                this.set(PROP_GROUP_LEADER, members.get(0));
            } else {
                for (EgressAgent a : members) {
                    if (a.getProfile().getProfParent() != leaderProfile) continue;
                    this.set(PROP_GROUP_LEADER, a);
                    break;
                }
            }
            assert (this.get(PROP_GROUP_LEADER) != null) : "Failed to assign a group leader";
        }
    }

    public static class OccGroupComp
    extends Composite<OccGroupObj>
    implements Serializable {
        static final long serialVersionUID = 3553758720985786240L;
        private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(OccGroupObj.class, OccGroupComp.class);

        public OccGroupComp() {
            this(Intl.intl("Movement Groups"));
        }

        public OccGroupComp(String name) {
            super(name);
        }

        @Override
        public Predicate<IMerlinObj> getFilter() {
            return s_filter;
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccGroupComp(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Movement Group Group");
        }
    }
}

