/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class ObjsFilter<T>
implements Serializable,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER = Logger.getLogger(ObjsFilter.class.getSimpleName());
    public final Mode mode;
    public final boolean rejected;
    public final Set<T> objects;

    public ObjsFilter(Mode mode, boolean rejected, Set<T> attractors) {
        this.mode = mode;
        this.rejected = rejected;
        this.objects = attractors;
    }

    public static <T> ObjsFilter<T> rejectAll() {
        return new ObjsFilter(Mode.NONE, true, Collections.emptySet());
    }

    public static <T> ObjsFilter<T> rejectAll(T unused) {
        return ObjsFilter.rejectAll();
    }

    public static <T> ObjsFilter<T> rejectAll(Class<T> unused) {
        return ObjsFilter.rejectAll();
    }

    public static <T> ObjsFilter<T> acceptAll() {
        return new ObjsFilter(Mode.ALL, true, Collections.emptySet());
    }

    public static <T> ObjsFilter<T> acceptAll(T unused) {
        return ObjsFilter.acceptAll();
    }

    public static <T> ObjsFilter<T> acceptAll(Class<T> unused) {
        return ObjsFilter.acceptAll();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjsFilter ar = (ObjsFilter)obj;
        return ar.mode == this.mode && ar.rejected == this.rejected && ar.objects.equals(this.objects);
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjsFilter ar = (ObjsFilter)obj;
        return ar.mode == this.mode && ar.rejected == this.rejected && theUtil.surrogateSetsEqual(ar.objects, this.objects, comparedSet);
    }

    public int hashCode() {
        return 0x9AF73832 ^ Objects.hash(new Object[]{this.mode, this.rejected, this.objects});
    }

    public Predicate<T> getFilter() {
        return this.mode.getFilter.apply(this);
    }

    public boolean test(T obj) {
        return this.mode.getFilter.apply(this).test(obj);
    }

    public static <SrcT extends IMerlinObj, RefT extends IMerlinObj> DepCallback<MerlinData, SrcT, ObjsFilter<RefT>, RefT> newDepCallback(TypedProp<ObjsFilter<RefT>> prop, Class<RefT> refType) {
        return new DepCallback<MerlinData, IMerlinObj, ObjsFilter, IMerlinObj>(DLink.WEAK, refType, (md, src, val) -> val.objects.stream(), Predicates.alwaysTrue(), new DepCallback.ReplaceDep<MerlinData, IMerlinObj, ObjsFilter, IMerlinObj>((md, src) -> src.getWithDetails(prop).orElse(null), (md, src, ref) -> Undo.insertUndoEntry_propRestore(md, src, prop), (md, src, val) -> {
            if (val != null) {
                src.set(prop, val);
            }
        }, (md, src, filter, old, replacement) -> {
            if (filter == null) {
                assert (false) : "Unexpected null ObjsFilter.";
                return null;
            }
            if (!filter.objects.contains(old)) {
                return filter;
            }
            Set<Object> objects = new LinkedIdentityHashSet(filter.objects);
            objects.remove(old);
            if (replacement != null) {
                objects.add(replacement);
            }
            Mode mode = filter.mode;
            if (objects.size() == 1) {
                objects = Collections.singleton((IMerlinObj)objects.iterator().next());
            } else if (objects.isEmpty()) {
                objects = Collections.emptySet();
                mode = filter.rejected ? Mode.ALL : Mode.NONE;
            }
            return new ObjsFilter(mode, filter.rejected, objects);
        }));
    }

    public String format(int maxLen) {
        return this.mode.format.apply(this, maxLen);
    }

    public String toString() {
        return this.format(Integer.MAX_VALUE);
    }

    public <T2> ObjsFilter<T2> mapTo(Function<T, T2> mapper) {
        Set mappedObjs = this.objects.stream().map(mapper).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
        return new ObjsFilter<T>(this.mode, this.rejected, mappedObjs);
    }

    public static enum Mode {
        ALL(Intl.intl("Accept All"), Intl.intl("Allow all to be used."), ar -> Filters.acceptAll()),
        NONE(Intl.intl("Reject All"), Intl.intl("Allow none to be used."), ar -> Filters.rejectAll()),
        FROM_LIST(Intl.intl("From List..."), Intl.intl("Choose allowed objects from a list."), ar -> ar.rejected ? Filters.reject(ar.objects) : Filters.accept(ar.objects), (ar, maxLen) -> ar.rejected ? String.format(Intl.intl("Reject: %s"), Mode.formatObjNames(ar.objects, maxLen, Intl.intl("None"))) : String.format(Intl.intl("Accept: %s"), Mode.formatObjNames(ar.objects, maxLen, Intl.intl("None"))));

        public final String name;
        public final String desc;
        public final Function<ObjsFilter, Predicate> getFilter;
        public final BiFunction<ObjsFilter, Integer, String> format;

        private <T> Mode(String name, String desc, Function<ObjsFilter<T>, Predicate<T>> getFilter) {
            this(name, desc, getFilter, (ar, maxLen) -> name);
        }

        private <T> Mode(String name, String desc, Function<ObjsFilter<T>, Predicate<T>> getFilter, BiFunction<ObjsFilter<T>, Integer, String> format) {
            this.name = name;
            this.desc = desc;
            this.getFilter = getFilter;
            this.format = format;
        }

        private static <T> String formatObjNames(Set<T> objs, int maxLen, String emptyName) {
            if (objs.isEmpty()) {
                return emptyName;
            }
            StringBuilder sb = new StringBuilder();
            for (T obj : objs) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(MerlinUtil.getName(obj));
                if (sb.length() <= maxLen) continue;
                return theUtil.truncate(sb.toString(), maxLen);
            }
            return sb.toString();
        }
    }
}

