/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.IGetJson;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class MeasurementRegionObj
extends NamedMerlinObj
implements IMerlinGeomSrc,
IGetJson,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<MeasurementRegionObj> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(MeasurementRegionObj.class, PropertyDefs.legacy(null), NamedMerlinObj.PROPS);
    public static final TypedProp<IGeomNode> PROP_GEOM = TypedProps.build((Object)"GEOM", IGeomNode.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(MeasurementRegionObj::getGeom, Stream.empty()).attrSetter(MeasurementRegionObj::setGeom, null).attrFinish();
    public static final DisplayProp<UnitDouble> MSR_AREA = (DisplayProp)DisplayProps.build((Object)"MeasurementRegionObj.MSR_AREA", new UnitDouble(0.0, Geometry.AREA_UNIT), Intl.intl("Area"), "", 4).attrStoreAsReadOnly(PROP_TYPES).attrGetter(MeasurementRegionObj::getXYArea, PROP_GEOM).attrComparisonEditor(PropComparisons.factory().unitdouble(4)).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrGetter(MeasurementRegionObj::getTags, Stream.empty()).attrSetter(MeasurementRegionObj::setTags, null).attrFinish();
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(MeasurementRegionObj::isEnabled, Stream.empty()).attrSetter(MeasurementRegionObj::setEnabled, null).attrFinish();
    public static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"MeasurementRegionObj.STORED_VISIBILITY", true).attrMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(obj -> obj.d_visible, Stream.empty()).attrSetter(MeasurementRegionObj::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(MeasurementRegionObj::isVisible, Stream.of(ENABLED, STORED_VISIBILITY)).attrSetter(MeasurementRegionObj::setVisible, null).attrFinish();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Set<Tag> d_tags = Collections.emptySet();
    private AABox d_box;

    public MeasurementRegionObj(AABox box, String name) {
        super(name);
        this.d_box = box;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    private String constructJson() {
        JSONObject obj1 = new JSONObject();
        obj1.put("min", this.d_box.getMin().toString());
        obj1.put("max", this.d_box.getMax().toString());
        obj1.put("name", this.getName());
        JSONArray list = new JSONArray();
        list.add(obj1);
        JSONObject obj2 = new JSONObject();
        obj2.put("density-regions", list);
        return obj2.toJSONString();
    }

    @Override
    public String getJson() {
        return this.constructJson();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public Set<Tag> getTags() {
        return this.d_tags;
    }

    public void setTags(Set<Tag> tags) {
        if (Objects.equals(tags, this.d_tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(STORED_VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        Color translucentRed = new Color(255, 0, 0, 120);
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        AABoxGeom geom = this.getMeasureAreaGeom();
        Point3d min = geom.min;
        Point3d max = geom.max;
        Point3d p1 = geom.min;
        Point3d p2 = new Point3d(max.x, min.y, min.z);
        Point3d p3 = new Point3d(max.x, max.y, min.z);
        Point3d p4 = new Point3d(min.x, max.y, min.z);
        Point3d p5 = new Point3d(min.x, min.y, max.z);
        Point3d p6 = new Point3d(max.x, min.y, max.z);
        Point3d p7 = geom.max;
        Point3d p8 = new Point3d(min.x, max.y, max.z);
        ArrayList<LineSeg> lss = new ArrayList<LineSeg>();
        lss.add(new LineSeg(p1, p2));
        lss.add(new LineSeg(p2, p3));
        lss.add(new LineSeg(p3, p4));
        lss.add(new LineSeg(p4, p1));
        lss.add(new LineSeg(p1, p5));
        lss.add(new LineSeg(p2, p6));
        lss.add(new LineSeg(p3, p7));
        lss.add(new LineSeg(p4, p8));
        lss.add(new LineSeg(p5, p6));
        lss.add(new LineSeg(p6, p7));
        lss.add(new LineSeg(p7, p8));
        lss.add(new LineSeg(p8, p5));
        ArrayList<IManipulatable> geoms = new ArrayList<IManipulatable>();
        geoms.addAll(lss);
        geoms.add(geom);
        IGeom result = GeomUtil.group(geoms);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(result), gprops);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof AABoxGeom)) {
            return;
        }
        Point3d min = ((AABoxGeom)geom).min;
        Point3d max = ((AABoxGeom)geom).max;
        this.d_box = new AABox(min, max);
        this.changedEvt(PROP_GEOM);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getMeasureAreaGeom());
    }

    private AABoxGeom getMeasureAreaGeom() {
        return new AABoxGeom(this.d_box);
    }

    public UnitDouble getXYArea() {
        Unit unit = Geometry.AREA_UNIT;
        if (this.d_box.isValid()) {
            return new UnitDouble((this.d_box.getMaxX() - this.d_box.getMinX()) * (this.d_box.getMaxY() - this.d_box.getMinY()), unit);
        }
        return new UnitDouble(0.0, unit);
    }
}

