/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.stream.Stream;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.IOpacity;
import merlin.data.ImportType;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.geom.GeomUtil;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.cad.bim.BIMCoveringType;
import thunderheadeng.cad.bim.BIMTransportType;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.value.ConstVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public class ImportedGeom
extends NamedMerlinObj
implements IMerlinGeomSrc,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<ImportedGeom> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(ImportedGeom.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), NamedMerlinObj.PROPS);
    public static DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(ImportedGeom::isEnabled, Stream.empty()).attrSetter(ImportedGeom::setEnabled, null).attrFinish();
    public static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"ImportedGeom.STORED_VISIBILITY", true).attrMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(obj -> obj.d_visible, Stream.empty()).attrSetter(ImportedGeom::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(MerlinData.VISIBILITY).attrGetter(ImportedGeom::isVisible, Stream.of(MerlinData.ENABLED, STORED_VISIBILITY)).attrSetter(ImportedGeom::setVisible, null).attrFinish();
    @Deprecated
    private static final int OPT_EXCLUDE_FROM_ROOM_EXTRACTION = 1;
    public static final TypedProp<Integer> PROP_OPTIONS = TypedProps.build((Object)"OPTIONS", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getOptions, Stream.empty()).attrSetter(ImportedGeom::setOptions, null).attrFinish();
    public static final TypedProp<IPropsSrc> PROP_DISPLAY_PROPS = TypedProps.build((Object)"DISPLAY_PROPS", IPropsSrc.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getDisplayProps, Stream.empty()).attrSetter(ImportedGeom::setDisplayProps, null).attrFinish();
    public static final TypedProp<IGeomNode> PROP_GEOM = TypedProps.build((Object)"GEOM", IGeomNode.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getGeom, Stream.empty()).attrSetter(ImportedGeom::setGeom, null).attrFinish();
    static final TypedProp<DisplayGeom> PROP_DISPLAY_GEOM = TypedProps.build("ImportedGeom.DISPLAY_GEOM", DisplayGeom.class, DisplayGeom.EMPTY).attrStoreAsWrapper(PROP_TYPES).attrGetter((prop, obj) -> obj.getDisplayGeom(), Stream.of(PROP_DISPLAY_PROPS, PROP_GEOM)).attrSetter(ImportedGeom::setDisplayGeom, null).attrUndoPropRestore(false, PROP_GEOM, PROP_DISPLAY_PROPS).attrFinish();
    public static final DisplayProp<IMaterial[]> PROP_MATERIAL = GeomUtil.defineMaterialProp(PROP_TYPES, PROP_DISPLAY_GEOM, MerlinData.MATERIAL);
    public static final DisplayProp<Color> PROP_COLOR = GeomUtil.defineColorProp(PROP_TYPES, PROP_DISPLAY_GEOM, MerlinData.COLOR);
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(geom -> geom.get(PROP_COLOR), PROP_COLOR).attrFinish();
    public static final DisplayProp<IOpacity> PROP_OPACITY = GeomUtil.defineOpacityProp(PROP_TYPES, PROP_DISPLAY_GEOM, MerlinData.OPACITY);
    public static final TypedProp<BIMType> PROP_BIM_TYPE = TypedProps.build("BIM_TYPE", BIMType.class, BIMType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getBIMType, Stream.empty()).attrSetter(ImportedGeom::setBIMType, null).attrFinish();
    public static final DisplayProp<String> PROP_OBJECT_TYPE = (DisplayProp)DisplayProps.build((Object)"OBJECT_TYPE", "", Intl.intl("Object Type"), Intl.intl("The object type as specified in the imported file.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().string()).attrFinish();
    public static final DisplayProp<ImportType> PROP_IMPORTED_TYPE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IMPORTED_TYPE", ImportType.class, ImportType.OBSTRUCTION, Intl.intl("Import Type"), "<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(type -> type.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(ImportType.values())).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_WIDTH = TypedProps.build("DOOR_WIDTH", UnitDouble.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_HEIGHT = TypedProps.build("DOOR_HEIGHT", UnitDouble.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<IGeomNode> PROP_DOOR_VOID = TypedProps.build("DOOR_VOID", IGeomNode.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Vector3d> PROP_DOOR_DIR = TypedProps.build("DOOR_DIR", Vector3d.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> PROP_DOOR_IS_ACCESSIBLE = TypedProps.build("DOOR_IS_ACCESSIBLE", Boolean.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_FLOWRATE = TypedProps.build("DOOR_FLOWRATE", UnitDouble.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<BIMCoveringType> PROP_COVERING_TYPE = TypedProps.build("PROP_COVERING_TYPE", BIMCoveringType.class, BIMCoveringType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<BIMTransportType> PROP_TRANSPORT_TYPE = TypedProps.build("PROP_TRANSPORT_TYPE", BIMTransportType.class, BIMTransportType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Integer> PROP_SPACE_OCCUPANCY_NUMBER = TypedProps.build("SPACE_OCCUPANCY_NUMBER", Integer.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_SPACE_AREA_PER_OCCUPANT = TypedProps.build("SPACE_AREA_PER_OCCUPANT", UnitDouble.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Integer> PROP_SPACE_OCCUPANCY_NUMBER_PEAK = TypedProps.build("SPACE_OCCUPANCY_NUMBER_PEAK", Integer.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<String> PROP_BUILDING_PRE_EVACUATION_TIME = TypedProps.build("BUILDING_PRE_EVACUATION_TIME", String.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<String> PROP_BUILDING_OCC_PROFILES_LIST = TypedProps.build("BUILDING_OCC_PROFILES_LIST", String.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<IVariant<Boolean>> PROP_RESULTS_VISIBILITY = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("RESULTS_VISIBILITY", IVariant.class, new ConstVariant<Boolean>(true), Intl.intl("Results Visibility"), Intl.intl("Controls the visibility of the geometry over time when viewed in Results.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(vis -> VariantUtil.describeVariant(vis, visible -> visible != false ? Intl.intl("Visible") : Intl.intl("Hidden")))).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().booleanVariant(Intl.intl("Visible"), Intl.intl("Hidden"))).attrFinish();
    private Object d_geom;
    private IPropsSrc d_propsSrc;
    @Deprecated
    private Object d_uv;
    private int d_options;
    private boolean d_visible;
    private BIMType d_bimType;
    private PropertySet d_props;
    private boolean d_enabled = true;

    public ImportedGeom(String name) {
        this(name, DisplayGeom.EMPTY);
    }

    public ImportedGeom(String name, DisplayGeom dg) {
        this(name, dg.node, dg.props);
    }

    public ImportedGeom(String name, IGeomNode geom, IPropsSrc propsSrc) {
        super(name);
        this.d_geom = geom;
        this.d_propsSrc = propsSrc;
        this.d_visible = true;
        this.d_options = 0;
        this.d_bimType = BIMType.UNKNOWN;
        this.d_props = new PropertySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        boolean prior110 = MerlinOIS.isPrior(in, MerlinIO.Version.VER_0110);
        if (this.d_uv == null && prior110) {
            this.d_uv = Elements.NO_UV;
        }
        if (prior110) {
            IElemSource uvSrc = (IElemSource)this.d_uv;
            this.d_uv = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
        if (this.d_bimType == null) {
            this.d_bimType = BIMType.UNKNOWN;
        }
        if (this.d_props == null) {
            this.d_props = new PropertySet();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0133)) {
            if ((this.d_options & 1) == 1) {
                this.setImportedType(ImportType.IGNORED);
                this.d_options &= 0xFFFFFFFE;
            } else {
                this.setImportedType(this.getImportedTypeFromBIMType());
            }
        }
    }

    public ImportType getImportedTypeFromBIMType() {
        switch (this.d_bimType) {
            case Ramp: 
            case RampFlight: {
                return ImportType.RAMP;
            }
            case Slab: {
                return ImportType.FLOOR;
            }
            case Covering: {
                return this.get(PROP_COVERING_TYPE) == BIMCoveringType.FLOORING ? ImportType.FLOOR : ImportType.OBSTRUCTION;
            }
            case Stair: 
            case StairFlight: {
                return ImportType.STAIR;
            }
            case Door: {
                return ImportType.DOOR;
            }
            case TransportElement: {
                switch (this.get(PROP_TRANSPORT_TYPE)) {
                    case ESCALATOR: {
                        return ImportType.ESCALATOR;
                    }
                    case MOVINGWALKWAY: {
                        return ImportType.MOVING_WALKWAY;
                    }
                }
                return ImportType.OBSTRUCTION;
            }
            case Space: {
                return this.getDisplayGeom().node == DisplayGeom.EMPTY.node ? ImportType.IGNORED : ImportType.ROOM;
            }
            case Building: {
                return ImportType.BUILDING;
            }
        }
        return this.isA(BIMType.Element) || this.isA(BIMType.UNKNOWN) ? ImportType.OBSTRUCTION : ImportType.IGNORED;
    }

    public void setBIMType(BIMType type) {
        if (this.d_bimType == type) {
            return;
        }
        this.d_bimType = type;
        this.changedEvt(PROP_BIM_TYPE);
    }

    public BIMType getBIMType() {
        return this.d_bimType;
    }

    public ImportType getImportedType() {
        return this.get(PROP_IMPORTED_TYPE);
    }

    public void setImportedType(ImportType type) {
        this.set(PROP_IMPORTED_TYPE, type);
    }

    public boolean isA(BIMType type) {
        return type.isAncestorOf(this.getBIMType());
    }

    public boolean isA(ImportType type) {
        return this.getImportedType() == type;
    }

    public boolean isIgnoredInModelGeneration() {
        return this.getImportedType() == ImportType.IGNORED;
    }

    public void setOptionState(boolean state, int options) {
        int newOpts;
        int n = newOpts = state ? this.d_options | options : this.d_options & ~options;
        if (newOpts == this.d_options) {
            return;
        }
        this.d_options = newOpts;
        this.changedEvt(PROP_OPTIONS);
    }

    public boolean getOptionState(int options) {
        return (this.d_options & options) == options;
    }

    public int getOptions() {
        return this.d_options;
    }

    public void setOptions(int options) {
        if (options == this.d_options) {
            return;
        }
        this.d_options = options;
        this.changedEvt(PROP_OPTIONS);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom((IGeomNode)this.d_geom, this.d_propsSrc);
    }

    public DisplayGeom getDisplayGeom() {
        return this.getDisplayGeom(null);
    }

    public void setDisplayGeom(DisplayGeom dg) {
        this.pauseUpdates();
        this.setGeom(dg.node);
        this.setDisplayProps(dg.props);
        this.resumeUpdates();
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dispProps.isWireframe(this));
        return new DisplayGeom(pickable, this.d_propsSrc);
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(PROP_GEOM);
    }

    public void setDisplayProps(IPropsSrc props) {
        if (this.d_propsSrc == props) {
            return;
        }
        this.d_propsSrc = props;
        this.changedEvt(PROP_DISPLAY_PROPS);
    }

    public IPropsSrc getDisplayProps() {
        return this.d_propsSrc;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(STORED_VISIBILITY);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

