/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders.queues;

import javax.vecmath.Vector3d;
import merlin.builders.AQueueElementBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.geom.Geometry;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;

public class QueueServiceBuilder
extends AQueueElementBuilder {
    public static final Object DEST_CHANGED = "QueueServiceBuilder.DEST_CHANGED";
    public static final Object WAIT_CHANGED = "QueueServiceBuilder.WAIT_CHANGED";
    private IDistributedVal<UnitDouble> d_waitTime = new ConstantCurve(new UnitDouble(5.0, SI.SECOND));
    private UnitPoint3D d_dest = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private IEgressOccupiable d_room = null;
    private Vector3d d_roomNormal = GeomConstants.VEC3D_ZPOS;

    public QueueServiceBuilder(MerlinData md) {
        super(md);
    }

    public void setWaitTime(IDistributedVal<UnitDouble> waitTime) {
        if (!this.lock()) {
            return;
        }
        this.d_waitTime = waitTime;
        this.firePropChanged(WAIT_CHANGED);
        this.firePropChanged(VALIDITY);
        this.release();
    }

    public IDistributedVal<UnitDouble> getWaitTime() {
        return this.d_waitTime;
    }

    public void setDestination(UnitPoint3D dest, IEgressOccupiable room, Vector3d roomNorm) {
        if (!this.lock()) {
            return;
        }
        this.d_dest = dest;
        this.d_room = room;
        this.d_roomNormal = roomNorm;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public UnitPoint3D getDestination() {
        return this.d_dest;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Vector3d getRoomNormal() {
        return this.d_roomNormal;
    }

    @Override
    public boolean isValid() {
        return this.d_room != null;
    }

    @Override
    protected IQueueElement create() {
        String servName = this.d_data.queueServiceNameGen.getCurrentName();
        this.d_data.queueServiceNameGen.nextName();
        return new QueueService(servName, this.getDestination().getPoint3dValue(Geometry.LENGTH_UNIT), this.getWaitTime(), this.getRoom(), this.getRoomNormal());
    }

    @Override
    public void reset() {
    }
}

