/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.builders.AQueueElementBuilder;
import merlin.data.MerlinData;
import merlin.data.SequentialNameGen;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.geom.Geometry;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.text.IDimensionLabelSrc;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;

public class QueuePathBuilder
extends AQueueElementBuilder
implements IDimensionLabelSrc {
    public static final Object TEMP_LOC_CHANGED = "QueuePathBuilder.TEMP_LOC_CHANGED";
    public static final Object NODE_COMMITTED = "QueuePathBuilder.NODE_COMMITTED";
    public static final Object DIRECTION_CHANGED = "QueuePathBuilder.DIRECTION_CHANGED";
    private List<UnitPoint3D> d_points;
    private List<IEgressOccupiable> d_rooms;
    private List<Vector3d> d_faceNormals;
    private UnitPoint3D d_tempPoint;
    private IEgressOccupiable d_tempRoom;
    private Vector3d d_tempFaceNormal;
    private UnitPoint3D d_lastValidPoint;
    private IEgressOccupiable d_lastValidRoom;
    private Vector3d d_lastValidFaceNormal;
    private DRAW_DIRECTION d_drawDirection = DRAW_DIRECTION.FROM_HEAD;

    public QueuePathBuilder(MerlinData md) {
        super(md);
        this.d_points = new ArrayList<UnitPoint3D>();
        this.d_rooms = new ArrayList<IEgressOccupiable>();
        this.d_faceNormals = new ArrayList<Vector3d>();
    }

    public void setTempLocation(UnitPoint3D loc, IEgressOccupiable room, Vector3d normal) {
        if (!this.lock()) {
            return;
        }
        this.d_tempPoint = loc;
        this.d_tempRoom = room;
        this.d_tempFaceNormal = normal;
        if (room != null) {
            this.d_lastValidPoint = loc;
            this.d_lastValidRoom = room;
            this.d_lastValidFaceNormal = normal;
        }
        this.pause();
        this.firePropChanged(TEMP_LOC_CHANGED);
        this.resume();
        this.release();
    }

    public UnitPoint3D getTempLocation() {
        return this.d_tempPoint;
    }

    public IEgressOccupiable getTempRoom() {
        return this.d_tempRoom;
    }

    private void reverseIfFromTail(List<?> list) {
        if (this.d_drawDirection == DRAW_DIRECTION.FROM_TAIL) {
            Collections.reverse(list);
        }
    }

    public List<UnitPoint3D> getDrawPoints() {
        ArrayList<UnitPoint3D> points = new ArrayList<UnitPoint3D>(this.d_points);
        if (this.d_lastValidRoom != null) {
            points.add(this.d_lastValidPoint);
        }
        this.reverseIfFromTail(points);
        return points;
    }

    public List<IEgressOccupiable> getDrawRooms() {
        ArrayList<IEgressOccupiable> rooms = new ArrayList<IEgressOccupiable>(this.d_rooms);
        if (this.d_lastValidRoom != null) {
            rooms.add(this.d_lastValidRoom);
        }
        this.reverseIfFromTail(rooms);
        return rooms;
    }

    public List<Vector3d> getDrawFaceNormals() {
        ArrayList<Vector3d> norms = new ArrayList<Vector3d>(this.d_faceNormals);
        if (this.d_lastValidFaceNormal != null) {
            norms.add(this.d_lastValidFaceNormal);
        }
        this.reverseIfFromTail(norms);
        return norms;
    }

    public DRAW_DIRECTION getDrawDirection() {
        return this.d_drawDirection;
    }

    public void setDrawDirection(DRAW_DIRECTION dir) {
        if (!this.lock()) {
            return;
        }
        if (dir == this.d_drawDirection) {
            return;
        }
        this.d_drawDirection = dir;
        this.pause();
        this.firePropChanged(DIRECTION_CHANGED);
        this.resume();
        this.release();
    }

    public boolean commitLoc() {
        if (this.d_tempRoom == null) {
            return false;
        }
        if (!this.lock()) {
            return false;
        }
        this.pause();
        this.d_points.add(this.d_tempPoint);
        this.d_rooms.add(this.d_tempRoom);
        this.d_faceNormals.add(this.d_tempFaceNormal);
        this.firePropChanged(NODE_COMMITTED);
        this.resume();
        this.release();
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected IQueueElement create() {
        ArrayList<QueuePathNode> nodes = new ArrayList<QueuePathNode>();
        assert (this.d_rooms.size() == this.d_points.size() && this.d_rooms.size() == this.d_faceNormals.size());
        String pathName = this.d_data.queuePathNameGen.getCurrentName();
        this.d_data.queuePathNameGen.nextName();
        QueuePath path = new QueuePath(pathName);
        for (int i = 0; i < this.d_points.size(); ++i) {
            nodes.add(new QueuePathNode("", this.d_points.get(i).getPoint3dValue(Geometry.LENGTH_UNIT), this.d_rooms.get(i), this.d_faceNormals.get(i)));
        }
        if (this.d_drawDirection == DRAW_DIRECTION.FROM_TAIL) {
            Collections.reverse(nodes);
        }
        SequentialNameGen nodeNameGen = new SequentialNameGen(Intl.intl("Node"), 2);
        for (QueuePathNode node : nodes) {
            node.setName(nodeNameGen.nextName());
        }
        path.addAll(nodes);
        return path;
    }

    @Override
    public void reset() {
        this.d_points.clear();
        this.d_rooms.clear();
        this.d_faceNormals.clear();
    }

    @Override
    public List<Pair<Point3d, Double>> getDimensions() {
        List<UnitPoint3D> points = this.getDrawPoints();
        if (points.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Point3d, Double>> dimensions = new ArrayList<Pair<Point3d, Double>>(points.size() - 1);
        for (int i = 0; i < points.size() - 1; ++i) {
            Point3d start = points.get(i).getPoint3dValue(SI.METER);
            Point3d end = points.get(i + 1).getPoint3dValue(SI.METER);
            dimensions.add(Util3D.getMidpointAndDist(start, end));
        }
        return dimensions;
    }

    public static enum DRAW_DIRECTION {
        FROM_HEAD,
        FROM_TAIL;

    }
}

