/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.builders.ABehaviorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.LookAhead;
import merlin.data.egress.scripting.RemoveOcc;
import merlin.data.egress.scripting.ResumePrior;
import merlin.data.egress.scripting.WaitUntilEnd;

public class SimpleActionBuilder
extends ABehaviorActionBuilder {
    private Type d_type;

    public SimpleActionBuilder(MerlinData md, Type initialType) {
        super(md);
        this.d_type = initialType;
    }

    public Type getType() {
        return this.d_type;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected IBehaviorAction create(MerlinData md) {
        switch (this.d_type.ordinal()) {
            case 1: {
                return new RemoveOcc();
            }
            case 0: {
                return new ResumePrior();
            }
            case 2: {
                return new WaitUntilEnd();
            }
            case 3: {
                return new LookAhead();
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    protected String getName(MerlinData md) {
        return this.create(md).getName();
    }

    @Override
    protected boolean mustBeLast(MerlinData md) {
        return this.create(md).mustBeLast();
    }

    public static enum Type {
        RESUME_PRIOR,
        REMOVE_OCC,
        WAIT_UNTIL_END,
        LOOK_AHEAD;

    }
}

