/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.Intl;
import merlin.actions.AddObject;
import merlin.actions.Undo;
import merlin.builders.PlanarGeomBuilder;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IGeom;

public class MeasurementRegionBuilder
implements PlanarGeomBuilder.IGeomBuilder {
    private final double Z_TOLERANCE = 0.2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(MerlinData md, PlanarGeomBuilder builder, IGeom geom) {
        AABox abox = geom.getBoundingBox(new AABox());
        if (!abox.isValid()) {
            return;
        }
        abox.set(abox.getMinX(), abox.getMinY(), abox.getMinZ() - 0.2, abox.getMaxX(), abox.getMaxY(), abox.getMaxZ() + 0.2);
        INameGenerator nameGenerator = md.densityNameGen;
        String name = nameGenerator.getCurrentName();
        MeasurementRegionObj obj = new MeasurementRegionObj(abox, name);
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("New Measurement Region"));
            try {
                AddObject.add((MerlinData)md, (Composite)md.regions, (int)md.regions.getMembers().size(), (IMerlinObj[])new MeasurementRegionObj[]{obj});
            }
            finally {
                Undo.end(md);
                nameGenerator.nextName();
            }
        }
    }
}

