/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.CompositePropertyUtil;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.GlobalDisplayMgr;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;

public class Visibility {
    public static void setVisibility(MerlinData md, Collection<?> toShow, Collection<?> toHide, boolean hideFirst) {
        LinkedIdentityHashSet<IMerlinObj> showObjs = new LinkedIdentityHashSet<IMerlinObj>(toShow.size());
        LinkedIdentityHashSet<IMerlinObj> hideObjs = new LinkedIdentityHashSet<IMerlinObj>(toHide.size());
        for (Object obj : toShow) {
            Visibility.collectVisibilityHierarchy(md, showObjs, obj);
        }
        for (Object obj : toHide) {
            Visibility.collectVisibilityHierarchy(md, hideObjs, obj);
        }
        Visibility.removeGroups(showObjs);
        Visibility.removeGroups(hideObjs);
        if (Visibility.containsClipped(md, toShow)) {
            hideObjs.removeAll(md.floors.getMembers());
            showObjs.addAll(md.floors.getMembers());
        }
        if (hideFirst) {
            hideObjs.removeAll(showObjs);
            Undo.insertUndoEntry_propRestore(md, hideObjs, MerlinData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, showObjs, MerlinData.VISIBILITY);
            Visibility.setVisibility(hideObjs, false);
            Visibility.setVisibility(showObjs, true);
        } else {
            showObjs.removeAll(hideObjs);
            Undo.insertUndoEntry_propRestore(md, showObjs, MerlinData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, hideObjs, MerlinData.VISIBILITY);
            Visibility.setVisibility(showObjs, true);
            Visibility.setVisibility(hideObjs, false);
        }
    }

    private static boolean containsClipped(MerlinData md, Collection<?> objs) {
        MerlinApp app = MerlinApp.getApp();
        if (app == null) {
            return false;
        }
        GlobalDisplayMgr dispMgr = app.getModelView().getDisplayManager();
        for (Object o : MerlinUtil.flatten(objs)) {
            if (!dispMgr.isClippedByFloor(o)) continue;
            return true;
        }
        return false;
    }

    private static void collectVisibilityHierarchy(MerlinData md, Set<IMerlinObj> coll, Object obj) {
        if (!(obj instanceof IMerlinObj) || !coll.add((IMerlinObj)obj)) {
            return;
        }
        if (obj instanceof IEgressOccupiable) {
            IEgressOccupiable occu = (IEgressOccupiable)obj;
            for (EgressAgent agent : occu.getOccupants()) {
                Visibility.collectVisibilityHierarchy(md, coll, agent);
            }
            for (GotoWaypoint gw : occu.getWaypoints()) {
                Visibility.collectVisibilityHierarchy(md, coll, gw);
            }
        }
        for (Object child : md.hierarchy.getChildren(obj)) {
            Visibility.collectVisibilityHierarchy(md, coll, child);
        }
    }

    private static void removeGroups(Set<IMerlinObj> coll) {
        Iterator<IMerlinObj> it = coll.iterator();
        while (it.hasNext()) {
            IMerlinObj obj = it.next();
            if (!(obj instanceof Composite) || obj.isSupportedLocallyCurrently(MerlinData.VISIBILITY)) continue;
            it.remove();
        }
    }

    private static void setVisibility(Set<IMerlinObj> objs, boolean visibility) {
        Boolean val = visibility ? Boolean.TRUE : Boolean.FALSE;
        CompositePropertyUtil.setValue(MerlinData.VISIBILITY, val, objs);
    }

    public static ConvexHull[] getVisibleFloorHulls(MerlinData md) {
        Floor[] visibleFloors = (Floor[])md.floors.getMembers(Floor.class).stream().filter(GeomComposite::isVisible).toArray(Floor[]::new);
        return md.floors.getClippingRegions(visibleFloors);
    }

    public static boolean isVisible(MerlinData md, IMerlinObj obj, ConvexHull[] visibleFloorHulls) {
        PropValue<Boolean> visibleProp = obj.getWithDetails(MerlinData.VISIBILITY);
        if (visibleProp.isUnsupported() || visibleProp.isUniform() && !visibleProp.get().booleanValue()) {
            return false;
        }
        PropValue<Boolean> enabledProp = obj.getWithDetails(MerlinData.ENABLED);
        if (enabledProp.isUniform() && !enabledProp.get().booleanValue()) {
            return false;
        }
        ModelView modelView = MerlinApp.getApp().getModelView();
        if (!modelView.isVisible(obj.getClass())) {
            return false;
        }
        if (obj instanceof IMerlinGeomSrc) {
            IMerlinGeomSrc geomSrc = (IMerlinGeomSrc)((Object)obj);
            if (modelView.getDisplayManager().isClippedByFloor(obj)) {
                AABox objBounds = geomSrc.getBounds();
                boolean intersectsFloor = false;
                for (ConvexHull hull : visibleFloorHulls) {
                    if (!hull.containsAtLeastPart(objBounds)) continue;
                    intersectsFloor = true;
                    break;
                }
                if (!intersectsFloor) {
                    return false;
                }
            }
        }
        return true;
    }
}

