/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.io.FileUtil;
import common.io.pfr.PFRFile;
import common.io.pfr.PFRReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.MerlinOp;
import merlin.actions.ResultsUtil;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.Plot2dDlg;
import merlin.gui.guiUtil;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TeciProps;

public class TimeHistoryPlots {
    public static final UIHook UI_HOOK_DOOR_FLOW = new UIHook((MerlinOp)new DoorFlow(), Intl.intl("View Door &Flow Rates...") + ",-," + Intl.intl("View Door Flow Rates..."), guiUtil.loadMerlinIcon("results2D16.gif"));
    public static final UIHook UI_HOOK_ROOM_USAGE = new UIHook((MerlinOp)new RoomUsage(), Intl.intl("View Room &Usage...") + ",-," + Intl.intl("View Room Usage..."), guiUtil.loadMerlinIcon("results2D16.gif"));
    public static final UIHook UI_HOOK_MEASUREMENT_REGIONS_RATES = new UIHook((MerlinOp)new MeasurementRegionsRate(), Intl.intl("View Measurement Regions...") + ",-," + Intl.intl("View Measurement Regions..."), guiUtil.loadMerlinIcon("results2D16.gif"));

    private static void showDlg(MerlinApp app, Plot2dDlg plotPanel) {
        JFrame mainFrame = app.getMainFrame();
        plotPanel.setSize(mainFrame.getWidth() * 2 / 3, mainFrame.getHeight() * 2 / 3);
        plotPanel.setLocationRelativeTo(app.getMainFrame());
        plotPanel.setVisible(true);
    }

    private static class DoorFlow
    extends Results2DOp {
        public DoorFlow() {
            super("_doors.csv", f -> FileUtil.getDoorsFn(f.getParentFile(), f.getName()), dlg -> dlg.getFlowRateMode());
        }
    }

    private static class RoomUsage
    extends Results2DOp {
        public RoomUsage() {
            super("_rooms.csv", f -> FileUtil.getNodesFn(f.getParentFile(), f.getName()), dlg -> dlg.getCountMode());
        }
    }

    private static class MeasurementRegionsRate
    extends Results2DOp {
        public MeasurementRegionsRate() {
            super("_measurement-regions.csv", f -> FileUtil.getRegionsFn(f.getParentFile(), f.getName()), dlg -> dlg.getVelocityMode());
        }
    }

    private static class CharsetMap
    implements Function<File, Optional<Charset>> {
        private final String d_suffix;

        public CharsetMap(String inputSuffix) {
            this.d_suffix = inputSuffix;
        }

        @Override
        public Optional<Charset> apply(File t) {
            String name = t.getName();
            if (name.endsWith(this.d_suffix)) {
                String modelName = name.substring(0, name.length() - this.d_suffix.length());
                File pfrFile = FileUtil.getResultsFn(t.getParentFile(), modelName);
                if (pfrFile.exists()) {
                    try {
                        TeciProps pfr = PFRReader.read(pfrFile);
                        PFRFile.Version ver = PFRReader.getVersion(pfr);
                        if (ver.compareTo(PFRFile.Version.V01) < 0) {
                            return Optional.empty();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return Optional.of(StandardCharsets.UTF_8);
        }
    }

    private static class Results2DOp
    extends AMerlinOp {
        private final String d_fnSuffix;
        private final Function<File, File> d_fnMap;

        public Results2DOp(String fnSuffix, Function<File, File> fnMap, Function<Plot2dDlg, Plot2dDlg.IMode> modeMap) {
            this.d_fnSuffix = fnSuffix;
            this.d_fnMap = fnMap;
        }

        private File getDefaultFile(String pthFilename) {
            if (pthFilename != null) {
                File f = new File(pthFilename);
                String rootFn = InfernoUtil.rootFn(f.getPath());
                return this.d_fnMap.apply(new File(f.getParentFile(), rootFn));
            }
            return null;
        }

        private File pickScenarioDefaultFile(MerlinApp app, MerlinData md) {
            try {
                if (md.filename == null) {
                    return null;
                }
                List<ScenarioUtil.ScenarioVariationKey> keys = ScenarioUtil.streamVariations(md).toList();
                ScenarioUtil.ScenarioVariationKey choice = ResultsUtil.pickScenario(md, app.getMainFrame(), keys, ScenarioUtil.ScenarioVariationKey::toString, new ScenarioUtil.ScenarioVariationKey(md.scenarios.getActive(), 0, 1), Intl.intl("Plot results for scenario:"));
                if (choice == null) {
                    return null;
                }
                SimOutputDir outDir = ScenarioUtil.getOutputDir(md, choice.scenario(), choice.variationIndex());
                Optional<Nullable<File>> result = ResultsUtil.promptLegacyFile(app.getMainFrame(), outDir, dir -> this.getDefaultFile(dir.getFilePath(Path.of(".pth", new String[0])).toString()));
                return result.map(fileNullable -> (File)fileNullable.val).orElse(null);
            }
            catch (IOException e) {
                guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Failed to resolve output directory."), (Throwable)e);
                return null;
            }
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            Plot2dDlg plotPanel = new Plot2dDlg(new CharsetMap(this.d_fnSuffix));
            app.addFrame(plotPanel);
            plotPanel.open(app, md, this.pickScenarioDefaultFile(app, md));
            TimeHistoryPlots.showDlg(app, plotPanel);
        }
    }
}

