/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Set;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.gui.PathObjsList;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ShowOverridingScenarios
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ShowOverridingScenarios(), Intl.intl("Show Customizing Scenarios...,Show a list of scenarios where properties of the selected objects are customized.,Show a list of scenarios where properties of the selected objects are customized."));

    public ShowOverridingScenarios() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    public static Set<Scenario> getOverriding(MerlinData md) {
        return md.scenarios.flatten(Scenario.class).stream().filter(scenario -> !scenario.isDefault()).filter(scenario -> scenario.getCustomizedObjects().stream().anyMatch(obj -> md.selection.isSelected(obj))).collect(Collectors.toSet());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<Scenario> overriding = ShowOverridingScenarios.getOverriding(md);
        ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>((Window)app.getActiveFrame(), Intl.intl("Show Customizing Scenarios"), new PathObjsList(md, "", false, true, overriding));
        dlg.doModeless();
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(IMerlinObj.class));
    }
}

