/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.Visibility;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SetActiveFloor
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SetActiveFloor(), Intl.intl("Set as Active Floor"));

    public SetActiveFloor() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        Set sel = MerlinApp.getApp().getData().selection.getSelected(Object.class);
        this.setEnabled(sel.size() == 1 && sel.iterator().next() instanceof Floor);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Set selFloors = md.selection.getSelected(Floor.class);
            if (selFloors.isEmpty()) {
                return;
            }
            Floor floor = (Floor)selFloors.iterator().next();
            SetActiveFloor.setActiveFloor2(md, floor);
        }
    }

    public static void setActiveFloor(Component c, final Floor floor) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    SetActiveFloor.setActiveFloor2(md, floor);
                }
            }
        };
        UIHook.run(c, "SetActiveFloor.setActiveFloor", op, 0);
    }

    public static void setActiveFloor2(MerlinData md, Floor floor) {
        Undo.begin(Intl.intl("Change Floor"));
        Undo.insertUndoEntry_restore(md, md.floors);
        LinkedIdentityHashSet<Floor> allFloors = new LinkedIdentityHashSet<Floor>(md.floors.getMembers(Floor.class));
        Undo.insertUndoEntry_restore(md, allFloors);
        md.floors.setActive(floor);
        List<Composite> toHide = Arrays.asList(md.agents, md.floors);
        List<Floor> toShow = Arrays.asList(floor);
        Visibility.setVisibility(md, toShow, toHide, true);
        Undo.end(md);
    }
}

