/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SelectCustomOccs
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectCustomOccs(), Intl.intl("Select Customized Occupants"));

    public SelectCustomOccs() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        Collection<EgressAgent> customAgents = SelectCustomOccs.getCustomAgents(MerlinApp.getApp().getData().selection.getSelected(IMerlinObj.class));
        this.setEnabled(!customAgents.isEmpty());
    }

    private static Collection<EgressAgent> getCustomAgents(Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, EgressAgent.class, new Predicate<EgressAgent>(){

            @Override
            public boolean test(EgressAgent o) {
                return o.getProfile().getNumLocal() != 0;
            }
        });
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Customized Occupants"));
            Undo.insertUndoEntry_restoreSelection(md);
            ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>(SelectCustomOccs.getCustomAgents(md.selection.getSelected(IMerlinObj.class)));
            md.selection.set(agents);
            Undo.end(md);
        }
    }
}

