/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ScenarioSetupAction
extends AbstractAction
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private final Consumer<ActionEvent> func;

    public ScenarioSetupAction(Consumer<ActionEvent> actionConsumer) {
        super(Intl.intl("Scenario Setup..."));
        this.func = actionConsumer;
        Scenario s = MerlinApp.getAppData().scenarios.getActive();
        if (!s.isDefault()) {
            Icon icon = s.newDecaratorIcon();
            this.putValue("SmallIcon", icon);
        }
        this.sync();
        MerlinApp.getAppData().getEvents().addObserver(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.func.accept(e);
    }

    protected void sync() {
        Scenario active = MerlinApp.getAppData().scenarios.getActive();
        String tt = active.isDefault() ? null : String.format(Intl.intl("Configure properties for Scenario: %s"), MerlinUtil.getName(active));
        this.putValue("ShortDescription", tt);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getAppData();
        if (events.isChanged(md.scenarios, ScenarioRoot.ACTIVE_SCENARIO) || events.isChanged(md.scenarios.getActive(), Scenario.NAME)) {
            this.sync();
        }
    }
}

