/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.RecentFilesEntry;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;

public class Save
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Save16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Save(), Intl.intl("&Save,S,Save model,Save the current model"), ICON);
    private static boolean s_forceSavePrompt = false;

    public static void setForceSavePrompt(boolean force) {
        s_forceSavePrompt = force;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Save.saveToFile(app, md, false);
    }

    private static String promptForSaveFile(MerlinApp app, MerlinData md, String fn) {
        guiJFXFileChooser chooser;
        File saveFile;
        if (fn == null) {
            fn = Intl.intl("untitled.pth");
        }
        if ((saveFile = (chooser = new guiJFXFileChooser(fn, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_PATHFINDER)).showSaveDialog()) == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, saveFile.getParent());
        return saveFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile(MerlinApp app, MerlinData md, boolean forcePrompt) {
        String filename = md.filename;
        if ((forcePrompt |= s_forceSavePrompt) || filename == null) {
            String result = Save.promptForSaveFile(app, md, filename);
            if (result == null) {
                return false;
            }
            filename = result;
            app.setWorkingDir(filename);
        }
        app.beginWaitCursor();
        try {
            try {
                MerlinIO.writeModel(filename, md);
            }
            catch (Throwable e) {
                guiUtil.showError(app, Intl.intl("File Error"), String.format(Intl.intl("Could not save %s"), filename), e);
                boolean bl = false;
                app.endWaitCursor();
                return bl;
            }
            s_forceSavePrompt = false;
            try (MerlinData.WriteLock lock = md.lockWrite();){
                md.filename = filename;
                md.modified = false;
                md.getEvents().added((Object)new RecentFilesEntry(md.filename));
                md.getEvents().changed(md, MerlinData.MODIFIED_CHANGED);
                md.getEvents().changed(md, MerlinData.MODEL_SAVED);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
    }
}

