/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.RenameDialog;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class RenameAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RenameAction(), Intl.intl("&Rename...,-,Rename selected objects"));
    private static final EnumSet<RenameDialog.DefaultKeywordOpts> s_allowedKeywords = EnumSet.complementOf(EnumSet.of(RenameDialog.DefaultKeywordOpts.SELECTION_IX));

    public RenameAction() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Collection<IMerlinObj> objs = RenameAction.getRenameObjs(md);
        assert (!objs.isEmpty());
        IMerlinObj[] namedArr = theUtil.toArray(objs, IMerlinObj.class);
        RenameDialog.ICallback<IMerlinObj> callback = RenameAction.getRenameCallback(md);
        List keywords = RenameDialog.getDefaultKeywords(callback, objs, s_allowedKeywords);
        RenameDialog<IMerlinObj> dlg = new RenameDialog<IMerlinObj>((Window)app.getActiveFrame(), callback, keywords, objs);
        if (dlg.doModal() != 1) {
            return;
        }
        List<String> newNames = dlg.generateNames((IMerlinObj[])namedArr);
        if (newNames.isEmpty()) {
            return;
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            assert (newNames.size() == namedArr.length);
            List<Pair> entries = IntStream.range(0, namedArr.length).filter(i -> newNames.get(i) != null).mapToObj(i -> new Pair<IMerlinObj, String>(namedArr[i], (String)newNames.get(i))).toList();
            List<IMerlinObj> filteredToRename = entries.stream().map(e -> (IMerlinObj)e.v1).toList();
            List<String> filteredNewNames = entries.stream().map(e -> (String)e.v2).toList();
            RenameAction.renameImpl(md, filteredToRename, filteredNewNames);
        }
    }

    private static RenameDialog.ICallback<IMerlinObj> getRenameCallback(final MerlinData md) {
        return new RenameDialog.ICallback<IMerlinObj>(){

            @Override
            public Object getRoot(IMerlinObj obj) {
                Object[] path = md.hierarchy.getPath(obj);
                return path == null || path.length < 2 ? null : path[1];
            }

            @Override
            public List<Object> flattenHierarchy(Object obj) {
                return MerlinUtil.flatten(md.hierarchy.getChildren(obj)).stream().toList();
            }

            @Override
            public Object getParent(Object obj) {
                return md.hierarchy.getParent(obj);
            }

            @Override
            public List<Object> getChildren(Object obj) {
                return md.hierarchy.getChildren(obj).stream().toList();
            }

            @Override
            public String getName(Object obj) {
                return MerlinUtil.getName(obj);
            }

            @Override
            public String getTypeString(IMerlinObj obj) {
                return EntryPointFactory.get(obj).getTypeString(md, obj);
            }

            @Override
            public OptionalLong getResultsId(IMerlinObj obj) {
                if (obj == null) {
                    return OptionalLong.empty();
                }
                long id = obj.getResultsId();
                return id == -1L ? OptionalLong.empty() : OptionalLong.of(id);
            }

            @Override
            public Predicate<String> getNameValidator(IMerlinObj obj) {
                return EntryPointFactory.get(obj).getNameValidator(md, obj);
            }

            @Override
            public Object getUniqueNameGroup(IMerlinObj obj) {
                return EntryPointFactory.get(obj).getUniqueNameGroup(md, obj);
            }

            @Override
            public Collection<?> getGroupObjs(Object token) {
                Collection<Object> collection;
                if (token instanceof EntryPoint.INameGroup) {
                    EntryPoint.INameGroup group = (EntryPoint.INameGroup)token;
                    collection = group.get(md);
                } else {
                    collection = Collections.emptyList();
                }
                return collection;
            }
        };
    }

    private static void renameImpl(MerlinData md, List<? extends IMerlinObj> objs, List<String> newNames) {
        if (objs.isEmpty()) {
            return;
        }
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(objs, newNames, true);
        op.perform();
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
    }

    public static boolean rename(MerlinData md, Window parent, Collection<? extends IMerlinObj> objs, String newName) {
        if (objs.isEmpty()) {
            return true;
        }
        Optional<Function<IMerlinObj, String>> validatedResult = RenameDialog.validateNames(parent, RenameAction.getRenameCallback(md), objs, o -> newName);
        if (validatedResult.isEmpty()) {
            return false;
        }
        Function<IMerlinObj, String> namesFunc = validatedResult.get();
        IFilteredCollection<IMerlinObj> renObjs = theUtil.filter(objs, o -> namesFunc.apply((IMerlinObj)o) != null);
        if (renObjs.isEmpty()) {
            return false;
        }
        List<String> newNames = renObjs.stream().map(namesFunc).toList();
        newNames = newNames.stream().map(e -> e.trim()).toList();
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(new ArrayList<IMerlinObj>(renObjs), newNames, true);
        op.perform();
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
        return renObjs.size() == objs.size();
    }

    public static Predicate<IMerlinObj> getIsRenameableFilter(MerlinData md) {
        return named -> EntryPointFactory.get(named).tvEntryPoint.canRename(md, (IMerlinObj)named);
    }

    private static boolean testShouldEnable(MerlinData md, Collection<IMerlinObj> selected) {
        return !selected.isEmpty();
    }

    private static Collection<IMerlinObj> getRenameObjs(MerlinData md) {
        return md.selection.get(IMerlinObj.class, RenameAction.getIsRenameableFilter(md));
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getAppData();
        this.setEnabled(RenameAction.testShouldEnable(md, RenameAction.getRenameObjs(md)));
    }

    private static class RenameOp
    implements UndoFramework.UndoOp,
    Cloneable {
        private final List<? extends IMerlinObj> d_objs;
        private final List<String> d_oldNames;
        private final List<String> d_newNames;
        private boolean d_ascend;

        public RenameOp(List<? extends IMerlinObj> objs, List<String> newNames, boolean ascend) {
            this.d_objs = objs;
            this.d_oldNames = new ArrayList<String>(objs.size());
            for (IMerlinObj iMerlinObj : objs) {
                if (iMerlinObj instanceof Floor) {
                    this.d_oldNames.add(((Floor)iMerlinObj).getBaseName());
                    continue;
                }
                this.d_oldNames.add(iMerlinObj.getName());
            }
            this.d_newNames = newNames;
            this.d_ascend = ascend;
        }

        private UndoFramework.UndoOp getReverseOp() {
            try {
                RenameOp clone = (RenameOp)this.clone();
                clone.d_ascend = !clone.d_ascend;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public UndoFramework.UndoOp perform() {
            UndoFramework.UndoOp undo = this.getReverseOp();
            if (this.d_ascend) {
                for (int m = 0; m < this.d_objs.size(); ++m) {
                    IMerlinObj obj = this.d_objs.get(m);
                    obj.setName(this.d_newNames.get(m));
                }
            } else {
                for (int m = this.d_objs.size() - 1; m >= 0; --m) {
                    IMerlinObj obj = this.d_objs.get(m);
                    String oldName = this.d_oldNames.get(m);
                    obj.setName(oldName);
                }
            }
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

