/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import org.jscience.physics.units.NonSI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class RandomizeOrientAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RandomizeOrientAction(), Intl.intl("Randomize Orientation,-,Randomizes the orientations of the selected occupants or occupant targets."));
    private static final Logger LOGGER = Logger.getLogger(RandomizeOrientAction.class.getName());
    private static final Random s_rand = new Random(176124713L);

    public RandomizeOrientAction() {
        SelectionObserver.add(this, IOrientable.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Set objs = md.selection.getDeepSelected(IOrientable.class);
            Undo.begin(Intl.intl("Randomize Orientation"));
            Undo.insertUndoEntry_restore(md, theUtil.filter(objs, IMerlinObj.class));
            ArrayList toOrient = new ArrayList(objs);
            int attempts = 0;
            int maxAttempts = 400;
            for (IOrientable orientable : toOrient) {
                while (attempts < maxAttempts) {
                    ++attempts;
                    UnitDouble newOrient = new UnitDouble(s_rand.nextDouble() * 360.0 - 180.0, NonSI.DEGREE_ANGLE);
                    if (orientable.isValidOrient(newOrient)) {
                        orientable.setOrient(newOrient);
                        break;
                    }
                    if (attempts < maxAttempts) continue;
                    LOGGER.log(Level.WARNING, String.format("Unable to reorient %s due to overlapping geometry", orientable));
                }
                attempts = 0;
            }
            Undo.end(md);
        }
    }

    @Override
    public void update(Events events) {
        MerlinSelectionModel sel = MerlinApp.getApp().getData().selection;
        this.setEnabled(!sel.isDeepEmpty(IOrientable.class));
    }
}

