/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NewSeeds
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new NewSeeds(), Intl.intl("Randomize,-,Generate new random seeds for selected occupants and occupant sources."));

    public NewSeeds() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData data = MerlinApp.getApp().getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!this.getObjs(sel).isEmpty());
    }

    private Collection<IMerlinObj> getObjs(MerlinSelectionModel sel) {
        return sel.flatten(IMerlinObj.class, MerlinUtil::canRandomize);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Randomize"));
            ArrayList<IMerlinObj> selObjs = new ArrayList<IMerlinObj>(this.getObjs(md.selection));
            if (selObjs.isEmpty()) {
                return;
            }
            Undo.insertUndoEntry_propRestore(md, selObjs, MerlinData.SEED);
            for (IMerlinObj agent : selObjs) {
                agent.set(MerlinData.SEED, MerlinUtil.newSeed());
            }
            Undo.end(md);
        }
    }
}

