/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.Visibility;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.property.PropertyDefs;
import merlin.gui.PathObjsList;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.gui.AObjsList;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.dialogs.FindAdvancedDialog;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.IPropComparisonEd;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.PropValue;

public class FindAdvancedAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK_FIND_ADVANCED = new UIHook((MerlinOp)new FindAdvancedAction(false), Intl.intl("&Find Advanced...,Find an object by property value,Find an object by property value"), null);
    public static final UIHook UI_HOOK_FIND_ADVANCED_IN_SELECTION = new UIHook((MerlinOp)new FindAdvancedAction(true), Intl.intl("&Find Advanced in Selection...,Find an object in the current selection by property value,Find an object in the current selection by property value"), null);
    private final boolean d_inSelection;

    public FindAdvancedAction(boolean inSelection) {
        this.d_inSelection = inSelection;
        MerlinApp.getApp().getData().getEvents().addObserver(this);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (this.d_inSelection) {
            IdentityHashSet<IMerlinObj> objs = new IdentityHashSet<IMerlinObj>(md.selection.flatten(IMerlinObj.class));
            FindAdvancedDialog<MerlinData, IMerlinObj> dlg = new FindAdvancedDialog<MerlinData, IMerlinObj>((Window)app.getMainFrame(), Intl.intl("Advanced Search in Selection"), new AppCallback(md), objs);
            dlg.doModeless();
        } else {
            FindAdvancedDialog<MerlinData, IMerlinObj> dlg = new FindAdvancedDialog<MerlinData, IMerlinObj>((Window)app.getMainFrame(), Intl.intl("Advanced Search"), new AppCallback(md), null);
            dlg.doModeless();
        }
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.hasAddedObjs() || changelog.containsChange(MerlinData.SELECTION_CHANGED) || changelog.containsChange(MerlinData.MODEL_RESET) || changelog.containsChange(MerlinData.MODEL_LOADED)) {
            MerlinData md = MerlinApp.getAppData();
            assert (md != null);
            UI_HOOK_FIND_ADVANCED_IN_SELECTION.getMerOp().setEnabled(!md.selection.isEmpty());
        }
    }

    static class AppCallback
    implements FindAdvancedDialog.IAppCallback<MerlinData, IMerlinObj> {
        private final MerlinData d_md;

        AppCallback(MerlinData data) {
            this.d_md = data;
        }

        @Override
        public MerlinData getDomain() {
            return this.d_md;
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public FindAdvancedDialog.IReadLock getReadLock() {
            MerlinData.ReadLock lock = this.d_md.lockRead();
            return () -> lock.close();
        }

        @Override
        public Consumer<IMerlinObj> selectNext(String undoMsg) {
            return obj -> {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (MerlinData.WriteLock lock = this.d_md.lockWrite();){
                        Undo.begin(undoMsg);
                        Undo.insertUndoEntry_restoreSelection(this.d_md);
                        this.d_md.selection.set(obj);
                        Undo.end(this.d_md);
                    }
                });
                UIHook.run(MerlinApp.getApp().getActiveFrame(), "FindAdvancedAction.AppCallback.selectNext()", op, 0);
            };
        }

        @Override
        public Collection<?> getEntryPointChildren() {
            ArrayList<Object> mdChildrenPlusExtras = new ArrayList<Object>();
            mdChildrenPlusExtras.addAll(EntryPointFactory.get(this.d_md).tvEntryPoint.getChildren(this.d_md, this.d_md));
            mdChildrenPlusExtras.add(this.d_md.scenarios);
            mdChildrenPlusExtras.add(this.d_md.customScripts);
            mdChildrenPlusExtras.add(this.d_md.json);
            return mdChildrenPlusExtras;
        }

        @Override
        public Collection<IMerlinObj> getFlatDescendentsIfComposite(Object obj) {
            if (obj instanceof Composite) {
                Composite composite = (Composite)obj;
                return composite.flatten();
            }
            return List.of();
        }

        @Override
        public ConvexHull[] getVisibleFloorHulls() {
            return Visibility.getVisibleFloorHulls(this.d_md);
        }

        @Override
        public boolean isVisible(IMerlinObj obj, ConvexHull[] visibleFloorHulls) {
            return Visibility.isVisible(this.d_md, obj, visibleFloorHulls);
        }

        @Override
        public PropValue<?> getPropValWithDetails(IMerlinObj obj, IDisplayProp<?> prop) {
            return obj.getWithDetails(prop.asProp());
        }

        @Override
        public AObjsList<IMerlinObj> makeObjsList(String desc, boolean linkSelection, boolean autoSort, Collection<? extends IMerlinObj> objs) {
            return new PathObjsList(this.d_md, desc, linkSelection, autoSort, objs);
        }

        @Override
        public void selectAllSearchResults(List<IMerlinObj> objs, String undoMsg) {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (MerlinData.WriteLock lock = this.d_md.lockWrite();){
                    Undo.begin(undoMsg);
                    Undo.insertUndoEntry_restoreSelection(this.d_md);
                    this.d_md.selection.set(objs);
                    Undo.end(this.d_md);
                }
            });
            UIHook.run(MerlinApp.getApp().getActiveFrame(), "FindAdvancedAction.AppCallback.selectAllSearchResults()", op, 0);
        }

        @Override
        public IPropComparisonEd<?, ?> getPropertyEditor(Class<?> type, IDisplayProp<?> prop, guiPanel d_propertiesPanel) {
            return EntryPointFactory.get(type).getPropertyDefs(this.d_md).getAttrComparisonEditor(prop.asProp()).get(d_propertiesPanel, this.d_md);
        }

        @Override
        public ArrayList<Class<?>> getUnsortedObjTypes() {
            ArrayList objTypes = new ArrayList();
            for (EntryPoint ep : EntryPointFactory.getAll()) {
                PropertyDefs defs = ep.getPropertyDefs(this.d_md);
                if (!ep.isSearchType(this.d_md) || defs == null || !defs.props().stream().anyMatch(prop -> defs.getAttrComparisonEditor(prop) != null)) continue;
                objTypes.add(ep.clazz);
            }
            return objTypes;
        }

        @Override
        public PropertyDefsFramework<?, ?> getProps(Class<?> type) {
            return EntryPointFactory.get(type).getPropertyDefs(this.d_md);
        }

        @Override
        public String getCategoryName(Class clazz) {
            return EntryPointFactory.get(clazz).getCategoryName(this.d_md, null);
        }
    }
}

