/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CompElementActions;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.CompositePropertyUtil;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.CachedSupplier;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class EnableAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_ENABLE_HOOK = new UIHook(new EnableAction(true), Intl.intl("Enable"));
    public static final UIHook UI_DISABLE_HOOK = new UIHook(new EnableAction(false), Intl.intl("Disable"));
    private final boolean d_enable;

    public EnableAction(boolean enable) {
        this.d_enable = enable;
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.updateEnabled();
    }

    @Override
    public void update(Events events) {
        IEventRecord<IMerlinObj> evts = events.getEvents(IMerlinObj.class, new Class[0]);
        if (evts.hasChangedObjs(MerlinData.SELECTION_CHANGED, MerlinData.ENABLED) || evts.hasRemovedObjs() || evts.hasAddedObjs()) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        MerlinData md = MerlinApp.getApp().getData();
        Set sel = md.selection.getSelected(IMerlinObj.class);
        Set<TypedProp<?>> sharedProps = CompositePropertyUtil.getSupportedProps(IMerlinObj.SupportMode.UNION, sel);
        if (!sharedProps.contains(MerlinData.ENABLED)) {
            this.setEnabled(false);
            return;
        }
        PropValue<Boolean> val = CompositePropertyUtil.getValue(MerlinData.ENABLED, sel);
        if (this.d_enable) {
            this.setEnabled(val.isEmptyOrNull() || val.get() == false);
        } else {
            this.setEnabled(val.isEmptyOrNull() || val.get() != false);
        }
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        String undoName = this.d_enable ? Intl.intl("Enable") : Intl.intl("Disable");
        Set<IMerlinObj> sel = md.selection.getDeepSelected(IMerlinObj.class);
        Optional<Set<IMerlinObj>> allObjs = this.collectAndValidate(sel, app, md);
        if (allObjs.isPresent()) {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(undoName);
                CompElementActions.setProperty(MerlinData.ENABLED, (Collection<? extends IMerlinObj>)allObjs.get(), this.d_enable);
                Undo.end(md);
            }
        }
    }

    private Optional<Set<IMerlinObj>> collectAndValidate(Set<IMerlinObj> sel, MerlinApp app, MerlinData md) {
        IFilteredCollection<AMerlinObj> connObjs;
        IFilteredCollection<AEgressComp> selectedComponents = theUtil.filter(sel, AEgressComp.class);
        IFilteredCollection<OccSourceObj> selectedOccSources = theUtil.filter(sel, OccSourceObj.class);
        IFilteredCollection<EgressAgent> selectedAgents = theUtil.filter(sel, EgressAgent.class);
        CachedSupplier<MerlinDepSnapshot> deps = new CachedSupplier<MerlinDepSnapshot>(md::takeFullDependencySnapshot);
        try (MerlinData.ReadLock lock = md.lockRead();){
            LinkedHashSet<AMerlinObj> connectedObjs = new LinkedHashSet<AMerlinObj>();
            for (AEgressComp comp : selectedComponents) {
                connectedObjs.addAll(comp.getConnObjectsForEnable(md, deps));
            }
            if (this.d_enable) {
                IEgressComp comp;
                for (OccSourceObj occSource : selectedOccSources) {
                    comp = occSource.get(OccSourceObj.PROP_COMPONENT);
                    if (comp == null || !(comp instanceof AEgressComp) || ((AEgressComp)comp).isEnabled()) continue;
                    connectedObjs.add((AEgressComp)comp);
                    connectedObjs.remove(occSource);
                }
                for (EgressAgent agent : selectedAgents) {
                    comp = agent.getRoom();
                    if (comp == null || !(comp instanceof AEgressComp) || ((AEgressComp)comp).isEnabled()) continue;
                    connectedObjs.add((AEgressComp)comp);
                    connectedObjs.remove(agent);
                }
            }
            connObjs = theUtil.filter(connectedObjs, el -> {
                PropValue<Boolean> enabledVal = el.getWithDetails(MerlinData.ENABLED);
                if (enabledVal.isEmpty()) {
                    return false;
                }
                if (enabledVal.get() == this.d_enable) {
                    return false;
                }
                return !sel.contains(el);
            });
        }
        if (!sel.isEmpty() && !this.d_enable) {
            LinkedHashSet referencing = new LinkedHashSet();
            try (MerlinData.ReadLock lock = md.lockRead();){
                deps.get().getObjReferences(IBehaviorAction.class, IEgressComp.class, o -> selectedComponents.contains(o) || o instanceof AMerlinObj && connObjs.contains((AMerlinObj)((Object)o)), (source, link, target) -> referencing.add(source));
                deps.get().getObjReferences(IBehaviorAction.class, Elevator.class, o -> sel.contains(o), (source, link, target) -> referencing.add(source));
            }
            if (!referencing.isEmpty()) {
                guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Objects cannot be disabled"), 17);
                GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
                gb.addRow(String.format(Intl.intl("Objects cannot be disabled, because they are referenced by %d behavior actions."), referencing.size()));
                gb.addRow(Intl.intl("Select referencing behavior actions?"));
                if (dlg.doModal() == 1) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Referencing Behaviors"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.clear();
                        md.selection.selectAll(referencing);
                        Undo.end(md);
                    }
                }
                return Optional.empty();
            }
        }
        if (!connObjs.isEmpty()) {
            String title;
            String msg;
            int choice;
            IFilteredCollection<EgressAgent> agents = theUtil.filter(connObjs, EgressAgent.class);
            IFilteredCollection<EgressRoom> rooms = theUtil.filter(connObjs, EgressRoom.class);
            IFilteredCollection<EgressCorridor> corridors = theUtil.filter(connObjs, EgressCorridor.class);
            IFilteredCollection<EgressDoor> doors = theUtil.filter(connObjs, EgressDoor.class);
            IFilteredCollection<OccSourceObj> occSources = theUtil.filter(connObjs, OccSourceObj.class);
            Object connObjMsg = "";
            boolean addSep = false;
            if (!agents.isEmpty()) {
                connObjMsg = (String)connObjMsg + String.format(agents.size() == 1 ? Intl.intl("%d occupant") : Intl.intl("%d occupants"), agents.size());
                addSep = true;
            }
            if (!rooms.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(rooms.size() == 1 ? Intl.intl("%d room") : Intl.intl("%d rooms"), rooms.size());
                addSep = true;
            }
            if (!corridors.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(corridors.size() == 1 ? Intl.intl("%d stair/ramp") : Intl.intl("%d stairs/ramps"), corridors.size());
                addSep = true;
            }
            if (!doors.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(doors.size() == 1 ? Intl.intl("%d door") : Intl.intl("%d doors"), doors.size());
                addSep = true;
            }
            if (!occSources.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(occSources.size() == 1 ? Intl.intl("%d occupant source") : Intl.intl("%d occupant sources"), occSources.size());
                addSep = true;
            }
            if ((choice = md.ui(() -> EnableAction.lambda$collectAndValidate$5(app, msg = String.format(this.d_enable ? Intl.intl("Other connected objects (%s) will be enabled.\n Do you still want to enable selected objects?") : Intl.intl("Other connected objects (%s) will be disabled.\n Do you still want to disable selected objects?"), connObjMsg), title = this.d_enable ? Intl.intl("Enable?") : Intl.intl("Disable?"))).intValue()) != 0) {
                return Optional.empty();
            }
        }
        LinkedHashSet<IMerlinObj> collectedObjs = new LinkedHashSet<IMerlinObj>(sel);
        connObjs.forEach(o -> collectedObjs.add((IMerlinObj)o));
        return Optional.of(collectedObjs);
    }

    private static /* synthetic */ Integer lambda$collectAndValidate$5(MerlinApp app, String msg, String title) throws Exception {
        return JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, title, 0);
    }
}

