/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoGeomBuilder;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.SimParams;
import merlin.gui.EditSimParamsDlg;

public class EditSimParams
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditSimParams(), Intl.intl("Simulation &Parameters...,-,Edit Simulation Parameters"));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        EditSimParamsDlg d_dlg = null;
        if (d_dlg == null) {
            d_dlg = new EditSimParamsDlg(app.getMainFrame(), md);
        }
        SimParams p = md.simParams;
        d_dlg.load(p, md.scenarios.getActive(), false);
        if (d_dlg.doModal() == 1 && d_dlg.isModified()) {
            InfernoGeomBuilder.Param oldRefOpt = p.getMeshBuilderParams();
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Edit Simulation Parameters"));
                d_dlg.store(md, p, false);
                Undo.end(md);
            }
            md.pauseUpdates();
            md.getEvents().changed(md, MerlinData.SIM_PARAMS_CHANGED);
            if (!oldRefOpt.equals(p.getMeshBuilderParams())) {
                md.getEvents().changed(md, MerlinData.MESH_CHANGED);
            }
            md.resumeUpdates();
        }
    }
}

